/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.featurestore;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.featurestore.FeatureGroupDetails;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.catalog.LuceneIndexException;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.internal.IInternalDataCatalogService;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.classic.ParseException;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FeatureStoreService {
    @Autowired
    private IInternalDataCatalogService catalogService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private ExposedObjectsService exposedObjectsService;

    public List<FeatureGroupId> getFeatureGroups(AuthCtx user, @Nullable String explainDocId, @Nullable String explainDocType) throws Exception {
        ArrayList<FeatureGroupId> results = new ArrayList<FeatureGroupId>();
        Map<String, List<String>> facetMap = Collections.singletonMap("scope", Lists.newArrayList((Object[])new String[]{"dss"}));
        BooleanQuery.Builder objFilterBuilder = new BooleanQuery.Builder();
        objFilterBuilder.add((Query)new TermQuery(new Term("featureGroup", "true")), BooleanClause.Occur.MUST);
        LuceneResponseWrapper resultsLucene = this.catalogService.searchInternal("*", facetMap, user, IInternalDataCatalogService.Options.getDefaultOptions().withExplainDocId(explainDocId).withExplainDocType(explainDocType), (Query)objFilterBuilder.build());
        for (LuceneResponseWrapper.Hit hit : resultsLucene.hits) {
            Map source = hit._source;
            results.add(new FeatureGroupId(source.get("projectKey").toString(), source.get("name").toString()));
        }
        return results;
    }

    public LuceneResponseWrapper searchFeatureGroups(String queryString, Map<String, List<String>> facetMap, AuthCtx user, @Nullable String explainDocId) throws ParseException, IOException, LuceneIndexException, DKUSecurityException {
        BooleanQuery objFilter = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("featureGroup", String.valueOf(true))), BooleanClause.Occur.MUST).build();
        return this.catalogService.searchDataset(queryString, facetMap, user, IInternalDataCatalogService.Options.getDefaultOptions().withAccurateTotalHits(true).withExplainDocId(explainDocId).withExplainDocType(IndexableType.DATASET.index()), (Query)objFilter);
    }

    public LuceneResponseWrapper searchFeatures(String queryString, Map<String, List<String>> facetMap, AuthCtx user, @Nullable String explainDocId) throws LuceneIndexException, ParseException, IOException, DKUSecurityException {
        BooleanQuery objFilter = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("fromFeatureGroup", String.valueOf(true))), BooleanClause.Occur.MUST).build();
        IInternalDataCatalogService.Options options = IInternalDataCatalogService.Options.getDefaultOptions().withAggregations(true).withAccurateTotalHits(true).withExplainDocId(explainDocId);
        return this.catalogService.searchColumn(queryString, facetMap, user, options, (Query)objFilter);
    }

    public FeatureGroupDetails getDetails(AuthCtx user, String projectKey, String datasetName) throws IOException, DKUSecurityException {
        ProjectFlowGraph flowGraph = this.flowGraphService.getProjectGraphUnsafe(projectKey);
        FlowDataset flowDataset = flowGraph.getDataset(projectKey, datasetName);
        Set<FeatureGroupDetails.ComputableByType> inputs = this.getInputs(flowDataset.getPredecessors(), new HashSet<GraphNode>(), projectKey);
        Set<FeatureGroupDetails.ComputableByType> outputs = this.getOutputs(flowDataset.getSuccessors(), new HashSet<GraphNode>(), projectKey);
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.getUnsafe();
        return new FeatureGroupDetails(this.exposedObjectsService.getUsages(user, projectKey, datasetName, ITaggingService.TaggableType.DATASET), sp.name, this.projectsService.isAccessRequestsEnabled(sp, generalSettings), inputs.stream().collect(Collectors.groupingBy(FeatureGroupDetails.ComputableByType::getType, Collectors.toSet())), outputs.stream().collect(Collectors.groupingBy(FeatureGroupDetails.ComputableByType::getType, Collectors.toSet())));
    }

    private Set<FeatureGroupDetails.ComputableByType> getInputs(List<? extends GraphNode> nodes, Set<GraphNode> visited, String contextProjectKey) {
        HashSet<FeatureGroupDetails.ComputableByType> results = new HashSet<FeatureGroupDetails.ComputableByType>();
        for (GraphNode graphNode : nodes) {
            if (!visited.add(graphNode)) continue;
            if (graphNode instanceof FlowComputable) {
                FlowComputable flowComputable = (FlowComputable)graphNode;
                if (flowComputable.getPredecessors().isEmpty()) {
                    results.add(new FeatureGroupDetails.ComputableByType(flowComputable.getRef(contextProjectKey), flowComputable.getType().name()));
                    continue;
                }
                results.addAll(this.getInputs(flowComputable.getPredecessors(), visited, contextProjectKey));
                continue;
            }
            if (!(graphNode instanceof FlowRunnable)) continue;
            results.addAll(this.getInputs(graphNode.getPredecessors(), visited, contextProjectKey));
        }
        return results;
    }

    private Set<FeatureGroupDetails.ComputableByType> getOutputs(List<? extends GraphNode> nodes, Set<GraphNode> visited, String contextProjectKey) {
        HashSet<FeatureGroupDetails.ComputableByType> results = new HashSet<FeatureGroupDetails.ComputableByType>();
        for (GraphNode graphNode : nodes) {
            if (!visited.add(graphNode)) continue;
            if (graphNode instanceof FlowComputable) {
                FlowComputable flowComputable = (FlowComputable)graphNode;
                if (flowComputable.getSuccessors().isEmpty()) {
                    results.add(new FeatureGroupDetails.ComputableByType(flowComputable.getRef(contextProjectKey), flowComputable.getType().name()));
                    continue;
                }
                results.addAll(this.getOutputs(flowComputable.getSuccessors(), visited, contextProjectKey));
                continue;
            }
            if (!(graphNode instanceof FlowRunnable)) continue;
            results.addAll(this.getOutputs(graphNode.getSuccessors(), visited, contextProjectKey));
        }
        return results;
    }

    public static class FeatureGroupId {
        public String projectKey;
        public String name;

        public FeatureGroupId(String projectKey, String name) {
            this.projectKey = projectKey;
            this.name = name;
        }
    }
}

