/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.execution;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AlphanumComparator
implements Comparator<String> {
    @Override
    public int compare(String str1, String str2) {
        int compareResult;
        if (str1 == null) {
            return str2 == null ? 0 : -1;
        }
        if (str2 == null) {
            return 1;
        }
        Cursor cursor1 = new Cursor(str1);
        Cursor cursor2 = new Cursor(str2);
        do {
            cursor1.move();
            cursor2.move();
        } while ((compareResult = cursor1.compareTo(cursor2)) == 0 && cursor1.hasNext() && cursor2.hasNext());
        return compareResult != 0 ? compareResult : (cursor1.hasNext() ? 1 : (cursor2.hasNext() ? -1 : 0));
    }

    private static class Cursor {
        private static final Pattern DIGITS = Pattern.compile("\\d+");
        private final String str;
        private final Matcher matcher;
        private int index = 0;
        private String chunk;
        private String digit;

        public Cursor(String str) {
            this.str = str;
            this.matcher = DIGITS.matcher(str);
        }

        private boolean hasNext() {
            return this.index >= 0;
        }

        public void move() {
            if (this.matcher.find(this.index)) {
                int start = this.matcher.start();
                int end = this.matcher.end();
                this.digit = this.str.substring(start, end);
                this.chunk = this.str.substring(this.index, start);
                this.index = end;
            } else {
                this.digit = "";
                this.chunk = this.str.substring(this.index);
                this.index = -1;
            }
        }

        public int compareTo(Cursor other) {
            int chunkCompareResult = this.chunk.compareTo(other.chunk);
            if (chunkCompareResult != 0) {
                return chunkCompareResult;
            }
            int digitCompareResult = Cursor.compareDigits(this.digit, other.digit);
            if (digitCompareResult != 0) {
                return digitCompareResult;
            }
            return 0;
        }

        private static int compareDigits(String str1, String str2) {
            int cmpLength = str1.length() - str2.length();
            if (cmpLength != 0) {
                return cmpLength;
            }
            return str1.compareTo(str2);
        }
    }
}

