/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hadoop;

import com.dataiku.dip.hive.HdfsPathSubstitution;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class HDFSSafeDataHandler {
    private static Logger logger = Logger.getLogger((String)"dku.hadoop.safe");

    public static String getTmpPath(String hdfsPath) {
        if (hdfsPath.endsWith("/")) {
            return hdfsPath.substring(0, hdfsPath.length() - 1) + "__dkutmp__/";
        }
        return hdfsPath + "__dkutmp__/";
    }

    public static void removeTargetTmpEntries(List<HdfsPathSubstitution> hdfsPathSubsts) throws IOException {
        for (HdfsPathSubstitution hdfsPath : hdfsPathSubsts) {
            FileSystem fs = hdfsPath.fs;
            Path tmpPath = new Path(hdfsPath.src);
            if (!fs.exists(tmpPath)) continue;
            fs.delete(tmpPath, true);
        }
    }

    public static void moveToFinalLocations(List<HdfsPathSubstitution> hdfsPathSubsts) throws IOException {
        for (HdfsPathSubstitution hdfsPath : hdfsPathSubsts) {
            Path tmpPath = new Path(hdfsPath.src);
            Path finalPath = new Path(hdfsPath.dst);
            FileSystem fs = hdfsPath.fs;
            Path backupPath = new Path(hdfsPath.dst.substring(0, hdfsPath.dst.length() - 1) + "__dkubck");
            if (fs.exists(backupPath)) {
                fs.delete(backupPath, true);
            }
            boolean hasBackup = false;
            if (fs.exists(finalPath)) {
                logger.info((Object)("Target exists, backing it up to " + String.valueOf(backupPath)));
                if (!fs.rename(finalPath, backupPath)) {
                    throw new IOException("Renaming backup failed, but I don't know why");
                }
                hasBackup = true;
            }
            try {
                logger.info((Object)("Moving " + String.valueOf(tmpPath) + " to " + String.valueOf(finalPath)));
                if (!(fs.exists(finalPath.getParent()) && fs.getFileStatus(finalPath.getParent()).isDirectory() || fs.mkdirs(finalPath.getParent()))) {
                    throw new IOException("Mkdirs fail, but I don't why");
                }
                if (!fs.rename(tmpPath, finalPath)) {
                    throw new IOException("Renaming fail, but I don't know why");
                }
            }
            catch (IOException e) {
                if (hasBackup) {
                    logger.error((Object)"Failed to save output data, restoring backup", (Throwable)e);
                    fs.rename(backupPath, finalPath);
                } else {
                    logger.error((Object)"Failed to save output data", (Throwable)e);
                }
                throw e;
            }
            if (hasBackup) {
                logger.info((Object)"Rename successful, deleting backup");
                fs.delete(backupPath, true);
                continue;
            }
            logger.info((Object)"Rename successful");
        }
    }

    public static void moveDirectory(FileSystem fs, String oldDir, String newDir) throws IOException {
        Path oldPath = new Path(oldDir);
        Path newPath = new Path(newDir);
        FileStatus oldStatus = fs.getFileStatus(oldPath);
        if (!oldStatus.isDirectory()) {
            throw new IOException("error moving HDFS directory " + oldDir + " to " + newDir + " : not a directory");
        }
        try {
            fs.getFileStatus(newPath);
            throw new IOException("error moving HDFS directory " + oldDir + " to " + newDir + " : destination exists");
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!fs.mkdirs(newPath.getParent())) {
                throw new IOException("error creating HDFS parent directory for " + newDir);
            }
            if (!fs.rename(oldPath, newPath)) {
                throw new IOException("error moving HDFS directory " + oldDir + " to " + newDir);
            }
            return;
        }
    }
}

