/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.formats.FixedWidthFormatExtractor;
import com.dataiku.dip.input.formats.InputFormatsDetector;
import com.dataiku.dip.input.formats.LineOrientedFormatDetector;
import com.dataiku.dip.input.formats.LineOrientedInputSample;
import com.dataiku.dip.input.utils.ByteArrayInputStreamInput;
import com.dataiku.dip.utils.LongList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FixedWidthFormatDetector
extends LineOrientedFormatDetector {
    private static Logger logger = Logger.getLogger((String)"dku.formats.detect");

    public InputFormatsDetector.FormatWithMetadata detect(LineOrientedInputSample sample) throws Exception {
        if (sample.hadHugeLines) {
            return null;
        }
        List<Integer> offsets = this.detectWithConstantSpaces(sample.lines);
        if (offsets.size() <= 1) {
            return null;
        }
        FixedWidthFormatExtractor.Config config = new FixedWidthFormatExtractor.Config();
        config.charset = sample.usedCharset;
        config.offsets = StringUtils.join(offsets, (String)",");
        MemTable mt = new MemTable();
        FixedWidthFormatExtractor extractor = new FixedWidthFormatExtractor(config);
        extractor.setLimit(new ExtractionLimit(10L));
        try (ByteArrayInputStreamInput input = new ByteArrayInputStreamInput(sample.allLines.toString().getBytes(sample.usedCharset));){
            extractor.run(input.getSingleSplit(), (ProcessorOutput)new MemTableAppendingOutput(mt), mt, mt);
        }
        logger.debug((Object)("Testing detected offsets " + mt.nrows()));
        if (mt.nrows() > 0) {
            boolean canBeHeaderRow = true;
            for (Column c2 : mt.columns()) {
                String cellValue = mt.rows.get(0).get(c2);
                if (cellValue == null || !StringUtils.isNumeric((String)cellValue)) continue;
                canBeHeaderRow = false;
            }
            if (canBeHeaderRow) {
                config.parseHeaderRow = true;
            }
        }
        InputFormatsDetector.FormatWithMetadata out = new InputFormatsDetector.FormatWithMetadata();
        out.type = "fixed";
        out.detectionScore = 500.0;
        out.params = config;
        return out;
    }

    @Override
    public List<InputFormatsDetector.FormatWithMetadata> detect(LineOrientedInputSample sample, String filename) throws Exception {
        InputFormatsDetector.FormatWithMetadata detected = this.detect(sample);
        return detected != null ? Lists.newArrayList((Object[])new InputFormatsDetector.FormatWithMetadata[]{detected}) : new ArrayList();
    }

    @Override
    public Map<String, String> recomputeMetadata(String autoDetectedFormatId, LineOrientedInputSample sample, String filename) throws Exception {
        return "csv".equals(autoDetectedFormatId) ? new HashMap() : null;
    }

    private List<Integer> detectWithConstantSpaces(List<String> firstLines) {
        HashSet<Integer> constantSpaces = new HashSet<Integer>();
        for (int lineIdx = 0; lineIdx < firstLines.size(); ++lineIdx) {
            String line = firstLines.get(lineIdx);
            for (int c2 = 0; c2 < line.length(); ++c2) {
                if (lineIdx == 0) {
                    if (!StringUtils.isWhitespace((String)("" + line.charAt(c2)))) continue;
                    constantSpaces.add(c2);
                    continue;
                }
                if (StringUtils.isWhitespace((String)("" + line.charAt(c2)))) continue;
                constantSpaces.remove(c2);
            }
            logger.info((Object)("After line " + lineIdx + " cspaces:" + StringUtils.join(constantSpaces, (String)"-")));
            if (lineIdx <= 0) continue;
            LongList toRemove = new LongList();
            for (Integer c2 : constantSpaces) {
                if (c2 < line.length()) continue;
                toRemove.add((long)c2.intValue());
            }
            for (Long i : toRemove) {
                logger.debug((Object)("i " + i + " is invalid for " + line.length()));
                constantSpaces.remove((int)i.longValue());
            }
        }
        if (!constantSpaces.contains(0)) {
            constantSpaces.add(0);
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.addAll(constantSpaces);
        Collections.sort(result);
        ListIterator iterator = result.listIterator();
        Integer prevMatching = 0;
        while (iterator.hasNext()) {
            Integer i = (Integer)iterator.next();
            if (i == prevMatching + 1) {
                iterator.remove();
            }
            prevMatching = i;
        }
        return result;
    }
}

