/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.formats.SplitBasedFixedSchemaDetector;
import com.dataiku.dip.input.formats.parquet.DSSParquetInputFormat;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.util.HadoopUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.security.UserGroupInformation;

public class ParquetFormatExtractor
implements FormatExtractor,
SplitBasedFixedSchemaDetector {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.formats.parquet");
    private final ParquetFormatConfig config;
    private long limit = -1L;
    private Schema schema;
    private WarningsContext warnContext = new WarningsContext();
    private InputSplitProgressListener listener = new InputSplitProgressListener();
    final AtomicLong totalRecords = new AtomicLong();

    public ParquetFormatExtractor(ParquetFormatConfig config) {
        this.config = (ParquetFormatConfig)Preconditions.checkNotNull((Object)config);
    }

    @Override
    public void setLimit(ExtractionLimit limit) {
        this.limit = limit == null ? -1L : limit.maxRecords;
    }

    @Override
    public boolean canSetSchemaForExtractor() {
        return true;
    }

    @Override
    public void setSchema(Schema schema, boolean allowExtraColumns) {
        this.schema = schema;
    }

    @Override
    public void setProgressListener(InputSplitProgressListener listener) {
        this.listener = listener;
    }

    @Override
    public void setWarningsContext(WarningsContext warnContext) {
        if (warnContext != null) {
            this.warnContext = warnContext;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean run(StreamsInputSplit in, ProcessorOutput out, ColumnFactory cf, RowFactory rf) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Schema detectSchema(StreamsInputSplit in) throws Exception {
        EnrichedInputStream eis;
        logger.info((Object)"Run Parquet schema detector");
        while ((eis = in.nextStream()) != null) {
            if (!(eis instanceof HDFSProvider.HDFSInputStream)) {
                throw ErrorContext.iae((String)"Parquet is not supported on non-HDFS datasets");
            }
            final HDFSProvider.HDFSInputStream hdfsEis = (HDFSProvider.HDFSInputStream)eis;
            UserGroupInformation ugi = hdfsEis.getUGI();
            final Path hdfsPath = hdfsEis.getFSPath();
            logger.info((Object)("Detecting Schema on Parquet input:" + String.valueOf(hdfsPath) + " with ugi: " + String.valueOf(ugi)));
            Schema potential = (Schema)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Schema>(){

                @Override
                public Schema run() throws IOException, InterruptedException {
                    Configuration conf = hdfsEis.setupHadoopConf(false);
                    Job job = new Job(conf);
                    TaskAttemptContext tac = HadoopUtils.createTaskattemptContext(job, 0);
                    StreamColumnFactory cf = new StreamColumnFactory();
                    StreamRowFactory rf = new StreamRowFactory();
                    DSSParquetInputFormat format = new DSSParquetInputFormat((ColumnFactory)cf, (RowFactory)rf, ParquetFormatExtractor.this.config.representsNullFields, ParquetFormatExtractor.this.config.parquetFlavor, ParquetFormatExtractor.this.schema, ParquetFormatExtractor.this.config.readTemporalMode);
                    FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{hdfsPath});
                    for (InputSplit split : format.getSplits((JobContext)job)) {
                        RecordReader<Void, Row> recordReader = format.createRecordReader(split, tac);
                        try {
                            recordReader.initialize(split, tac);
                            Schema detected = format.getDetectedSchema();
                            if (detected == null) continue;
                            Schema schema = detected;
                            return schema;
                        }
                        finally {
                            if (recordReader == null) continue;
                            recordReader.close();
                        }
                    }
                    return null;
                }
            });
            if (potential == null) continue;
            return potential;
        }
        throw new IOException("Unable to determine the schema of this Parquet dataset");
    }

    static class RecordReaderAbortHook
    implements Runnable {
        private RecordReader<?, ?> recordReader;

        RecordReaderAbortHook(RecordReader<?, ?> recordReader) {
            this.recordReader = recordReader;
        }

        @Override
        public void run() {
            try {
                logger.info((Object)"Abort reading parquet file");
                this.recordReader.close();
            }
            catch (IOException e) {
                logger.error((Object)"Failed to close the record reader when aborting.", (Throwable)e);
            }
        }
    }
}

