/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetOutputWriter;
import com.dataiku.dip.output.CanListFilesWrittenTo;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class ParquetOutput
implements Output,
CanListFilesWrittenTo {
    private static Logger logger = Logger.getLogger(ParquetOutput.class);
    private final WarningsContext warningsContext;
    private final ParquetFormatConfig config;
    private Partition targetPartition;
    private int targetSplit;
    private final Dataset dataset;
    private final HDFSProvider provider;

    public ParquetOutput(HDFSProvider provider, Dataset dataset, Partition targetPartition, int targetSplit, WarningsContext ctx, ParquetFormatConfig config) {
        this.provider = provider;
        this.dataset = dataset;
        this.targetPartition = targetPartition;
        this.targetSplit = targetSplit;
        this.warningsContext = ctx == null ? new WarningsContext() : ctx;
        this.config = config;
    }

    public OutputWriter getWriter(Output.WriteMode mode) throws IOException, DKUSecurityException {
        assert (mode == Output.WriteMode.APPEND);
        return new ParquetOutputWriter(this.provider, this.dataset, this.targetPartition, this.targetSplit, this.warningsContext, this.config);
    }

    public List<String> list(OutputWriter writer) throws IOException, InterruptedException {
        return ((ParquetOutputWriter)writer).gatherWritesInProgress();
    }

    public List<String> recoverList() throws IOException, CodedException, DKUSecurityException {
        return Lists.newArrayList((Object[])new String[]{"/_temporary"});
    }
}

