/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.misc;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.integrations.AbstractIntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.IntegrationChannelMeta;
import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.integrations.IntegrationParams;
import com.dataiku.dip.scheduler.IntegrationChannelsDAO;
import com.dataiku.dip.scheduler.reports.ScenarioReportEvent;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IntegrationChannelPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;

public class ShellScenarioIntegrationHandler
extends AbstractIntegrationEventHandler {
    public static final IntegrationChannelMeta CHANNEL_META = new IntegrationChannelMeta(){

        public Class<? extends IntegrationChannelParams> paramsClass() {
            return ShellCommandChannelConfiguration.class;
        }

        public String getType() {
            return "shell";
        }

        public String getAssociatedIntegrationType() {
            return "shell-scenario";
        }
    };
    public static final IntegrationMeta SCENARIO_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "shell-scenario";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return ShellCommandMessagingConfiguration.class;
        }

        @Override
        public ShellScenarioIntegrationHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new ShellScenarioIntegrationHandler(authCtx, messaging.getConfigurationAs(ShellCommandMessagingConfiguration.class), permissionCheckContext);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
        }
    };
    private final ShellCommandChannelConfiguration channelParams;
    private final ShellCommandMessagingConfiguration params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.sender.shell");

    public ShellScenarioIntegrationHandler(AuthCtx authCtx, ShellCommandMessagingConfiguration params, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
        IntegrationChannel channel;
        this.params = params;
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        IntegrationChannelsDAO dao = (IntegrationChannelsDAO)SpringUtils.getBean(IntegrationChannelsDAO.class);
        IntegrationChannelPermissionsService integrationChannelPermissionsService = (IntegrationChannelPermissionsService)SpringUtils.getBean(IntegrationChannelPermissionsService.class);
        try (Transaction t = transactionService.beginRead();){
            channel = dao.getMandatory(params.channelId);
        }
        if (permissionCheckContext.checkCanUseIntegrationChannel) {
            integrationChannelPermissionsService.checkIntegrationChannelUse(authCtx, channel);
        }
        this.channelParams = (ShellCommandChannelConfiguration)channel.getConfigurationAs(ShellCommandChannelConfiguration.class);
    }

    @Override
    public void handleEvent(DSSEvent event, InfoMessage.InfoMessages messages) throws Exception {
        ScenarioReportEvent sre = (ScenarioReportEvent)event;
        StrSubstitutor substitutor = new StrSubstitutor((StrLookup)sre.lookup);
        try (AutoDelete tmpDir = FlowJobUtils.getTmpFolder("shell-integration", "shellsend");){
            ProcessBuilder pb;
            if (this.channelParams.type == ShellSenderType.COMMAND) {
                pb = new ProcessBuilder("sh", "-c", this.channelParams.command);
            } else {
                File scriptFile = new File((File)tmpDir, "send_script");
                FileUtils.write((File)scriptFile, (CharSequence)this.channelParams.script);
                pb = StringUtils.isBlank((String)this.channelParams.command) ? new ProcessBuilder("sh", scriptFile.getAbsolutePath()) : new ProcessBuilder("sh", "-c", this.channelParams.command, scriptFile.getAbsolutePath());
            }
            pb.directory((File)tmpDir);
            if (this.params.sendEverythingAsVariables) {
                for (Map.Entry entry : sre.lookup.getAllVariablesForEnv().entrySet()) {
                    if (StringUtils.isBlank((String)((String)entry.getKey()))) {
                        logger.warn((Object)"Variable without name. Skipping");
                        continue;
                    }
                    if (StringUtils.isBlank((String)((String)entry.getValue()))) {
                        logger.info((Object)("Variable for shell " + (String)entry.getKey() + " = "));
                        pb.environment().remove(entry.getKey());
                        continue;
                    }
                    logger.info((Object)("Variable for shell " + (String)entry.getKey() + " = " + (String)entry.getValue()));
                    pb.environment().put((String)entry.getKey(), (String)entry.getValue());
                }
            } else {
                for (SimpleKeyValue simpleKeyValue : this.params.variables) {
                    if (StringUtils.isBlank((String)simpleKeyValue.key)) {
                        logger.warn((Object)"Variable without name. Skipping");
                        continue;
                    }
                    String value = StringUtils.isBlank((String)simpleKeyValue.value) ? null : substitutor.replace(simpleKeyValue.value);
                    logger.info((Object)("Variable for shell " + simpleKeyValue.key + " = " + value));
                    if (!StringUtils.isNotBlank((String)value)) continue;
                    pb.environment().put(simpleKeyValue.key, value);
                }
            }
            DKUtils.execAndLogThrows((ProcessBuilder)pb);
        }
    }

    public static class ShellCommandMessagingConfiguration
    implements IntegrationParams {
        public String channelId;
        public boolean sendEverythingAsVariables = false;
        public List<SimpleKeyValue> variables = Lists.newArrayList();
    }

    public static class ShellCommandChannelConfiguration
    implements IntegrationChannelParams {
        public ShellSenderType type = ShellSenderType.COMMAND;
        public String command;
        public String script;
    }

    public static enum ShellSenderType {
        FILE,
        COMMAND;

    }
}

