/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm;

import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMAuditHelper;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.governance.GuardrailsPipelineUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMMeshStreamClient;
import com.dataiku.dip.llm.promptstudio.PromptResponse;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.promptstudio.PromptStudiosCRUDService;
import com.dataiku.dip.llm.utils.StreamingChunkEmitter;
import com.dataiku.dip.recipes.nlp.common.LLMCompletionSettings;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageReportingService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.endpoints.httpsse.MiniSSEEmitter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PromptChatClient {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ComputeResourceUsageReportingService cruReportingService;
    @Autowired
    private PromptStudiosCRUDService promptStudiosCrudService;
    private final AuthCtx authCtx;
    private final PromptChat promptChat;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.promptchat.client");

    public PromptChatClient(AuthCtx authCtx, PromptChat promptChat) {
        this.authCtx = authCtx;
        this.promptChat = promptChat;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public PromptResponse.SingleInputPromptResponse streamChatResponse(MiniSSEEmitter emitter) throws Exception {
        LLMClient.SimpleCompletionResponseOrError scre;
        this.promptChat.lastUserMessage.runBy = this.authCtx.getIdentifier();
        if (!this.promptChat.messages.containsKey(this.promptChat.lastUserMessage.id)) {
            this.addNewChatMessage(this.promptChat.lastUserMessage);
        }
        LLMClient.SingleCompletionQuery query = this.getStreamableCompletionRequestFromPrompt();
        GuardrailsPipelineSettings connectionGuardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings(this.authCtx, this.promptChat.projectKey, this.promptChat.enrichedLLMRef);
        GuardrailsPipelineSettings guardrailsPipelineSettings = GuardrailsPipelineUtils.mergeEnforcementSettings(connectionGuardrailsPipelineSettings, this.promptChat.guardrailsPipelineSettings);
        AbstractLLMConnection connection = null;
        LLMClient.CompletionSettings completionSettings = this.promptChat.llmSettings.toFullSettings();
        logger.info((Object)("Sending single completion query to LLM:  " + JSON.json((Object)query)));
        StreamingChunkEmitter streamingChunkEmitter = new StreamingChunkEmitter(emitter);
        try (LLMMeshStreamClient streamClient = new LLMMeshStreamClient(this.authCtx, this.promptChat.projectKey, this.promptChat.enrichedLLMRef, guardrailsPipelineSettings, this.promptChat.streamingDisabled, this.promptChat.useDevKernel, streamingChunkEmitter);){
            streamClient.enableEmulatedStreamingInfoChunk();
            connection = streamClient.getConnection();
            scre = streamClient.streamComplete(query, completionSettings);
            ComputeResourceUsage cru = streamClient.getTotalCRU();
            if (cru != null) {
                this.cruReportingService.reportComplete(cru);
            }
        }
        catch (Exception e) {
            scre = LLMClient.SimpleCompletionResponseOrError.fromError(e);
        }
        LLMAuditHelper.emitLLMCompletionAuditFromBackendIfNeeded(this.auditTrailService, this.promptChat.enrichedLLMRef, connection, query, scre);
        PromptStudio.ConversationMessage assistantMessage = this.buildAssistantMessage(scre);
        return this.buildSingleInputPromptResponse(assistantMessage, scre);
    }

    private void addNewChatMessage(PromptStudio.ConversationMessage newMessage) {
        if (this.promptChat.messages.isEmpty()) {
            PromptStudio.ConversationMessage parentMessage = new PromptStudio.ConversationMessage();
            this.promptChat.messages.put(parentMessage.id, parentMessage);
            newMessage.parentId = parentMessage.id;
        }
        newMessage.version = (int)this.promptChat.messages.values().stream().filter(message -> Objects.equals(message.parentId, newMessage.parentId)).count();
        this.promptChat.messages.put(newMessage.id, newMessage);
    }

    private LLMClient.SingleCompletionQuery getStreamableCompletionRequestFromPrompt() {
        LLMClient.SingleCompletionQuery query = new LLMClient.SingleCompletionQuery();
        query.messages = new ArrayList<LLMClient.ChatMessage>();
        query.messages.add(this.promptChat.lastUserMessage.message);
        String parentId = this.promptChat.lastUserMessage.parentId;
        while (parentId != null) {
            PromptStudio.ConversationMessage parentMessage = this.promptChat.messages.get(parentId);
            if (parentMessage.message != null) {
                query.messages.add(0, parentMessage.message);
            }
            parentId = parentMessage.parentId;
        }
        if (this.promptChat.systemMessage != null && !this.promptChat.systemMessage.isBlank()) {
            LLMClient.ChatMessage systemChatMessage = new LLMClient.ChatMessage();
            systemChatMessage.role = "system";
            systemChatMessage.setTextOnly(this.promptChat.systemMessage);
            query.messages.add(0, systemChatMessage);
        }
        return query;
    }

    private PromptStudio.ConversationMessage buildAssistantMessage(LLMClient.SimpleCompletionResponseOrError scre) {
        PromptStudio.ConversationMessage assistantMessage = new PromptStudio.ConversationMessage();
        assistantMessage.parentId = this.promptChat.lastUserMessage.id;
        assistantMessage.message = new LLMClient.ChatMessage("assistant", scre.text);
        if (!scre.ok) {
            assistantMessage.error = true;
            assistantMessage.llmError = scre.errorMessage;
        } else if (StringUtils.isEmpty((String)scre.text)) {
            assistantMessage.error = true;
            assistantMessage.llmError = "LLM response is empty.";
        }
        assistantMessage.completionSettings = this.promptChat.llmSettings;
        assistantMessage.llmStructuredRef = this.promptChat.enrichedLLMRef;
        assistantMessage.systemMessage = this.promptChat.systemMessage;
        assistantMessage.fullTrace = scre.trace;
        assistantMessage.artifacts = scre.artifacts;
        assistantMessage.sources = scre.sources;
        assistantMessage.additionalInformation = scre.additionalInformation;
        this.addNewChatMessage(assistantMessage);
        return assistantMessage;
    }

    private PromptResponse.SingleInputPromptResponse buildSingleInputPromptResponse(PromptStudio.ConversationMessage assistantMessage, LLMClient.SimpleCompletionResponseOrError scre) {
        PromptResponse.SingleInputPromptResponse sipr = new PromptResponse.SingleInputPromptResponse();
        sipr.chatMessages = this.promptChat.messages;
        sipr.lastMessageId = assistantMessage.id;
        this.promptStudiosCrudService.fillSingleInputPromptResponse(sipr, scre);
        return sipr;
    }

    public static class PromptChat {
        public String projectKey;
        public LLMCompletionSettings llmSettings;
        public EnrichedLLMStructuredRef enrichedLLMRef;
        public GuardrailsPipelineSettings guardrailsPipelineSettings;
        public Map<String, PromptStudio.ConversationMessage> messages;
        public PromptStudio.ConversationMessage lastUserMessage;
        public String systemMessage;
        public boolean streamingDisabled;
        public boolean useDevKernel;
    }
}

