/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.governance.custom;

import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.llm.governance.GuardrailMeta;
import com.dataiku.dip.llm.governance.GuardrailParams;
import com.dataiku.dip.llm.governance.GuardrailRunner;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.governance.GuardrailsPipelineUtils;
import com.dataiku.dip.llm.governance.custom.CustomGuardrailRunner;
import com.dataiku.dip.llm.governance.custom.LoadedCustomGuardrail;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.EnumSet;

public class CustomGuardrailMeta
extends GuardrailMeta
implements IPluginifiedMeta {
    public final LoadedCustomGuardrail loaded;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.guardrails.custom");

    public CustomGuardrailMeta(LoadedCustomGuardrail loaded) {
        this.loaded = loaded;
    }

    @Override
    public String getType() {
        return "Custom_" + this.loaded.getType();
    }

    @Override
    public Class<? extends GuardrailParams> paramsClass() {
        return CustomGuardrailRunner.CustomGuardrailParams.class;
    }

    @Override
    public EnumSet<GuardrailMeta.GuardrailFlag> getFlags(GuardrailsPipelineSettings.GuardrailsPipelineElement elt) {
        JsonPrimitive val;
        JsonObject config;
        EnumSet<GuardrailMeta.GuardrailFlag> es = EnumSet.noneOf(GuardrailMeta.GuardrailFlag.class);
        if (this.loaded.desc.operatesOnQueries) {
            es.add(GuardrailMeta.GuardrailFlag.OPERATES_ON_QUERIES);
        } else if (this.loaded.desc.operatesOnQueriesBasedOnParameterName != null && (config = elt.getParamsCopyAs(CustomGuardrailRunner.CustomGuardrailParams.class).config).get(this.loaded.desc.operatesOnQueriesBasedOnParameterName) != null) {
            val = config.get(this.loaded.desc.operatesOnQueriesBasedOnParameterName).getAsJsonPrimitive();
            logger.info((Object)("Conditional operates on queries: " + val.getAsString()));
            if (this.loaded.desc.operatesOnQueriesBasedOnParameterValue.equals(val.getAsString())) {
                es.add(GuardrailMeta.GuardrailFlag.OPERATES_ON_QUERIES);
            }
        }
        if (this.loaded.desc.operatesOnResponses) {
            es.add(GuardrailMeta.GuardrailFlag.OPERATES_ON_RESPONSES);
        } else if (this.loaded.desc.operatesOnResponsesBasedOnParameterName != null && (config = elt.getParamsCopyAs(CustomGuardrailRunner.CustomGuardrailParams.class).config).get(this.loaded.desc.operatesOnResponsesBasedOnParameterName) != null && this.loaded.desc.operatesOnResponsesBasedOnParameterValue.equals((val = config.get(this.loaded.desc.operatesOnResponsesBasedOnParameterName).getAsJsonPrimitive()).getAsString())) {
            es.add(GuardrailMeta.GuardrailFlag.OPERATES_ON_RESPONSES);
        }
        if (this.loaded.desc.mayRequestRetryOnResponses) {
            es.add(GuardrailMeta.GuardrailFlag.MAY_REQUEST_RETRY_ON_RESPONSES);
        } else if (this.loaded.desc.mayRequestRetryOnResponsesBasedOnParameterName != null && (config = elt.getParamsCopyAs(CustomGuardrailRunner.CustomGuardrailParams.class).config).get(this.loaded.desc.mayRequestRetryOnResponsesBasedOnParameterName) != null && this.loaded.desc.mayRequestRetryOnResponsesBasedOnParameterValue.equals((val = config.get(this.loaded.desc.mayRequestRetryOnResponsesBasedOnParameterName).getAsJsonPrimitive()).getAsString())) {
            es.add(GuardrailMeta.GuardrailFlag.MAY_REQUEST_RETRY_ON_RESPONSES);
        }
        if (this.loaded.desc.mayRespondDirectlyToQueries) {
            es.add(GuardrailMeta.GuardrailFlag.MAY_RESPOND_DIRECTLY_TO_QUERIES);
        } else if (this.loaded.desc.mayRespondDirectlyToQueriesBasedOnParameterName != null && (config = elt.getParamsCopyAs(CustomGuardrailRunner.CustomGuardrailParams.class).config).get(this.loaded.desc.mayRespondDirectlyToQueriesBasedOnParameterName) != null && this.loaded.desc.mayRespondDirectlyToQueriesBasedOnParameterValue.equals((val = config.get(this.loaded.desc.mayRespondDirectlyToQueriesBasedOnParameterName).getAsJsonPrimitive()).getAsString())) {
            es.add(GuardrailMeta.GuardrailFlag.MAY_RESPOND_DIRECTLY_TO_QUERIES);
        }
        return es;
    }

    @Override
    public GuardrailRunner buildRunner(AuthCtx authCtx, String projectKey, GuardrailsPipelineSettings.GuardrailsPipelineElement elt, String bypassToken) throws Exception {
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus featuresStatus = GuardrailsPipelineUtils.getLicensing();
        if (!featuresStatus.advancedLLMMeshAllowed) {
            String label = this.getLoadedDesc().desc.meta == null ? "unknown" : this.getLoadedDesc().desc.meta.label;
            throw new LicenseRestrictionException("Guardrail '" + label + "' requires the \"Advanced LLM Mesh\" add-on");
        }
        return new CustomGuardrailRunner((DSSAuthCtx)authCtx, projectKey, elt, bypassToken);
    }

    public String getOwnerPluginId() {
        return this.loaded.ownerPluginId;
    }

    @Override
    public LoadedCustomGuardrail getLoadedDesc() {
        return this.loaded;
    }
}

