/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.utils;

import com.dataiku.dss.shadelib.com.google.common.math.DoubleMath;
import java.util.Set;
import java.util.stream.Collectors;

public class AspectRatioMatcher {
    private final Set<AspectRatio> ratios;

    public AspectRatioMatcher(String ... ratios) {
        this.ratios = Set.of(ratios).stream().map(AspectRatio::new).collect(Collectors.toSet());
    }

    public String fuzzyMatch(int width, int height) {
        double desiredRatio = (double)width / (double)height;
        for (AspectRatio ratio : this.ratios) {
            if (!DoubleMath.fuzzyEquals((double)desiredRatio, (double)ratio.ratio, (double)0.02)) continue;
            return ratio.repr;
        }
        throw new IllegalArgumentException(String.format("Unsupported aspect ratio: %s:%s", width, height));
    }

    private static class AspectRatio {
        private final double ratio;
        private final String repr;

        private AspectRatio(String repr) {
            String[] splitAR = repr.split(":");
            if (splitAR.length != 2 || splitAR[0].isBlank() || splitAR[1].isBlank()) {
                throw new IllegalArgumentException(String.format("Illegal aspect ratio format, expected \"<width>:<height>\", got: \"%s\"", repr));
            }
            int width = Integer.parseInt(splitAR[0]);
            int height = Integer.parseInt(splitAR[1]);
            this.ratio = (double)width / (double)height;
            this.repr = repr;
        }
    }
}

