/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec.engine;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVFormatExtractor;
import com.dataiku.dip.input.utils.ExternalInputStreamInput;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.StreamOutputWriter;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class CSVSchemaAdapter {
    public static void transformCSV(InputStream csvInputStream, Schema fileSchema, boolean parseHeaderRow, Schema outputSchema, OutputStream csvOutputStream) throws Exception {
        CSVFormatConfig outCsvf = CSVFormatConfig.getStandardTabExcelFormat();
        outCsvf.parseHeaderRow = false;
        CSVOutputFormatter csvOutputFormatter = new CSVOutputFormatter(outCsvf);
        csvOutputFormatter.setOutputSchema(outputSchema);
        CSVSchemaAdapter.transformCSV(csvInputStream, fileSchema, parseHeaderRow, csvOutputStream, (OutputFormatter)csvOutputFormatter, new StreamRowFactory(), null);
    }

    public static void transformCSV(InputStream csvInputStream, Schema fileSchema, boolean parseHeaderRow, OutputStream csvOutputStream, OutputFormatter outputFormatter, StreamRowFactory streamRowFactory, ExtractionLimit extractionLimit) throws Exception {
        CSVFormatConfig config = CSVFormatConfig.getStandardTabExcelFormat();
        config.parseHeaderRow = parseHeaderRow;
        CSVFormatExtractor predictedExtractor = new CSVFormatExtractor(config);
        predictedExtractor.setSchema(fileSchema, false);
        if (extractionLimit != null) {
            predictedExtractor.setLimit(extractionLimit);
        }
        try (ExternalInputStreamInput eis = new ExternalInputStreamInput(csvInputStream);){
            StreamOutputWriter out = new StreamOutputWriter(csvOutputStream, outputFormatter);
            StreamColumnFactory cf = new StreamColumnFactory();
            out.init((ColumnFactory)cf);
            predictedExtractor.run(eis.getSingleSplit(), (ProcessorOutput)out, (ColumnFactory)cf, (RowFactory)streamRowFactory);
            out.lastRowEmitted();
        }
    }

    public static abstract class StreamPusher {
        public abstract void push(OutputStream var1) throws Exception;

        public static StreamPusher create(final byte[] data) {
            return new StreamPusher(){

                @Override
                public void push(OutputStream out) throws Exception {
                    IOUtils.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)out);
                }
            };
        }
    }
}

