/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.formats.csv.CSVDeserializer;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.engines.HiveMetricsEngine;
import com.dataiku.dip.metrics.engines.HiveProbeEngine;
import com.dataiku.dip.metrics.engines.ImpalaMetricsEngine;
import com.dataiku.dip.metrics.engines.ImpalaProbeEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.SQLMetricsEngine;
import com.dataiku.dip.metrics.engines.SQLProbeEngine;
import com.dataiku.dip.metrics.engines.SparkMetricsEngine;
import com.dataiku.dip.metrics.engines.SparkProbeEngine;
import com.dataiku.dip.metrics.probes.CustomSQLProbeDesc;
import com.dataiku.dip.metrics.probes.CustomSQLProbesService;
import com.dataiku.dip.metrics.probes.LoadedSQLProbe;
import com.dataiku.dip.metrics.probes.MetricBuilder;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.log4j.Logger;

public class CustomSQLProbeType
extends ProbeType
implements MetricBuilder,
IPluginifiedMeta {
    public static final String TYPE = "sql_plugin";
    private final LoadedSQLProbe loadedDesc;
    private final CustomSQLProbesService customSQLProbesService;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.sql_custom");

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        ArrayList computers = Lists.newArrayList();
        computers.add(new CustomSQLAggregateEngineComputer(){

            @Override
            public String getCode() throws IOException {
                return CustomSQLProbeType.this.customSQLProbesService.getCode(CustomSQLProbeType.this.getType());
            }

            @Override
            public CustomSQLProbeDesc getDesc() {
                return CustomSQLProbeType.this.loadedDesc.desc;
            }

            @Override
            public Map<String, Object> getAdditionalVariables(Probe probe, AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
                return CustomSQLProbeType.this.getVariables(probe, authCtx, projectKey);
            }
        });
        computers.add(new CustomImpalaAggregateEngineComputer(){

            @Override
            public String getCode() throws IOException {
                return CustomSQLProbeType.this.customSQLProbesService.getCode(CustomSQLProbeType.this.getType());
            }

            @Override
            public CustomSQLProbeDesc getDesc() {
                return CustomSQLProbeType.this.loadedDesc.desc;
            }

            @Override
            public Map<String, Object> getAdditionalVariables(Probe probe, AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
                return CustomSQLProbeType.this.getVariables(probe, authCtx, projectKey);
            }
        });
        computers.add(new CustomHiveAggregateEngineComputer(){

            @Override
            public String getCode() throws IOException {
                return CustomSQLProbeType.this.customSQLProbesService.getCode(CustomSQLProbeType.this.getType());
            }

            @Override
            public CustomSQLProbeDesc getDesc() {
                return CustomSQLProbeType.this.loadedDesc.desc;
            }

            @Override
            public Map<String, Object> getAdditionalVariables(Probe probe, AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
                return CustomSQLProbeType.this.getVariables(probe, authCtx, projectKey);
            }
        });
        computers.add(new CustomSparkAggregateEngineComputer(){

            @Override
            public String getCode() throws IOException {
                return CustomSQLProbeType.this.customSQLProbesService.getCode(CustomSQLProbeType.this.getType());
            }

            @Override
            public CustomSQLProbeDesc getDesc() {
                return CustomSQLProbeType.this.loadedDesc.desc;
            }

            @Override
            public Map<String, Object> getAdditionalVariables(Probe probe, AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
                return CustomSQLProbeType.this.getVariables(probe, authCtx, projectKey);
            }
        });
        computers.add(new MetricComputer.SQLQueryEngineComputer(){

            @Override
            public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
                Dataset dataset;
                if (metric instanceof CustomSQLMetric && objectType == MetricTargetType.DATASET && !CustomSQLProbeType.this.loadedDesc.desc.singleAggregate && DatasetInspector.isSQLAble(authCtx, dataset = (Dataset)object) && (StringUtils.isBlank((String)CustomSQLProbeType.this.loadedDesc.desc.restrictToDatasetType) || CustomSQLProbeType.this.loadedDesc.desc.restrictToDatasetType.equals(dataset.getType()))) {
                    return new SQLProbeEngine.SQLProbeEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
                }
                return null;
            }

            @Override
            public String getProbeType() {
                return CustomSQLProbeType.this.getType();
            }

            @Override
            public String getQuery(Probe probe) throws IOException {
                return CustomSQLProbeType.this.customSQLProbesService.getCode(CustomSQLProbeType.this.getType());
            }

            @Override
            public Map<String, Object> getAdditionalVariables(Probe probe, AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
                return CustomSQLProbeType.this.getVariables(probe, authCtx, projectKey);
            }
        });
        computers.add(new MetricComputer.HiveQueryEngineComputer(){

            @Override
            public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
                Dataset dataset;
                if (metric instanceof CustomSQLMetric && objectType == MetricTargetType.DATASET && !CustomSQLProbeType.this.loadedDesc.desc.singleAggregate && DatasetInspector.isHDFSDatasetOrHiveTableDataset(dataset = (Dataset)object) && CustomSQLProbeType.this.loadedDesc.desc.canHive) {
                    return new HiveProbeEngine.HiveProbeEngineRun().with(new MetricComputation(probe, this, metric, 2.0));
                }
                return null;
            }

            @Override
            public String getProbeType() {
                return CustomSQLProbeType.this.getType();
            }

            @Override
            public String getQuery(Probe probe) throws IOException {
                return CustomSQLProbeType.this.customSQLProbesService.getCode(CustomSQLProbeType.this.getType());
            }

            @Override
            public Map<String, Object> getAdditionalVariables(Probe probe, AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
                return CustomSQLProbeType.this.getVariables(probe, authCtx, projectKey);
            }
        });
        computers.add(new MetricComputer.SparkQueryEngineComputer(){

            @Override
            public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
                if (metric instanceof CustomSQLMetric && objectType == MetricTargetType.DATASET && !CustomSQLProbeType.this.loadedDesc.desc.singleAggregate && CustomSQLProbeType.this.loadedDesc.desc.canSpark) {
                    return new SparkProbeEngine.SparkProbeEngineRun().with(new MetricComputation(probe, this, metric, 3.0));
                }
                return null;
            }

            @Override
            public String getProbeType() {
                return CustomSQLProbeType.this.getType();
            }

            @Override
            public String getQuery(Probe probe) throws IOException {
                return CustomSQLProbeType.this.customSQLProbesService.getCode(CustomSQLProbeType.this.getType());
            }

            @Override
            public Map<String, Object> getAdditionalVariables(Probe probe, AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
                return CustomSQLProbeType.this.getVariables(probe, authCtx, projectKey);
            }
        });
        computers.add(new MetricComputer.ImpalaQueryEngineComputer(){

            @Override
            public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
                Dataset dataset;
                if (metric instanceof CustomSQLMetric && objectType == MetricTargetType.DATASET && !CustomSQLProbeType.this.loadedDesc.desc.singleAggregate && DatasetInspector.isHDFSDatasetOrHiveTableDataset(dataset = (Dataset)object) && SchemaUtils.isSafeForImpala(dataset) && CustomSQLProbeType.this.loadedDesc.desc.canImpala) {
                    return new ImpalaProbeEngine.ImpalaProbeEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
                }
                return null;
            }

            @Override
            public String getProbeType() {
                return CustomSQLProbeType.this.getType();
            }

            @Override
            public String getQuery(Probe probe) throws IOException {
                return CustomSQLProbeType.this.customSQLProbesService.getCode(CustomSQLProbeType.this.getType());
            }

            @Override
            public Map<String, Object> getAdditionalVariables(Probe probe, AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
                return CustomSQLProbeType.this.getVariables(probe, authCtx, projectKey);
            }
        });
        return computers;
    }

    private Map<String, Object> getVariables(Probe probe, AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        JsonObject pluginConfig;
        HashMap variables = Maps.newHashMap();
        CustomSQLProbeConfiguration configuration = probe.getConfigurationAs(CustomSQLProbeConfiguration.class);
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.customSQLProbesService.getExpandedPluginSettings(this.getType(), authCtx, projectKey, configuration.config);
        JsonObject config = expandedPluginSettings.config;
        if (config != null) {
            this.convertToVariables(variables, config);
        }
        if ((pluginConfig = expandedPluginSettings.pluginConfig) != null) {
            this.convertToVariables(variables, pluginConfig);
        }
        return variables;
    }

    private void convertToVariables(Map<String, Object> variables, JsonObject pluginConfig) {
        for (Map.Entry elt : pluginConfig.entrySet()) {
            Object v = null;
            if (((JsonElement)elt.getValue()).isJsonPrimitive()) {
                v = ((JsonElement)elt.getValue()).getAsJsonPrimitive().isString() ? ((JsonElement)elt.getValue()).getAsJsonPrimitive().getAsString() : (((JsonElement)elt.getValue()).getAsJsonPrimitive().isNumber() ? ((JsonElement)elt.getValue()).getAsJsonPrimitive().getAsNumber() : (((JsonElement)elt.getValue()).getAsJsonPrimitive().isBoolean() ? Boolean.valueOf(((JsonElement)elt.getValue()).getAsJsonPrimitive().getAsBoolean()) : ((JsonElement)elt.getValue()).toString()));
            } else if (((JsonElement)elt.getValue()).isJsonArray()) {
                JsonArray array = ((JsonElement)elt.getValue()).getAsJsonArray();
                ArrayList l = Lists.newArrayList();
                for (JsonElement arrayElt : array) {
                    if (arrayElt.isJsonPrimitive()) {
                        if (arrayElt.getAsJsonPrimitive().isString()) {
                            l.add(arrayElt.getAsJsonPrimitive().getAsString());
                            continue;
                        }
                        if (arrayElt.getAsJsonPrimitive().isNumber()) {
                            l.add(arrayElt.getAsJsonPrimitive().getAsNumber());
                            continue;
                        }
                        if (arrayElt.getAsJsonPrimitive().isBoolean()) {
                            l.add(arrayElt.getAsJsonPrimitive().getAsBoolean());
                            continue;
                        }
                        l.add(arrayElt.toString());
                        continue;
                    }
                    l.add(arrayElt.toString());
                }
                v = l;
            } else {
                v = ((JsonElement)elt.getValue()).toString();
            }
            variables.put((String)elt.getKey(), v);
        }
    }

    public CustomSQLProbeType(LoadedSQLProbe loadedDesc, CustomSQLProbesService customSQLProbesService) {
        this.loadedDesc = loadedDesc;
        this.customSQLProbesService = customSQLProbesService;
        this.type = loadedDesc.probeType;
    }

    private String getProbeName(Probe probe) {
        return StringUtils.isNotBlank((String)probe.getMeta().getName()) ? probe.getMeta().getName() : probe.getType();
    }

    private String getProbeTypeName(CustomSQLProbeType probeType) {
        return StringUtils.isNotBlank((String)probeType.loadedDesc.desc.meta.label) ? probeType.loadedDesc.desc.meta.label : probeType.loadedDesc.desc.id;
    }

    @Override
    public Object listSelectableMetrics(Probe probe, Object object, MetricTargetType objectType) {
        if (objectType == MetricTargetType.DATASET) {
            CustomSQLProbeHint probeHint = new CustomSQLProbeHint();
            Dataset dataset = (Dataset)object;
            CustomSQLProbeConfiguration configuration = probe.getConfigurationAs(CustomSQLProbeConfiguration.class);
            HashSet aggregatedColumns = Sets.newHashSet(configuration.getColumns());
            for (SchemaColumn column : dataset.getSchema().getColumns()) {
                CustomSQLProbeColumnHint columnHint = new CustomSQLProbeColumnHint(column.getName());
                columnHint.metrics.add(new CustomSQLProbeMetricHint("agg", aggregatedColumns.contains(column.getName()), false));
                probeHint.columns.add(columnHint);
            }
            return probeHint;
        }
        return null;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        ArrayList metrics = Lists.newArrayList();
        CustomSQLProbeConfiguration configuration = probe.getConfigurationAs(CustomSQLProbeConfiguration.class);
        String primerMetricName = this.getProbeName(probe);
        if (this.loadedDesc.desc.singleAggregate && StringUtils.isNotBlank((String)this.loadedDesc.desc.aggregateName)) {
            primerMetricName = this.loadedDesc.desc.aggregateName;
        }
        if (this.loadedDesc.desc.singleAggregate && this.loadedDesc.desc.perColumn) {
            for (String configured : configuration.columns) {
                metrics.add(new CustomSQLMetric(this.getType(), primerMetricName, configured, Type.STRING, this.getProbeName(probe), this.getProbeTypeName(this)));
            }
        } else if (!forDisplay) {
            metrics.add(new CustomSQLMetric(this.getType(), primerMetricName, null, Type.STRING, this.getProbeName(probe), this.getProbeTypeName(this)));
        }
        return metrics;
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> columns, Probe probe) {
        CustomSQLProbeConfiguration probeConfiguration = probe.getConfigurationAs(CustomSQLProbeConfiguration.class);
        if (this.loadedDesc.desc.singleAggregate && this.loadedDesc.desc.perColumn) {
            CustomSQLProbeConfiguration configuration = new CustomSQLProbeConfiguration();
            configuration.config = probeConfiguration.config;
            for (SchemaColumn column : columns) {
                configuration.columns.add(column.getName());
            }
            return configuration;
        }
        return null;
    }

    @Override
    public ProbeType trimForSave() {
        return this;
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return CustomSQLProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        String name = this.loadedDesc.desc.meta.label;
        return new ProbeMetadata().withLevel(10).withName(StringUtils.isNotBlank((String)name) ? name : this.loadedDesc.id);
    }

    @Override
    public boolean isUserSelectedProbe() {
        return true;
    }

    @Override
    public Metric build(String name, Type dataType, Probe probe) {
        return new CustomSQLMetric(this.getType(), name, null, dataType, this.getProbeName(probe), this.getProbeTypeName(this));
    }

    @Override
    public IElementLoadedDesc getLoadedDesc() {
        return null;
    }

    public static class CustomSQLProbeConfiguration
    implements ProbeConfiguration {
        public JsonObject config = new JsonObject();
        public List<String> columns = Lists.newArrayList();

        public JsonObject getConfig() {
            return this.config;
        }

        public List<String> getColumns() {
            return this.columns;
        }
    }

    public static class CustomSQLProbeHint {
        public List<CustomSQLProbeColumnHint> columns = Lists.newArrayList();
    }

    public static class CustomSQLProbeColumnHint {
        public String column;
        public List<CustomSQLProbeMetricHint> metrics = Lists.newArrayList();

        CustomSQLProbeColumnHint(String column) {
            this.column = column;
        }
    }

    public static class CustomSQLProbeMetricHint {
        public String name;
        public boolean disabled;
        public boolean active;

        CustomSQLProbeMetricHint(String name, boolean active, boolean disabled) {
            this.name = name;
            this.active = active;
            this.disabled = disabled;
        }
    }

    public static class CustomSQLMetric
    extends Metric {
        public String name;
        public String probeName;
        public String probeTypeName;
        public String column;

        public CustomSQLMetric(String probeType, String name, String column, Type resultDataType, String probeName, String probeTypeName) {
            super(probeType, resultDataType);
            this.name = name;
            this.column = column;
            this.probeName = probeName;
            this.probeTypeName = probeTypeName;
            this.id = Metric.serializeMetric(this);
        }

        @Override
        public String getIdType() {
            return CustomSQLProbeType.TYPE;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getColumn() {
            return this.column;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return new CustomSQLMetric(this.type, this.name, placeholder, this.dataType, this.probeName, this.probeTypeName).getId();
        }

        public String getProbeName() {
            return this.probeName;
        }

        public String getProbeTypeName() {
            return this.probeTypeName;
        }

        @Override
        public MetricMetadata getMeta() {
            if (StringUtils.isNotBlank((String)this.column)) {
                return new MetricMetadata().withName(this.name + " on " + this.column + " (" + this.probeTypeName + " : " + this.probeName + ")");
            }
            return new MetricMetadata().withName(this.name + " (" + this.probeTypeName + " : " + this.probeName + ")");
        }

        public void updateWithQueryMetadata(String column, Type type) {
            this.column = column;
            this.dataType = type;
            this.id = Metric.serializeMetric(this);
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            return CustomSQLMetric.getProbeFromName(probes, this.getProbeName());
        }
    }

    public static abstract class CustomSparkAggregateEngineComputer
    extends MetricComputer.SparkMetricsEngineComputer {
        private final CustomSQLProbeMetricsEngineComputer subComputer = new CustomSQLProbeMetricsEngineComputer();

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof CustomSQLMetric && objectType == MetricTargetType.DATASET && this.getDesc().singleAggregate && this.getDesc().canSpark) {
                return new SparkMetricsEngine.SparkMetricsEngineRun().with(new MetricComputation(probe, this, metric, 3.0));
            }
            return null;
        }

        @Override
        public String getProbeType() {
            return CustomSQLProbeType.TYPE;
        }

        public abstract CustomSQLProbeDesc getDesc();

        public abstract String getCode() throws IOException;

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(this.getCode(), computation, dialect, queryBuilder, this.getVariables(computation.probe, authCtx, engine.getDataset().getProjectKey()));
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static abstract class CustomHiveAggregateEngineComputer
    extends MetricComputer.HiveMetricsEngineComputer {
        private final CustomSQLProbeMetricsEngineComputer subComputer = new CustomSQLProbeMetricsEngineComputer();

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof CustomSQLMetric && objectType == MetricTargetType.DATASET && this.getDesc().singleAggregate) {
                Dataset dataset = (Dataset)object;
                if (this.getDesc().canHive && DatasetInspector.isHDFSDatasetOrHiveTableDataset(dataset)) {
                    return new HiveMetricsEngine.HiveMetricsEngineRun().with(new MetricComputation(probe, this, metric, 2.0));
                }
            }
            return null;
        }

        @Override
        public String getProbeType() {
            return CustomSQLProbeType.TYPE;
        }

        public abstract CustomSQLProbeDesc getDesc();

        public abstract String getCode() throws IOException;

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(this.getCode(), computation, dialect, queryBuilder, this.getVariables(computation.probe, authCtx, engine.getDataset().getProjectKey()));
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static abstract class CustomImpalaAggregateEngineComputer
    extends MetricComputer.ImpalaMetricsEngineComputer {
        private final CustomSQLProbeMetricsEngineComputer subComputer = new CustomSQLProbeMetricsEngineComputer();

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof CustomSQLMetric && objectType == MetricTargetType.DATASET && this.getDesc().singleAggregate) {
                Dataset dataset = (Dataset)object;
                if (this.getDesc().canImpala && DatasetInspector.isHDFSDatasetOrHiveTableDataset(dataset) && SchemaUtils.isSafeForImpala(dataset)) {
                    return new ImpalaMetricsEngine.ImpalaMetricsEngineRun("fakeColumnInCaseThereIsACountDistinct").with(new MetricComputation(probe, this, metric, 1.0));
                }
            }
            return null;
        }

        @Override
        public String getProbeType() {
            return CustomSQLProbeType.TYPE;
        }

        public abstract CustomSQLProbeDesc getDesc();

        public abstract String getCode() throws IOException;

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(this.getCode(), computation, dialect, queryBuilder, this.getVariables(computation.probe, authCtx, engine.getDataset().getProjectKey()));
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static abstract class CustomSQLAggregateEngineComputer
    extends MetricComputer.SQLMetricsEngineComputer {
        private final CustomSQLProbeMetricsEngineComputer subComputer = new CustomSQLProbeMetricsEngineComputer();

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            Dataset dataset;
            if (metric instanceof CustomSQLMetric && objectType == MetricTargetType.DATASET && this.getDesc().singleAggregate && DatasetInspector.isSQLAble(authCtx, dataset = (Dataset)object)) {
                return new SQLMetricsEngine.SQLMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public String getProbeType() {
            return CustomSQLProbeType.TYPE;
        }

        public abstract CustomSQLProbeDesc getDesc();

        public abstract String getCode() throws IOException;

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(this.getCode(), computation, dialect, queryBuilder, this.getVariables(computation.probe, authCtx, engine.getDataset().getProjectKey()));
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class CustomSQLProbeMetricsEngineComputer {
        public ExpressionBuilder getAggregations(String code, SQLDialect dialect, ExpressionBuilder.ExpressionBuilderFactory ef, CustomSQLMetric metric, Map<String, Object> probeVariables) {
            HashMap variables = Maps.newHashMap();
            if (probeVariables != null) {
                for (Map.Entry<String, Object> probeVariable : probeVariables.entrySet()) {
                    Object v = probeVariable.getValue();
                    if (v instanceof List) {
                        ArrayList list = Lists.newArrayList();
                        for (Object o : (List)v) {
                            if (o instanceof String) {
                                list.add(dialect.quoteString((String)o));
                                continue;
                            }
                            list.add(o.toString());
                        }
                        variables.put(probeVariable.getKey(), Joiner.on((String)", ").join((Iterable)list));
                        continue;
                    }
                    variables.put(probeVariable.getKey(), v.toString());
                }
            }
            if (StringUtils.isNotBlank((String)metric.getColumn())) {
                variables.put("column", metric.getColumn());
            }
            StrSubstitutor substitutor = new StrSubstitutor((Map)variables);
            code = substitutor.replace(code);
            return ef.expr(code);
        }

        public void addAggregations(String code, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, Object> variables) throws Exception {
            CustomSQLMetric metric = (CustomSQLMetric)computation.metric;
            CustomSQLProbeMetricsComputerSession session = new CustomSQLProbeMetricsComputerSession();
            computation.session = session;
            session.dialect = dialect;
            ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
            ExpressionBuilder expr = this.getAggregations(code, dialect, ef, metric, variables);
            SelectQueryBuilder.SelectRefBuilder ref = queryBuilder.select(expr);
            session.offset = ref.getIndex();
        }

        public String getAggregate(CustomSQLProbeMetricsComputerSession session, QueryRunResult rs2, int offset, CustomSQLMetric metric) throws SQLException {
            Type dssType = rs2.columns.get((int)(offset - 1)).dssType;
            metric.updateWithQueryMetadata(metric.getColumn(), dssType);
            String v = rs2.rows.get(0)[offset - 1];
            try {
                if (dssType == Type.DATE) {
                    v = DKUtils.isoFormatReadableByDateFormat((long)CSVDeserializer.hiveDateParser.parseDateTime(v).getMillis());
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failure while trying to harmonize hive date to ISO format");
            }
            return v;
        }

        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            CustomSQLProbeMetricsComputerSession session = (CustomSQLProbeMetricsComputerSession)computation.session;
            return this.getAggregate(session, rs2, session.offset, (CustomSQLMetric)computation.metric);
        }

        public static class CustomSQLProbeMetricsComputerSession {
            public SQLDialect dialect;
            public int offset;
        }
    }

    public static class CustomSQLMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof CustomSQLMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            CustomSQLMetric sqlMetric = (CustomSQLMetric)metric;
            if (StringUtils.isNotBlank((String)sqlMetric.getColumn())) {
                return Metric.buildMetricIdFromParts(CustomSQLProbeType.TYPE, sqlMetric.getType(), sqlMetric.getName(), sqlMetric.getProbeName(), sqlMetric.getProbeTypeName(), sqlMetric.getColumn());
            }
            return Metric.buildMetricIdFromParts(CustomSQLProbeType.TYPE, sqlMetric.getType(), sqlMetric.getName(), sqlMetric.getProbeName(), sqlMetric.getProbeTypeName());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() == 5 && parts.get(0).equals(CustomSQLProbeType.TYPE)) {
                return new CustomSQLMetric(parts.get(1), parts.get(2), null, Type.STRING, parts.get(3), parts.get(4));
            }
            if (parts.size() == 6 && parts.get(0).equals(CustomSQLProbeType.TYPE)) {
                return new CustomSQLMetric(parts.get(1), parts.get(2), parts.get(5), Type.STRING, parts.get(3), parts.get(4));
            }
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
        }
    }
}

