/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.PythonProbeEngine;
import com.dataiku.dip.metrics.probes.MetricBuilder;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class PythonProbeType
extends ProbeType
implements MetricBuilder,
MetaWithSelectableCodeEnv {
    public static final String TYPE = "python";

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        ArrayList computers = Lists.newArrayList();
        computers.add(new MetricComputer.PythonEngineComputer(){

            @Override
            public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
                if (metric instanceof PythonMetric && objectType == MetricTargetType.MANAGED_FOLDER) {
                    return new PythonProbeEngine.PythonProbeEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
                }
                return null;
            }

            @Override
            public String getProbeType() {
                return PythonProbeType.TYPE;
            }

            @Override
            public String getCode(Probe probe) {
                PythonProbeConfiguration configuration = probe.getConfigurationAs(PythonProbeConfiguration.class);
                return configuration.getCode();
            }

            @Override
            public String getResourceFolder() {
                return null;
            }

            @Override
            public String getLibFolder() {
                return null;
            }

            @Override
            public PluginSettingsResolver.ResolvedSettings getPluginConfig(Probe pythonProbe, AuthCtx authCtx, String projectKey) {
                return new PluginSettingsResolver.ResolvedSettings(null, null);
            }

            @Override
            public String getEnvName(Probe pythonProbe, String projectKey) throws IOException {
                CodeEnvSelector envSelector = new CodeEnvSelector();
                return envSelector.selectForPythonRecipe(projectKey, pythonProbe.getConfigurationAs(PythonProbeConfiguration.class).envSelection);
            }
        });
        computers.add(new MetricComputer.PythonEngineComputer(){

            @Override
            public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
                if (metric instanceof PythonMetric && objectType == MetricTargetType.DATASET) {
                    return new PythonProbeEngine.PythonProbeEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
                }
                return null;
            }

            @Override
            public String getProbeType() {
                return PythonProbeType.TYPE;
            }

            @Override
            public String getCode(Probe probe) {
                PythonProbeConfiguration configuration = probe.getConfigurationAs(PythonProbeConfiguration.class);
                return configuration.getCode();
            }

            @Override
            public String getResourceFolder() {
                return null;
            }

            @Override
            public String getLibFolder() {
                return null;
            }

            @Override
            public PluginSettingsResolver.ResolvedSettings getPluginConfig(Probe pythonProbe, AuthCtx authCtx, String projectKey) {
                return new PluginSettingsResolver.ResolvedSettings(null, null);
            }

            @Override
            public String getEnvName(Probe pythonProbe, String projectKey) throws IOException {
                CodeEnvSelector envSelector = new CodeEnvSelector();
                return envSelector.selectForPythonRecipe(projectKey, pythonProbe.getConfigurationAs(PythonProbeConfiguration.class).envSelection);
            }
        });
        return computers;
    }

    public PythonProbeType() {
        this.type = TYPE;
    }

    private String getProbeName(Probe probe) {
        if (StringUtils.isNotBlank((String)probe.getMeta().getName())) {
            return probe.getMeta().getName();
        }
        PythonProbeConfiguration configuration = probe.getConfigurationAs(PythonProbeConfiguration.class);
        String code = configuration.getCode();
        String codeHash = DigestUtils.md5Hex((String)(code == null ? "" : code));
        return "h" + codeHash;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        ArrayList primer = Lists.newArrayList();
        if (!forDisplay) {
            primer.add(new PythonMetric("__primer__", Type.STRING, this.getProbeName(probe)));
        }
        return primer;
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> column, Probe probe) {
        return null;
    }

    @Override
    public ProbeType trimForSave() {
        return new PythonProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return PythonProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(8).withName("Custom python");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return true;
    }

    @Override
    public Metric build(String name, Type dataType, Probe probe) {
        return new PythonMetric(name, dataType, this.getProbeName(probe));
    }

    @Override
    public CodeEnvModel.EnvLang getEnvLang() {
        return CodeEnvModel.EnvLang.PYTHON;
    }

    public static class PythonProbeConfiguration
    implements ProbeConfiguration,
    ParamsWithSelectableCodeEnv {
        public String code;
        public CodeEnvSelection envSelection = new CodeEnvSelection();

        public String getCode() {
            return this.code;
        }

        @Override
        public CodeEnvSelection getCodeEnvSelection() {
            return this.envSelection;
        }

        @Override
        public void setCodeEnvSelection(CodeEnvSelection envSelection) {
            this.envSelection = envSelection;
        }

        @Override
        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList usages = Lists.newArrayList();
            if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.envSelection.envName, CodeEnvModel.EnvUsage.DATASET_METRIC, object.getProjectKey(), object.getId()));
            }
            return usages;
        }
    }

    public static class PythonMetric
    extends Metric {
        public String name;
        public String probeName;

        public PythonMetric(String name, Type resultDataType, String probeName) {
            super(PythonProbeType.TYPE, resultDataType);
            this.name = name;
            this.probeName = probeName;
            this.id = Metric.serializeMetric(this);
        }

        public String getName() {
            return this.name;
        }

        public String getProbeName() {
            return this.probeName;
        }

        @Override
        public String getColumn() {
            return null;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return this.getId();
        }

        @Override
        public MetricMetadata getMeta() {
            return new MetricMetadata().withName(this.name + " (" + this.probeName + ")");
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            return PythonMetric.getProbeFromName(probes, this.getProbeName());
        }
    }

    public static class PythonMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof PythonMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            PythonMetric pythonMetric = (PythonMetric)metric;
            return Metric.buildMetricIdFromParts(PythonProbeType.TYPE, pythonMetric.getName(), pythonMetric.getProbeName());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() != 3 || !parts.get(0).equals(PythonProbeType.TYPE)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
            }
            return new PythonMetric(parts.get(1), Type.STRING, parts.get(2));
        }
    }
}

