/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.notebooks;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.notebooks.JupyterVirtualPathService;
import com.dataiku.dip.processes.CGroupHelper;
import com.dataiku.dip.recipes.code.spark.SparkBasedActivityHelper;
import com.dataiku.dip.recipes.code.spark.SparkConfigEnricher;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLHandler;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.security.impersonation.UserImpersonationUtils;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.spark.submit.SparkSubmitHelper;
import com.dataiku.dip.spark.submit.SparkSubmitJob;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JupyterSecurityService {
    @Autowired
    private APITicketService ticketService;
    @Autowired
    private ImpersonationResolverService impersonationService;
    @Autowired
    private JupyterVirtualPathService virtualPathService;
    private Map<String, SparkJobHelper.SparkJobContext> activeSparkContexts = new HashMap<String, SparkJobHelper.SparkJobContext>();
    private static Logger logger = Logger.getLogger((String)"dip.jupyter.security");

    private String notebookIdSlug(String notebookId) {
        String baseSlug = notebookId.replaceAll("\\.ipynb$", "").replaceAll("[^A-Za-z0-9_-]", "_");
        return baseSlug + DigestUtils.md5Hex((String)notebookId).substring(0, 8);
    }

    private synchronized void registerSparkContext(String jupyterSessionId, SparkJobHelper.SparkJobContext ctx) {
        this.activeSparkContexts.put(jupyterSessionId, ctx);
    }

    private synchronized SparkJobHelper.SparkJobContext getAndRemoveSparkContext(String jupyterSessionId) {
        SparkJobHelper.SparkJobContext ret = this.activeSparkContexts.get(jupyterSessionId);
        this.activeSparkContexts.remove(jupyterSessionId);
        return ret;
    }

    public void destroyContext(String jupyterSessionId) throws Exception {
        SparkJobHelper.SparkJobContext sjc = this.getAndRemoveSparkContext(jupyterSessionId);
        if (sjc != null) {
            logger.info((Object)"Destroying a context with a SparkJobContext");
            if (sjc.getComputeResourceUsage() != null) {
                sjc.getComputeResourceUsage().reportCompleteNoFail();
            }
            sjc.close();
        } else {
            logger.warn((Object)("No SparkJobContext registered for Jupyter session " + jupyterSessionId));
        }
    }

    public JupyterKernelContext createContext(String projectKey, String notebookId, AuthCtx authCtx, Set<String> relevantProjectKeys, String exportRunId, String jupyterSessionId, CodeEnvModel.UsedCodeEnvRef codeEnv) throws Exception {
        ClusterSettings clusterSettings;
        JupyterKernelContext ret = new JupyterKernelContext();
        ret.impersonation = this.impersonationService.isEnabled();
        ret.dssUser = UserImpersonationUtils.getDSSUser();
        ret.notebookObjectId = StringUtils.removeEnd((String)notebookId, (String)".ipynb");
        UserImpersonationTarget utarget = null;
        if (ret.impersonation) {
            utarget = this.impersonationService.getTargetUser(projectKey, authCtx);
            ret.unixUser = utarget.unixUser;
            ret.hadoopUser = utarget.hadoopUser;
            Validate.notNull((Object)ret.unixUser);
            Validate.notNull((Object)ret.hadoopUser);
            processRunDir = ApplicationConfigurator.getFile((String[])new String[]{"jupyter-run", "dku-workdirs", projectKey, this.notebookIdSlug(notebookId) + "-" + ret.unixUser});
            if (StringUtils.isNotBlank((String)exportRunId)) {
                processRunDir = new File(processRunDir, exportRunId);
            }
            DKUFileUtils.mkdirs((File)processRunDir);
            ret.processRunDir = processRunDir.getAbsolutePath();
            if (ApplicationConfigurator.getParams().getBoolParam("dku.hadoop.impersonation.forceUserName", false)) {
                ret.forceHadoopUserName = utarget.hadoopUser;
            }
        } else {
            processRunDir = ApplicationConfigurator.getFile((String[])new String[]{"jupyter-run", "dku-workdirs", projectKey, this.notebookIdSlug(notebookId)});
            if (StringUtils.isNotBlank((String)exportRunId)) {
                processRunDir = new File(processRunDir, exportRunId);
            }
            DKUFileUtils.mkdirs((File)processRunDir);
            ret.processRunDir = processRunDir.getAbsolutePath();
        }
        APITicketService.Ticket ticket = this.ticketService.createTicket(authCtx, "jupyter:" + projectKey + "." + notebookId, (Object)ret);
        ret.ticketSecret = ticket.getSecret();
        ret.sessionVirtualPath = this.virtualPathService.getSessionVirtualPath(projectKey, notebookId, authCtx);
        RemoteRunEnvDef envResource = new RemoteRunEnvDef();
        envResource.runsRemotely = false;
        envResource.cwd = ret.processRunDir;
        EnvironmentStash stash = new EnvironmentStash();
        stash.fillDefault();
        stash.apiTicket = ret.ticketSecret;
        stash.projectKey = projectKey;
        stash.fillCommunicationVars();
        stash.setCommunicationVarsForLocalOnlyExecution();
        if (codeEnv != null && StringUtils.isNotBlank((String)codeEnv.envName)) {
            stash.env.put("DKU_CODE_ENV_NAME", codeEnv.envName);
            ret.codeEnvName = codeEnv.envName;
        }
        stash.copyToRemoteRunEnvDef(envResource, true, false, false);
        envResource.jobId = notebookId;
        stash.fillProjectLibsForNonJob(authCtx, new File(ret.processRunDir));
        try {
            clusterSettings = new ClusterSelector().selectForProject(authCtx, projectKey);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to retrieve hadoop and spark settings", (Throwable)e);
            clusterSettings = null;
        }
        try {
            this.buildExecEnv(projectKey, authCtx, relevantProjectKeys, ret, envResource, clusterSettings);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to setup Spark-related notebook env", (Throwable)e);
        }
        CGroupHelper cgroupsHelper = new CGroupHelper(authCtx, projectKey, GeneralSettingsDAO.CGrouppableProcessType.JUPYTER_KERNEL);
        if (cgroupsHelper.isEnabled()) {
            ret.cgroupsHierarchiesRoot = cgroupsHelper.getHierarchiesMountPoint();
            ret.cgroupPaths = cgroupsHelper.getTargetCGroups();
            cgroupsHelper.createCGroups(ret.cgroupPaths);
            cgroupsHelper.applyRulesToUsedCGroups(ret.cgroupPaths);
        }
        ret.pythonPath = stash.pythonPath;
        ret.rsrcPath = stash.rsrcPath;
        ret.spark = new JupyterKernelSparkContext();
        try {
            this.buildSparkVars(projectKey, authCtx, jupyterSessionId, codeEnv, ret, stash, clusterSettings);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to setup Spark-related notebook env", (Throwable)e);
        }
        if (ret.impersonation) {
            new FilesystemACLHandler().setExclusiveAndStudioFullAccessOnDirectory(new File(ret.processRunDir), ret.unixUser);
        }
        return ret;
    }

    private void buildExecEnv(String projectKey, AuthCtx authCtx, Set<String> relevantProjectKeys, JupyterKernelContext ret, RemoteRunEnvDef envResource, ClusterSettings clusterSettings) throws IOException, DKUSecurityException, InterruptedException {
        SparkSettings ss = clusterSettings != null ? clusterSettings.getSparkSettings() : new SparkSettings();
        try (SparkBasedActivityHelper helper = new SparkBasedActivityHelper(projectKey, authCtx, new File(ret.processRunDir), null);){
            List<Object> properties = Lists.newArrayList();
            if (ss.sparkEnabled) {
                SparkExecutionConfig jupyterEC = (SparkExecutionConfig)JSON.deepCopy((Object)ss.getByName(ss.configForJupyter));
                properties = SparkJobHelper.composeConf(authCtx, projectKey, ss, jupyterEC, new ArrayList<SimpleKeyValue>());
            }
            helper.configure(relevantProjectKeys, properties);
            ret.delegationTokensFileLocation = helper.getDelegationTokenFileLocation();
            envResource.jobExecEnv = helper.getJobExecEnv();
            File envFile = new File(ret.processRunDir, "remote-run-env-def.json");
            logger.info((Object)("Dump exec env in " + envFile.getAbsolutePath()));
            DKUFileUtils.writeFileUTF8((File)envFile, (String)JSON.pretty((Object)envResource));
        }
    }

    private void buildSparkVars(String projectKey, AuthCtx authCtx, String jupyterSessionId, CodeEnvModel.UsedCodeEnvRef codeEnv, JupyterKernelContext ret, EnvironmentStash stash, ClusterSettings clusterSettings) throws IOException, DKUSecurityException, Exception {
        HadoopSettings hs;
        SparkSettings ss = clusterSettings != null ? clusterSettings.getSparkSettings() : new SparkSettings();
        HadoopSettings hadoopSettings = hs = clusterSettings != null ? clusterSettings.getHadoopSettings() : new HadoopSettings();
        if (ss.sparkEnabled && StringUtils.isNotBlank((String)ss.configForJupyter)) {
            List<String> submitArgs = null;
            List<String> pySubmitArgs = null;
            SparkExecutionConfig.SparklyrConfig sparklyrConfig = null;
            HashMap extraEnv = Maps.newHashMap();
            SparkExecutionConfig jupyterEC = (SparkExecutionConfig)JSON.deepCopy((Object)ss.getByName(ss.configForJupyter));
            new SparkConfigEnricher().setMetastoreConfKeysInKeys(jupyterEC);
            SparkSubmitHelper sparkSubmitHelper = SparkSubmitHelper.build(projectKey, authCtx, ss, hs, null, ss.getByName(ss.configForJupyter));
            List<String> pyFiles = sparkSubmitHelper.getPyFilesForClient(new File(ret.processRunDir), stash, false);
            List<SimpleKeyValue> conf = SparkJobHelper.composeConf(authCtx, projectKey, ss, jupyterEC, new ArrayList<SimpleKeyValue>());
            if (jupyterEC.kubernetesSettings.managedKubernetes) {
                ComputeResourceUsage cru = new ComputeResourceUsage();
                sparkSubmitHelper.setComputeResourceUsage(cru);
                SparkSubmitJob job = (SparkSubmitJob)sparkSubmitHelper.makeRawJob("jupyter", false, conf);
                SparkExecutionEnginesHelper.SparkRecipeJobBuilder fakeJobBuilder = new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

                    @Override
                    public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                        throw new Error("unreachable");
                    }

                    @Override
                    public SparkOverrideConfig getRecipeOverrideConf() {
                        throw new Error("unreachable");
                    }
                };
                File tmpTmpDir = new File(ret.processRunDir, "dku-spark-k8s-machinery");
                EnvironmentStash sparkStash = new EnvironmentStash();
                if (codeEnv != null && StringUtils.isNotBlank((String)codeEnv.envName)) {
                    sparkStash.env.put("DKU_CODE_ENV_NAME", codeEnv.envName);
                }
                SparkJobHelper.SparkJobContext context = sparkSubmitHelper.setupRunUsingClient(SparkJobHelper.RunMode.SPARK, fakeJobBuilder, tmpTmpDir, job, sparkStash, new SparkJobExecEnv(), codeEnv);
                cru.reportStartNoFail();
                if (ret.impersonation) {
                    new FilesystemACLHandler().setExclusiveAndStudioFullAccessOnDirectory(tmpTmpDir, ret.unixUser);
                }
                this.registerSparkContext(jupyterSessionId, context);
                extraEnv.putAll(sparkStash.env);
                submitArgs = SparkExecutionConfig.toSparkSubmitArgs(job.conf, new ArrayList<String>(), ss, hs, authCtx, projectKey);
                pySubmitArgs = SparkExecutionConfig.toSparkSubmitArgs(job.conf, pyFiles, ss, hs, authCtx, projectKey);
                sparklyrConfig = SparkExecutionConfig.toSparklyrConfig(job.conf, ss, hs, authCtx, projectKey);
            } else {
                submitArgs = SparkExecutionConfig.toSparkSubmitArgs(conf, new ArrayList<String>(), ss, hs, authCtx, projectKey);
                pySubmitArgs = SparkExecutionConfig.toSparkSubmitArgs(conf, pyFiles, ss, hs, authCtx, projectKey);
                sparklyrConfig = SparkExecutionConfig.toSparklyrConfig(conf, ss, hs, authCtx, projectKey);
            }
            try {
                ret.spark.pysparkSubmitArgs = JupyterSecurityService.joinSubmitArgs(pySubmitArgs) + " pyspark-shell";
                ret.spark.sparkrSubmitArgs = JupyterSecurityService.joinSubmitArgs(submitArgs) + " sparkr-shell";
                ret.spark.toreeSubmitArgs = JupyterSecurityService.joinSubmitArgs(submitArgs);
                ret.spark.sparklyrConfig = JSON.json((Object)sparklyrConfig);
                ret.spark.pysparkPythonPath = System.getenv("DKU_PYSPARK_PYTHONPATH");
                ret.spark.sparkHome = System.getenv("DKU_SPARK_HOME");
                ret.spark.extraEnv = extraEnv;
            }
            catch (Exception e) {
                logger.error((Object)"Unable to build spark notebooks' submission args, running with default", (Throwable)e);
            }
        }
    }

    static String joinSubmitArgs(List<String> submitArgs) {
        return submitArgs.stream().map(a -> {
            boolean hasSpace;
            boolean isQuoted = a.startsWith("\"") && a.endsWith("\"") && a.length() >= 2;
            boolean isSingleQuoted = a.startsWith("'") && a.endsWith("'") && a.length() >= 2;
            boolean hasQuote = a.indexOf(34) >= 0;
            boolean hasSingleQuote = a.indexOf(39) >= 0;
            boolean bl = hasSpace = a.indexOf(" ") >= 0;
            if (isQuoted || isSingleQuoted) {
                return a;
            }
            if (!(hasQuote || hasSingleQuote || hasSpace)) {
                return a;
            }
            if (hasQuote && hasSingleQuote) {
                return "\"" + a.replace("\"", "\\\"") + "\"";
            }
            if (hasQuote) {
                return "'" + a + "'";
            }
            if (hasSingleQuote) {
                return "\"" + a + "\"";
            }
            return "\"" + a + "\"";
        }).collect(Collectors.joining(" "));
    }

    public static class JupyterKernelContext {
        public boolean impersonation;
        public String processRunDir;
        public String ticketSecret;
        public String dssUser;
        public String unixUser;
        public String hadoopUser;
        public String delegationTokensFileLocation;
        public String forceHadoopUserName;
        public String sessionVirtualPath;
        public String cgroupsHierarchiesRoot;
        public Set<String> cgroupPaths = new HashSet<String>();
        public List<String> pythonPath;
        public List<String> rsrcPath;
        public JupyterKernelSparkContext spark;
        public String notebookObjectId;
        public String codeEnvName;
    }

    public static class JupyterKernelSparkContext {
        public String pysparkSubmitArgs;
        public String sparkrSubmitArgs;
        public String toreeSubmitArgs;
        public String sparklyrConfig;
        public String pysparkPythonPath;
        public String sparkHome;
        public Map<String, String> extraEnv;
    }
}

