/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class ElasticSearchIndexPartitioner
extends FilePartitioner {
    public ElasticSearchIndexPartitioner(PartitioningScheme scheme, String pattern) {
        super(scheme, pattern);
    }

    @Override
    public String resolvePartitionIdentifierInPattern(Partition p) {
        String resolved = super.resolvePartitionIdentifierInPattern(p);
        if (!"/".equals(resolved) && resolved.startsWith("/")) {
            return resolved.substring(1);
        }
        return null;
    }

    @Override
    protected String escapePattern(String p) {
        p = p.replace(".", "\\.");
        p = p.replace("*", "(.*?)");
        return p;
    }

    @Override
    protected Pattern compilePattern(String regex) {
        return Pattern.compile(regex, 2);
    }

    public List<Partition> getPartitions(Collection<String> partitions) {
        ArrayList<FSPath> fakePaths = new ArrayList<FSPath>();
        for (String index : partitions) {
            fakePaths.add(new FSPath("/" + index));
        }
        List<FilePartition> filePartitions = this.getPartitionsFromFiles(fakePaths);
        return new ArrayList<Partition>(filePartitions);
    }
}

