/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.automaticbin;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.common.automaticbin.AbstractAutomaticRequestHandler;
import com.dataiku.dip.pivot.backend.common.automaticbin.BinningModeComputer;
import com.dataiku.dip.pivot.backend.common.automaticbin.TimeInterval;
import com.dataiku.dip.pivot.backend.dss.PivotTableBuilder;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFilter;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class DssEngineAutomaticRequestHandler<TRequest extends PivotTableRequest>
extends AbstractAutomaticRequestHandler<TRequest> {
    private final LinoReader linoReader;
    private List<AxisFilter> axisFilters;

    protected DssEngineAutomaticRequestHandler(TRequest request, LinoReader linoReader) {
        super(request);
        this.linoReader = linoReader;
    }

    @Override
    protected TimeInterval buildTimeInterval(AxisDef axisDef) throws IOException {
        this.logTimeInterval(axisDef);
        return this.buildTimeInterval(this.linoReader, axisDef);
    }

    @Override
    protected BinningModeComputer buildBinningModeComputer(int maxBinNumberForAutomaticMode) {
        return new BinningModeComputer(maxBinNumberForAutomaticMode);
    }

    private TimeInterval buildTimeInterval(LinoReader linoReader, AxisDef axisDef) throws IOException {
        TimeInterval result = new TimeInterval();
        for (int blockIndex = 0; blockIndex < linoReader.nblocks(); ++blockIndex) {
            boolean[] keptRecords = this.buildBlockFullFilter(linoReader, blockIndex);
            ColumnBlock columnBlock = linoReader.readColumnBlock(axisDef.column, blockIndex);
            for (int recordIndex = 0; recordIndex < columnBlock.doubles.length; ++recordIndex) {
                boolean isDefined;
                if (!keptRecords[recordIndex]) continue;
                double storedTimestamp = columnBlock.doubles[recordIndex];
                boolean bl = isDefined = !Double.isNaN(storedTimestamp);
                if (!isDefined) continue;
                result.addTimestamp((long)storedTimestamp);
            }
        }
        return result;
    }

    private boolean[] buildBlockFullFilter(LinoReader linoReader, int blockIndex) throws IOException {
        boolean[] filters = new boolean[(int)linoReader.nbRecords()];
        Arrays.fill(filters, true);
        for (AxisFilter axisFilter : this.getActiveAxisFilters(linoReader)) {
            axisFilter.filter(linoReader, blockIndex, filters);
        }
        return filters;
    }

    private List<AxisFilter> getActiveAxisFilters(LinoReader linoReader) {
        if (this.axisFilters != null) {
            return this.axisFilters;
        }
        this.axisFilters = new ArrayList<AxisFilter>();
        for (RowFilter filter : this.request.filters) {
            if (!filter.active) continue;
            this.axisFilters.add(PivotTableBuilder.buildLinoAxisFilter(linoReader, filter));
        }
        return this.axisFilters;
    }
}

