/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.builders;

import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.common.ResponseValidator;
import com.dataiku.dip.pivot.backend.common.highcardinality.PostPruneSafetyChecks;
import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.GenericDataTensor;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.backend.sql.binners.AxisBinner;
import com.dataiku.dip.pivot.backend.sql.binners.BinnerBuilder;
import com.dataiku.dip.pivot.backend.sql.binners.DoubleAxisBinner;
import com.dataiku.dip.pivot.backend.sql.binners.LongAxisBinner;
import com.dataiku.dip.pivot.backend.sql.binners.StringAxisBinner;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.builders.InMemoryResultSet;
import com.dataiku.dip.pivot.backend.sql.utils.NullableDoubleArrayList;
import com.dataiku.dip.pivot.backend.sql.utils.NullableLongArrayList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class TensorPivotBuilder {
    private final PivotTableTensorRequest req;
    private final BasicStatsBuilder.BasicStats stats;

    public TensorPivotBuilder(PivotTableTensorRequest req, BasicStatsBuilder.BasicStats stats) {
        this.req = req;
        this.stats = stats;
    }

    public PivotTableTensorResponse parseResponse(InMemoryResultSet main, List<InMemoryResultSet> axes) throws SQLException {
        int i;
        PivotTableTensorResponse resp = new PivotTableTensorResponse(axes.size(), this.req);
        ArrayList<AxisBinner> binners = new ArrayList<AxisBinner>();
        BinnerBuilder builder = new BinnerBuilder(this.stats, this.req.computeSubTotals);
        for (int i2 = 0; i2 < axes.size(); ++i2) {
            InMemoryResultSet imrs = axes.get(i2);
            if (imrs != null) {
                binners.add(builder.buildFromAxis(this.req.axes[i2], imrs.axes[0]));
                continue;
            }
            binners.add(builder.buildFromData(this.req.axes[i2], main.axes[i2]));
        }
        int[] axisLengths = new int[axes.size()];
        for (i = 0; i < axes.size(); ++i) {
            resp.axisLabels[i] = ((AxisBinner)binners.get(i)).getAxisElts();
            axisLengths[i] = resp.axisLabels[i].size();
        }
        PostPruneSafetyChecks.checkTensorResponse(this.req, resp);
        resp.counts = new LongDataTensor(axisLengths);
        for (i = 0; i < this.req.aggregations.size(); ++i) {
            DataTensor matrix = new GenericDataTensor.Builder<Object>().clazz(Object.class).axisLengths(axisLengths).build();
            resp.aggregations.add(matrix);
        }
        int binCount = main.counts.size();
        int[][] binIndexes = new int[axes.size()][];
        for (int j = 0; j < axes.size(); ++j) {
            int i3;
            Object data;
            binIndexes[j] = new int[binCount];
            int[] bins = binIndexes[j];
            AxisBinner binner = (AxisBinner)binners.get(j);
            if (binner instanceof LongAxisBinner) {
                data = (NullableLongArrayList)((Object)main.axes[j]);
                LongAxisBinner longBinner = (LongAxisBinner)binner;
                for (i3 = 0; i3 < binCount; ++i3) {
                    bins[i3] = longBinner.assign(((NullableLongArrayList)((Object)data)).getNullable(i3));
                }
                continue;
            }
            if (binner instanceof DoubleAxisBinner) {
                data = (NullableDoubleArrayList)((Object)main.axes[j]);
                DoubleAxisBinner doubleBinner = (DoubleAxisBinner)binner;
                for (i3 = 0; i3 < binCount; ++i3) {
                    bins[i3] = doubleBinner.assign(((NullableDoubleArrayList)((Object)data)).getNullable(i3));
                }
                continue;
            }
            if (binner instanceof StringAxisBinner) {
                data = (ArrayList)main.axes[j];
                StringAxisBinner stringBinner = (StringAxisBinner)binner;
                for (i3 = 0; i3 < binCount; ++i3) {
                    bins[i3] = stringBinner.assign((String)((ArrayList)data).get(i3));
                }
                continue;
            }
            throw new UnsupportedOperation("Unsupported type");
        }
        BitSet aggrsFilled = new BitSet(resp.aggregations.size());
        for (int i4 = 0; i4 < binCount; ++i4) {
            int j;
            int[] coords = new int[axes.size()];
            for (j = 0; j < axes.size(); ++j) {
                coords[j] = binIndexes[j][i4];
            }
            resp.counts.put(coords, main.counts.get(i4));
            for (j = 0; j < resp.aggregations.size(); ++j) {
                Object v = main.aggregations.get(j).get(i4, true);
                DataTensor tensor = (DataTensor)resp.aggregations.get(j);
                if (((Aggregation)this.req.aggregations.get((int)j)).function == Aggregation.Function.COUNTD && !aggrsFilled.get(j)) {
                    this.fillTensorAxes(axes, j, tensor);
                    aggrsFilled.set(j);
                }
                if (main.aggregations.get((int)j).nonNullCounts != null) {
                    tensor.incrementNonNullCount(coords, main.aggregations.get((int)j).nonNullCounts[i4]);
                }
                if (v == null) continue;
                tensor.set(coords, v, true);
            }
        }
        for (long v : resp.counts.tensor) {
            resp.afterFilterRecords += v;
        }
        resp.aggregations.forEach(DataTensor::replaceInvalidValues);
        ResponseValidator.validateNonEmptyAxes(resp.counts);
        return resp;
    }

    private void fillTensorAxes(List<InMemoryResultSet> axes, int j, DataTensor<Object> tensor) {
        if (axes == null || tensor == null) {
            return;
        }
        block0: for (int axis = 0; axis < axes.size(); ++axis) {
            int y = 0;
            while ((long)y < axes.get((int)axis).count) {
                InMemoryResultSet inMemoryResultSet = axes.get(axis);
                if (inMemoryResultSet == null) {
                    axis = axes.size();
                    continue block0;
                }
                tensor.setAxis(axis, y, inMemoryResultSet.aggregations.get(j).get(y));
                ++y;
            }
        }
    }
}

