/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.cache;

import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.GenericDataTensor;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.builders.InMemoryResultSet;
import com.dataiku.dip.pivot.backend.sql.cache.FacetCache;
import com.dataiku.dip.pivot.backend.sql.cache.LRUList;
import com.dataiku.dip.pivot.backend.sql.utils.AxisUtils;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import com.dataiku.dip.utils.JSON;
import gnu.trove.list.array.TLongArrayList;
import java.util.ArrayList;
import java.util.List;

public class AxisCache {
    private LRUList<CachedAxis> data;
    private FacetCache facetCache;

    public AxisCache(FacetCache facetCache, int size) {
        this.facetCache = facetCache;
        this.data = new LRUList(size);
    }

    public synchronized void put(List<RowFilter> rfs, AxisUtils.ExtendedAxisDef def, InMemoryResultSet imrs) {
        CachedAxis ca = new CachedAxis();
        ca.imrs = imrs;
        ca.filters = FilterUtils.intersectAndSort(rfs);
        ca.def = def;
        this.data.addAndCollect(ca);
        if (def.def != null && def.def.type == AxisDef.Type.ALPHANUM && imrs.counts != null) {
            boolean hasNull = false;
            ArrayList axisValues = (ArrayList)imrs.axes[0];
            for (String s : axisValues) {
                if (s != null) continue;
                hasNull = true;
            }
            if (!(hasNull || def.def.sortPrune.isMaxValuesDefined() && def.def.sortPrune.maxValues <= imrs.count)) {
                this.putAsFacet(rfs, def, imrs);
            }
        }
    }

    public synchronized CachedAxis get(List<RowFilter> rfs, AxisUtils.ExtendedAxisDef def, boolean withAggregations) {
        ArrayList<CachedAxis> candidates = new ArrayList<CachedAxis>();
        for (CachedAxis ca : this.data) {
            if (!AxisUtils.produceSameSQLAxis(ca.def, def) || !FilterUtils.isEquivalent(ca.filters, rfs)) continue;
            if (!withAggregations) {
                return ca;
            }
            candidates.add(ca);
        }
        if (candidates.size() == 0) {
            return null;
        }
        ArrayList<AggregationMapping> aggregationMapping = new ArrayList<AggregationMapping>();
        TLongArrayList counts = null;
        for (Aggregation queriedAggregation : def.aggregations) {
            AggregationMapping foundMapping = null;
            block2: for (CachedAxis ca : candidates) {
                if (ca.imrs.counts != null) {
                    counts = ca.imrs.counts;
                }
                if (ca.imrs.aggregations == null) continue;
                for (int j = 0; j < ca.def.aggregations.size(); ++j) {
                    Aggregation currentAggregation = ca.def.aggregations.get(j);
                    if (!AxisUtils.isEquivalent(currentAggregation, queriedAggregation)) continue;
                    AggregationMapping map = new AggregationMapping();
                    map.aggrIndexInCandidate = j;
                    map.candidate = ca;
                    foundMapping = map;
                    break block2;
                }
            }
            if (foundMapping == null) {
                aggregationMapping.add(null);
                continue;
            }
            aggregationMapping.add(foundMapping);
        }
        CachedAxis fake = new CachedAxis();
        fake.def = (AxisUtils.ExtendedAxisDef)JSON.deepCopy((Object)def);
        fake.filters = (List)JSON.deepCopy(rfs);
        fake.imrs = new InMemoryResultSet(((CachedAxis)candidates.get((int)0)).imrs);
        if (withAggregations) {
            Aggregation countAggregation = new Aggregation(Aggregation.Function.COUNT, null, null);
            if (counts == null) {
                return null;
            }
            ArrayList<DataTensor<Object>> aggrs = new ArrayList<DataTensor<Object>>();
            for (int i = 0; i < def.aggregations.size(); ++i) {
                Aggregation aggr = def.aggregations.get(i);
                AggregationMapping map = (AggregationMapping)aggregationMapping.get(i);
                if (map != null) {
                    aggrs.add(map.candidate.imrs.aggregations.get(map.aggrIndexInCandidate));
                    continue;
                }
                if (AxisUtils.isEquivalent(aggr, countAggregation)) {
                    DataTensor ndal = new GenericDataTensor.Builder<Object>().clazz(Object.class).build();
                    for (int k = 0; k < counts.size(); ++k) {
                        ndal.addNonNullCount(counts.get(k));
                        ndal.add(counts.get(k), true);
                    }
                    aggrs.add(ndal);
                    continue;
                }
                return null;
            }
            fake.imrs.aggregations = aggrs;
            fake.imrs.counts = counts;
        } else {
            fake.imrs.aggregations = null;
            fake.imrs.counts = null;
        }
        return fake;
    }

    private synchronized void putAsFacet(List<RowFilter> rfs, AxisUtils.ExtendedAxisDef def, InMemoryResultSet imrs) {
        RowFilter rf = new RowFilter();
        rf.columnType = AxisDef.Type.ALPHANUM;
        rf.column = def.def.column;
        rf.excludedValues = new ArrayList<String>();
        FilterFacet facet = new FilterFacet();
        ArrayList axisValues = (ArrayList)imrs.axes[0];
        int total = 0;
        for (int i = 0; i < axisValues.size(); ++i) {
            String str = (String)axisValues.get(i);
            long count = imrs.counts.get(i);
            FilterFacet.Val val = new FilterFacet.Val(str, str, count);
            facet.values.add(val);
            total = (int)((long)total + count);
        }
        facet.totalNbValues = total;
        this.facetCache.put(rfs, rf, facet);
    }

    public static class CachedAxis {
        public List<RowFilter> filters;
        public AxisUtils.ExtendedAxisDef def;
        public InMemoryResultSet imrs;
    }

    private static class AggregationMapping {
        public int aggrIndexInCandidate;
        public CachedAxis candidate;

        private AggregationMapping() {
        }
    }
}

