/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.executors;

import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.executors.BasicStatsSQLExecutor;
import com.dataiku.dip.pivot.backend.sql.executors.ExecutionContext;
import com.dataiku.dip.pivot.backend.sql.queries.BasicStatsToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.utils.DKULogger;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class BasicStatsHybridExecutor
implements Callable<BasicStatsBuilder.BasicStats> {
    private static DKULogger logger = DKULogger.getLogger(BasicStatsHybridExecutor.class);
    private Future<ColumnMapper> colMappingFuture;
    private ExecutionContext ctx;
    private final Future<BasicStatsBuilder.BasicStats> globalStatsFuture;

    public BasicStatsHybridExecutor(ExecutionContext ctx, Future<ColumnMapper> colMappingFuture, Future<BasicStatsBuilder.BasicStats> globalStatsFuture) {
        this.colMappingFuture = colMappingFuture;
        this.ctx = ctx;
        this.globalStatsFuture = globalStatsFuture;
    }

    @Override
    public BasicStatsBuilder.BasicStats call() throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Computing basic column statistics...");){
            List<AxisDef> columnDefinitions = BasicStatsToSQL.determineDependentColumns(this.ctx.req);
            BasicStatsBuilder.BasicStats stats = this.ctx.cache.basicStatsCache.get(this.ctx.req.filters, columnDefinitions);
            if (stats != null) {
                logger.info((Object)"Computed basic column stats from cache");
                BasicStatsBuilder.BasicStats basicStats = stats;
                return basicStats;
            }
            BasicStatsSQLExecutor sqlStatsExecutor = new BasicStatsSQLExecutor(this.ctx, this.colMappingFuture, this.globalStatsFuture);
            stats = sqlStatsExecutor.call();
            this.ctx.cache.basicStatsCache.put((List<RowFilter>)this.ctx.req.filters, stats);
            BasicStatsBuilder.BasicStats basicStats = stats;
            return basicStats;
        }
    }
}

