/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.frontend.excel.BaseDataSheetBuilder;
import com.dataiku.dip.pivot.frontend.excel.CellStyler;
import com.dataiku.dip.pivot.frontend.excel.StdAggrDataSheet1DBuilder;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartSources;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartTextSource;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.SheetUtils;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellRangeAddress;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class GroupedXYDataSheet1DBuilder
extends BaseDataSheetBuilder {
    public static StdAggrDataSheet1DBuilder.DataSheet1DRef buildSheet(XSSFWorkbook workbook, ChartDef chartDef, final PivotTableTensorResponse response, int animationFrameIdx) {
        int[] coords;
        final XSSFSheet sheet = workbook.createSheet("Data");
        CellStyler styler = new CellStyler((Workbook)workbook);
        CellStyle titleStyle = styler.getTitleStyle();
        CellStyle headerStyle = styler.getHeaderStyle();
        SheetUtils.writeCell(sheet, 0, 0, chartDef.name).setCellStyle(titleStyle);
        SheetUtils.writeCell(sheet, 1, 0, com.dataiku.dip.pivot.frontend.ChartUtils.getNiceDimensionName(chartDef.groupDimension.get(0))).setCellStyle(headerStyle);
        String measureName = com.dataiku.dip.pivot.frontend.ChartUtils.getNiceMeasureName(chartDef.xMeasure.get(0));
        SheetUtils.writeCell(sheet, 1, 1, measureName).setCellStyle(headerStyle);
        measureName = com.dataiku.dip.pivot.frontend.ChartUtils.getNiceMeasureName(chartDef.yMeasure.get(0));
        SheetUtils.writeCell(sheet, 1, 2, measureName).setCellStyle(headerStyle);
        if (chartDef.sizeMeasure.size() > 0) {
            measureName = com.dataiku.dip.pivot.frontend.ChartUtils.getNiceMeasureName(chartDef.sizeMeasure.get(0));
            SheetUtils.writeCell(sheet, 1, 3, measureName).setCellStyle(headerStyle);
        }
        if (chartDef.colorMeasure.size() > 0) {
            measureName = com.dataiku.dip.pivot.frontend.ChartUtils.getNiceMeasureName(chartDef.colorMeasure.get(0));
            SheetUtils.writeCell(sheet, 1, 4, measureName).setCellStyle(headerStyle);
        }
        if (chartDef.animationDimension.isEmpty()) {
            coords = new int[1];
        } else {
            coords = new int[2];
            coords[1] = animationFrameIdx;
        }
        DataTensor aggX = (DataTensor)response.aggregations.get(0);
        DataTensor aggY = (DataTensor)response.aggregations.get(1);
        for (int i = 0; i < response.axisLabels[0].size(); ++i) {
            boolean isZeroCount;
            boolean hasNoX = aggX.nonNullCounts != null && aggX.nonNullCounts[i] == 0L;
            boolean hasNoY = aggY.nonNullCounts != null && aggY.nonNullCounts[i] == 0L;
            boolean bl = isZeroCount = response.counts.tensor[i] == 0L;
            if (hasNoX && hasNoY || isZeroCount) continue;
            coords[0] = i;
            AxisElt elt = response.axisLabels[0].get(i);
            String label = ChartUtils.labelify(elt.label);
            CellStyle axisStyle = styler.getValueStyle(i == response.axisLabels[0].size() - 1, true);
            SheetUtils.writeCell(sheet, 2 + i, 0, label).setCellStyle(axisStyle);
            CellStyle style = styler.getValueStyle(i == response.axisLabels[0].size() - 1, false, CellStyler.SpecialFormat.NONE);
            SheetUtils.writeCell(sheet, 2 + i, 1, aggX.getAsDouble(coords)).setCellStyle(style);
            SheetUtils.writeCell(sheet, 2 + i, 2, aggY.getAsDouble(coords)).setCellStyle(style);
            for (int j = 2; j < response.aggregations.size(); ++j) {
                SheetUtils.writeCell(sheet, 2 + i, j + 1, ((DataTensor)response.aggregations.get(j)).getAsDouble(coords)).setCellStyle(style);
            }
        }
        GroupedXYDataSheet1DBuilder.appendFilteringDetails(chartDef, sheet);
        SheetUtils.autoFitColumns(sheet);
        return new StdAggrDataSheet1DBuilder.DataSheet1DRef(){

            @Override
            public XSSFSheet getSheet() {
                return sheet;
            }

            @Override
            public XDDFDataSource<String> getAxisSource() {
                return XDDFDataSourcesFactory.fromStringCellRange((XSSFSheet)sheet, (CellRangeAddress)new CellRangeAddress(2, 1 + response.axisLabels[0].size(), 0, 0));
            }

            @Override
            public ChartTextSource getTitleSource() {
                return ChartSources.fromCellRange(sheet, new CellRangeAddress(0, 0, 0, 0));
            }

            @Override
            public ChartTextSource getAggregationTitleSource(int aggregationIdx) {
                if (aggregationIdx < 0 || aggregationIdx > response.aggregations.size()) {
                    throw new RuntimeException("Invalid aggregation idx: " + aggregationIdx);
                }
                return ChartSources.fromCellRange(sheet, new CellRangeAddress(1, 1, 1 + aggregationIdx, 1 + aggregationIdx));
            }

            @Override
            public XDDFNumericalDataSource<Double> getAggregationSource(int aggregationIdx) {
                return XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)sheet, (CellRangeAddress)this.getAggregationSourceRange(aggregationIdx));
            }

            @Override
            public CellRangeAddress getAggregationSourceRange(int aggregationIdx) {
                if (aggregationIdx < 0 || aggregationIdx > response.aggregations.size()) {
                    throw new RuntimeException("Invalid aggregation idx: " + aggregationIdx);
                }
                return new CellRangeAddress(2, 1 + response.axisLabels[0].size(), 1 + aggregationIdx, 1 + aggregationIdx);
            }
        };
    }
}

