/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel.xssf.charts;

import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.BaseChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.series.Series1D;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAreaChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAreaSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.openxmlformats.schemas.drawingml.x2006.chart.STGrouping;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;

public class AreaChart
extends BaseChart<Series1D> {
    private STGrouping.Enum grouping = STGrouping.STACKED;

    public void setGrouping(STGrouping.Enum grouping) {
        this.grouping = grouping;
    }

    @Override
    public void plot(XDDFChart chart, XDDFChartAxis ... chartAxes) {
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTAreaChart ctAreaChart = plotArea.addNewAreaChart();
        CTGrouping ctGrouping = ctAreaChart.addNewGrouping();
        ctGrouping.setVal(this.grouping);
        ctAreaChart.addNewVaryColors().setVal(false);
        for (Series1D series : this.getSeries()) {
            CTAreaSer areaSer = ctAreaChart.addNewSer();
            areaSer.addNewIdx().setVal((long)series.getId());
            areaSer.addNewOrder().setVal((long)series.getId());
            CTShapeProperties spPr = areaSer.addNewSpPr();
            CTSolidColorFillProperties scfp = spPr.addNewSolidFill();
            CTSRgbColor rgbColor = scfp.addNewSrgbClr();
            rgbColor.setVal(series.getColor().asByteArray());
            CTSerTx tx = areaSer.addNewTx();
            ChartUtils.buildSerTx(tx, series.getTitle());
            CTAxDataSource cats = areaSer.addNewCat();
            ChartUtils.buildAxDataSource(cats, series.getLabels());
            CTNumDataSource vals = areaSer.addNewVal();
            ChartUtils.buildNumDataSource(vals, series.getXValues());
        }
        for (XDDFChartAxis axis : chartAxes) {
            ctAreaChart.addNewAxId().setVal(axis.getId());
        }
    }
}

