/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.processes;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.processes.CGroupHelper;
import com.dataiku.dip.processes.LambdaCGroupHelper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UIFSudoHelper;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractCGroupHelper {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.processes.cgroups");

    public abstract boolean isEnabled();

    public abstract String getHierarchiesMountPoint();

    public abstract Set<String> getTargetCGroups();

    public abstract void createCGroups(Set<String> var1);

    public abstract void applyRulesToUsedCGroups(Set<String> var1);

    public abstract GeneralSettingsDAO.LocalProcessesCgroupsSettings.CGroupsVersion getCGroupsVersion();

    public abstract String getCGroupsV2Controllers();

    public void applyCGroupsConfigToProcess(int pid) {
        Set<String> targets = this.getTargetCGroups();
        this.applyCGroupsToProcess(pid, targets);
        this.applyRulesToUsedCGroups(targets);
    }

    protected void ensureSubtreeControl(String path) {
        String subtreeControl = Arrays.stream(this.getCGroupsV2Controllers().split(",")).map(c2 -> "+" + c2).collect(Collectors.joining(" "));
        File dir = new File(this.getHierarchiesMountPoint());
        logger.infoV("Setting cgroup controllers for %s: %s", new Object[]{path, subtreeControl});
        String[] entries = path.split("/");
        for (int i = 0; i < entries.length - 1; ++i) {
            File control = new File(dir = new File(dir, entries[i]), "cgroup.subtree_control");
            if (control.canWrite()) {
                logger.debugV("Updating subtree_control %s", new Object[]{control});
                try {
                    FileUtils.writeStringToFile((File)control, (String)subtreeControl, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    logger.warn((Object)("Failed to set cgroup controllers in " + String.valueOf(control)), (Throwable)e);
                }
                continue;
            }
            logger.debugV("Not Updating subtree_control %s (cannot write)", new Object[]{control});
        }
    }

    private void applyCGroupsToProcess(int pid, Set<String> targets) {
        for (String path : targets) {
            File cgroupDir = DKUFileUtils.getWithin((File)new File(this.getHierarchiesMountPoint(), path), (String[])new String[0]);
            logger.info((Object)("Adding process " + pid + " to cgroup " + String.valueOf(cgroupDir)));
            try {
                DKUFileUtils.mkdirs((File)cgroupDir);
                if (this.getCGroupsVersion() == GeneralSettingsDAO.LocalProcessesCgroupsSettings.CGroupsVersion.CGROUPS_V2) {
                    this.ensureSubtreeControl(path);
                    IImpersonationResolverService irs = (IImpersonationResolverService)SpringUtils.getBean(IImpersonationResolverService.class);
                    if (irs.isEnabled()) {
                        List<String> args = UIFSudoHelper.getSudoCommand();
                        args.add(UIFSudoHelper.getExecWrapperLocation().getAbsolutePath());
                        args.addAll(Lists.newArrayList((Object[])new String[]{"set-cgroup", "--pid", "" + pid, "--cgroup", cgroupDir.getAbsolutePath()}));
                        UIFSudoHelper.execWithSudoErrorSniffer(args, "set-cgroup");
                        continue;
                    }
                    logger.warn((Object)"Trying to apply cgroup v2 location to a non-impersonated process, it will probably fail");
                    FileUtils.writeStringToFile((File)new File(cgroupDir, "cgroup.procs"), (String)("" + pid), (Charset)StandardCharsets.UTF_8);
                    continue;
                }
                FileUtils.writeStringToFile((File)new File(cgroupDir, "tasks"), (String)("" + pid), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException | InterruptedException e) {
                logger.warn((Object)("Failed to add process " + pid + " to cgroup " + String.valueOf(cgroupDir)), (Throwable)e);
            }
        }
    }

    public static AbstractCGroupHelper getCGroupHelper(AuthCtx authCtx, String projectKey, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws IOException {
        if (ApplicationConfigurator.isDevLambdaServer()) {
            LambdaContext lambdaContext = (LambdaContext)SpringUtils.getBean(LambdaContext.class);
            LambdaServerConfig.DevLambdaServerSettings devLsc = lambdaContext.getMandatoryConfig().devLambdaServerSettings;
            return new LambdaCGroupHelper(devLsc);
        }
        return new CGroupHelper(authCtx, projectKey, cgrouppableProcessType);
    }
}

