/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.hive;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.recipes.CodeRecipeParams;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.code.hive.HiveRecipeCreator;
import com.dataiku.dip.recipes.code.hive.HiveRecipeRunner;
import com.dataiku.dip.recipes.code.hive.HiveRecipeSchemaComputer;
import com.dataiku.dip.recipes.code.hive.HiveRecipeStatusComputer;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Lists;
import java.util.List;

public class HiveRecipeMeta
extends RecipeMeta {
    public static final HiveRecipeMeta META = new HiveRecipeMeta();

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return HiveRecipeParams.class;
    }

    @Override
    public String getType() {
        return "hive";
    }

    @Override
    public HiveRecipeCreator buildCreator(AuthCtx authCtx) {
        return new HiveRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.EXPENSIVE;
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new HiveRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        return new HiveRecipeRunner(activity);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new HiveRecipeStatusComputer(recipe, payload);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        RecipeDesc desc = RecipeDesc.newDescWithNaryDatasets("Hive", null);
        desc.inputRoles.get(0).withHdsOrHivefOnly();
        RecipeDesc.IORoleDef out = desc.outputRoles.get(0);
        out.arity = RecipeDesc.IOArity.NARY;
        out.withHdsfOnly();
        return desc;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withUserCode();
    }

    @Override
    public boolean hasJsonPayload() {
        return false;
    }

    @Override
    public HiveExecutionEngine getHiveEngine(SerializedRecipe sr, String payload) {
        HiveRecipeParams params = sr.getParamsAs(HiveRecipeParams.class);
        return params.executionEngine;
    }

    @Override
    public String setHiveEngine(SerializedRecipe sr, String payload, HiveExecutionEngine executionEngine) {
        HiveRecipeParams params = sr.getParamsAs(HiveRecipeParams.class);
        params.executionEngine = executionEngine;
        return payload;
    }

    public static class HiveRecipeParams
    extends CodeRecipeParams {
        public String inheritConf = "default";
        public List<SimpleKeyValue> hiveconf = Lists.newArrayList();
        public String preQueries;
        public HiveExecutionEngine executionEngine = HiveExecutionEngine.HIVECLI_LOCAL;
        public boolean addDkuUdf = false;
    }

    public static enum HiveExecutionEngine {
        HIVECLI_LOCAL,
        HIVECLI_GLOBAL,
        HIVESERVER2;

    }
}

