/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.pig;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.code.CodeBasedRecipeStatus;
import com.dataiku.dip.recipes.code.hive.HiveRecipeTester;
import com.dataiku.dip.recipes.code.pig.PigRecipeTester;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class PigRecipeStatusComputer
extends RecipeStatusComputer {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GenericRecipesValidationService validationService;

    public PigRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph> subgraphCallable;
        CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest request = (CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest)JSON.parse((String)requestData, CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest.class);
        if (request == null) {
            try (Transaction t = this.transactionService.beginRead();){
                HiveRecipeTester.HiveRecipeStatus hiveRecipeStatus = this.fastStatusIgnorePartitions(authCtx);
                return hiveRecipeStatus;
            }
        }
        PigRecipeTester tester = new PigRecipeTester();
        PigRecipeTester.PigCheckContext ctx = null;
        try (Transaction t = this.transactionService.beginRead();){
            this.recipe.name = "testRecipe";
            FlowGraph graph = new FlowGraph();
            FlowRecipe flowRecipe = graph.buildSingleRecipe(this.recipe);
            assert (flowRecipe != null);
            subgraphCallable = this.validationService.getValidationRunnableSubgraph(authCtx, flowRecipe, request.targetPartitionSpec);
        }
        RecipeRunnableSubgraph subgraph = subgraphCallable.call_NT();
        try (Transaction t = this.transactionService.beginRead();){
            ctx = tester.startCheckPig(authCtx, this.recipe, this.payload, subgraph);
        }
        ctx.status.addSingleEngine("PIG", "Pig", null, null, "Pig");
        if (ctx.status.gatherAllMessages().anyFatal()) {
            return ctx.status;
        }
        tester.doCheckPig_NT(ctx);
        tester.finishCheckPig_NG(ctx);
        return ctx.status;
    }

    @Override
    public HiveRecipeTester.HiveRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws IOException, DKUSecurityException {
        HiveRecipeTester.HiveRecipeStatus ret = new HiveRecipeTester.HiveRecipeStatus();
        this.performBasicStructureChecks(ret, authCtx);
        ret.addSingleEngine("PIG", "Pig", null, null, "Pig");
        return ret;
    }
}

