/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLQueryToInsertTransformer {
    private static final String INFO_MESSAGE_TEMPLATE = "Putting query in %s '%s': %s";
    private static final String CREATE_VIEW = "CREATE VIEW";
    private static final String INSERT_INTO = "INSERT INTO";
    private static DKULogger logger = DKULogger.getLogger((String)"dip.sql.addinsert");

    private SQLQueryToInsertTransformer() {
    }

    public static String transform(SQLConnectionProvider.SQLConnectionData connData, String sqlQuery, String outputCatalog, String outputSchema, String outputTable, Dataset outputDataset, boolean mayContainWithOrUnion, boolean isVirtualized) {
        SQLDialect sqlDialect = connData.getDialect();
        Splitter splitter = new Splitter(sqlDialect.getSemicolonExclusionPortionFinders());
        logger.infoV(INFO_MESSAGE_TEMPLATE, new Object[]{isVirtualized ? CREATE_VIEW : INSERT_INTO, outputTable, sqlQuery});
        int explicitPos = -1;
        if (((String)sqlQuery).toLowerCase(Locale.ENGLISH).contains("dku_main_statement")) {
            Pattern explicitInsert = Pattern.compile("\\bdku_main_statement\\b", 2);
            explicitPos = splitter.findFirstMatch((String)sqlQuery, explicitInsert, 0, true, false, false);
        }
        String instruction = SQLQueryToInsertTransformer.getStatementToAdd(sqlDialect, outputCatalog, outputSchema, outputTable, outputDataset.getSchema(), isVirtualized);
        if (explicitPos >= 0 && explicitPos < ((String)sqlQuery).length()) {
            logger.info((Object)("Found explicit insertion point at " + explicitPos));
            String insert = " \n" + instruction + " \n";
            sqlQuery = ((String)sqlQuery).substring(0, explicitPos) + insert + ((String)sqlQuery).substring(explicitPos);
            return sqlQuery;
        }
        Pattern select = Pattern.compile("\\b(select)\\b", 2);
        Matcher wrappingTriggersMatcher = null;
        if (mayContainWithOrUnion) {
            String rawKeywordsQuery = splitter.stripCommentsAndStrings((String)sqlQuery);
            if (!select.matcher(rawKeywordsQuery).find()) {
                throw ErrorContext.iae((String)"The SQL query doesn't contain any SELECT statement");
            }
            Pattern wrappingTriggers = Pattern.compile("\\b(with|union)\\b", 2);
            wrappingTriggersMatcher = wrappingTriggers.matcher(rawKeywordsQuery);
        }
        if (mayContainWithOrUnion && wrappingTriggersMatcher.find()) {
            logger.info((Object)("Found a " + wrappingTriggersMatcher.group(1) + ", using a wrapped query"));
            sqlQuery = ((String)sqlQuery).trim();
            if (((String)sqlQuery).endsWith(";")) {
                assert (((String)sqlQuery).length() > 1);
                sqlQuery = ((String)sqlQuery).substring(0, ((String)sqlQuery).length() - 1);
            }
            sqlQuery = " " + instruction + " \nSELECT * FROM (" + (String)sqlQuery + "\n) " + sqlDialect.quoteIdentifier("wrappedSelectQuery");
        } else {
            int idx = ((String)sqlQuery).toUpperCase().indexOf("SELECT", splitter.findFirstMatch((String)sqlQuery, select, 0, false, false, true));
            String insert = " \n" + instruction + " \n";
            sqlQuery = ((String)sqlQuery).substring(0, idx) + insert + ((String)sqlQuery).substring(idx);
        }
        return sqlQuery;
    }

    public static String transform(SQLConnectionProvider.SQLConnectionData connData, String sqlQuery, String outputCatalog, String outputSchema, String outputTable, Dataset outputDataset, boolean mayContainWithOrUnion) {
        return SQLQueryToInsertTransformer.transform(connData, sqlQuery, outputCatalog, outputSchema, outputTable, outputDataset, mayContainWithOrUnion, false);
    }

    private static String getStatementToAdd(SQLDialect sqlDialect, String outputCatalog, String outputSchema, String outputTable, Schema schema, boolean createView) {
        if (createView) {
            return sqlDialect.getCreateViewInstruction(outputCatalog, outputSchema, outputTable);
        }
        return sqlDialect.getInsertIntoInstruction(outputCatalog, outputSchema, outputTable, schema);
    }
}

