/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.common;

import java.util.List;

public class RecipeEngineStatus {
    public static final String ENGINE_DSS = "DSS";
    public static final String ENGINE_USER_CODE = "USER_CODE";
    public static final String ENGINE_PLUGIN_CODE = "PLUGIN_CODE";
    public static final String ENGINE_HADOOP_MR = "HADOOP_MAPREDUCE";
    public static final String ENGINE_SPARK = "SPARK";
    public static final String ENGINE_PIG = "PIG";
    public static final String ENGINE_SQL = "SQL";
    public static final String ENGINE_HIVE = "HIVE";
    public static final String ENGINE_IMPALA = "IMPALA";
    public static final String ENGINE_S3_TO_REDSHIFT = "S3_TO_REDSHIFT";
    public static final String ENGINE_REDSHIFT_TO_S3 = "REDSHIFT_TO_S3";
    public static final String ENGINE_AZURE_BLOB_TO_SYNAPSE = "AZURE_TO_SQLSERVER";
    public static final String ENGINE_AZURE_BLOB_TO_FABRIC = "AZURE_TO_FABRIC";
    public static final String TERADATA_HADOOP_CONNECTOR = "TDCH";
    public static final String ENGINE_GCS_TO_BIGQUERY = "GCS_TO_BIGQUERY";
    public static final String ENGINE_BIGQUERY_TO_GCS = "BIGQUERY_TO_GCS";
    public static final String ENGINE_S3_TO_SNOWFLAKE = "S3_TO_SNOWFLAKE";
    public static final String ENGINE_SNOWFLAKE_TO_S3 = "SNOWFLAKE_TO_S3";
    public static final String ENGINE_WASB_TO_SNOWFLAKE = "WASB_TO_SNOWFLAKE";
    public static final String ENGINE_SNOWFLAKE_TO_WASB = "SNOWFLAKE_TO_WASB";
    public static final String ENGINE_GCS_TO_SNOWFLAKE = "GCS_TO_SNOWFLAKE";
    public static final String ENGINE_SNOWFLAKE_TO_GCS = "SNOWFLAKE_TO_GCS";
    public static final String ENGINE_AZURE_TO_DATABRICKS = "AZURE_TO_DATABRICKS";
    public static final String ENGINE_DATABRICKS_TO_AZURE = "DATABRICKS_TO_AZURE";
    public static final String ENGINE_S3_TO_DATABRICKS = "S3_TO_DATABRICKS";
    public static final String ENGINE_DATABRICKS_TO_S3 = "DATABRICKS_TO_S3";
    public static final String ENGINE_DBVOLUME_TO_DATABRICKS = "DBVOLUME_TO_DATABRICKS";
    public static final String ENGINE_S3_TO_TRINO = "S3_TO_TRINO";
    public static final String ENGINE_TRINO_TO_S3 = "TRINO_TO_S3";
    public static final String ENGINE_AZURE_TO_TRINO = "AZURE_TO_TRINO";
    public static final String ENGINE_TRINO_TO_AZURE = "TRINO_TO_AZURE";
    public static final String ENGINE_GCS_TO_TRINO = "GCS_TO_TRINO";
    public static final String ENGINE_TRINO_TO_GCS = "TRINO_TO_GCS";
    public static final String VARIANT_MEMORY = "MEMORY";
    public static final String VARIANT_STREAM = "STREAM";
    public static final String VARIANT_DISK_COPY = "DISK_COPY";
    public static final String VARIANT_PYTHON = "PYTHON";
    public static final String VARIANT_R = "R";
    public static final String VARIANT_JULIA = "JULIA";
    public static final String VARIANT_SHELL = "SHELL";
    public static final String VARIANT_KSQL = "KSQL";
    public static final String VARIANT_SPARK_R = "SPARK_R";
    public static final String VARIANT_PY_SPARK = "PY_SPARK";
    public static final String VARIANT_SPARK_SQL = "SPARK_SQL";
    public static final String VARIANT_SPARK_SCALA = "SPARK_SCALA";
    public static final String VARIANT_SPARK_NATIVE = "SPARK_NATIVE";
    public static final String VARIANT_MLLIB = "MLLIB";
    public static final String VARIANT_H2O = "H20";
    public static final String VARIANT_IN_DB = "IN_DB";
    public static final String VARIANT_VERTICA_ML = "VERTICA_ML";
    public static final String VARIANT_SNOWFLAKE = "IN_SNOWFLAKE";
    public static final String VARIANT_TERADATA_TO_HADOOP = "TERADATA_TO_HADOOP";
    public static final String VARIANT_HADOOP_TO_TERADATA = "HADOOP_TO_TERADATA";
    public String type;
    public String typeLabel;
    public String variant;
    public String variantLabel;
    public String label;
    public String description;
    public boolean isSelectable;
    public WarningLevel statusWarnLevel = WarningLevel.OK;
    public String statusMessage;
    public String statusMessageDetails;
    public String notOptimizedBecauseMessage;
    public boolean recommended;
    public boolean canEngineAppend = true;
    public Boolean isCDEDowngradedToLocal = null;

    public boolean isOK() {
        return this.isSelectable && this.statusWarnLevel != WarningLevel.ERROR;
    }

    public static void setErrorStatus(String msg, RecipeEngineStatus ... engines) {
        for (RecipeEngineStatus engine : engines) {
            if (engine.statusWarnLevel == WarningLevel.ERROR) continue;
            engine.setStatus(msg, WarningLevel.ERROR);
        }
    }

    public static void setWarningStatus(String msg, RecipeEngineStatus ... engines) {
        for (RecipeEngineStatus engine : engines) {
            if (engine.statusWarnLevel == WarningLevel.ERROR || engine.statusWarnLevel == WarningLevel.WARN) continue;
            engine.setStatus(msg, WarningLevel.WARN);
        }
    }

    public RecipeEngineStatus() {
    }

    public RecipeEngineStatus(String type, String typeLabel, String variant, String variantLabel, String label) {
        this.type = type;
        this.typeLabel = typeLabel;
        this.variant = variant;
        this.variantLabel = variantLabel;
        this.label = label;
    }

    public void setStatus(String statusMessage, WarningLevel statusWarningLevel) {
        if (this.isSelectable) {
            this.statusMessage = statusMessage;
            this.statusWarnLevel = statusWarningLevel;
        }
    }

    public void markAsNonSelectable(String statusMessage, WarningLevel statusWarningLevel) {
        this.statusMessage = statusMessage;
        this.statusWarnLevel = statusWarningLevel;
        this.isSelectable = false;
    }

    public static RecipeEngineStatus getByType(List<RecipeEngineStatus> list, String lookupType) {
        for (RecipeEngineStatus e : list) {
            if (!e.type.equals(lookupType)) continue;
            return e;
        }
        throw new IllegalArgumentException("Engine of type '" + lookupType + "' not found");
    }

    public static enum WarningLevel {
        OK,
        WARN,
        ERROR;

    }
}

