/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.univariate.MoodTestNSamp;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.AbstractTwoSampleTestStat;
import javax.annotation.Nullable;

public class TwoSampleMoodTestStat
extends AbstractTwoSampleTestStat {
    private static final String TWO_SAMPLE_MEDIAN_MOOD_TEST = "MEDIAN_MOOD_TEST_TWO_SAMPLE";

    public TwoSampleMoodTestStat(String testColumn, String groupByColumn, @Nullable String[] groupValues1, @Nullable String[] groupValues2) {
        super(testColumn, groupByColumn, groupValues1, groupValues2);
    }

    public TwoSampleMoodTestStat() {
    }

    @Override
    protected void fillTestParams(Row row, ColumnFactory cf) {
        super.fillTestParams(row, cf);
        row.put(cf.column("test"), TWO_SAMPLE_MEDIAN_MOOD_TEST);
    }

    @Override
    protected Computation getTestComputation(StatsTestRecipePayloadParams<?> payloadParams) {
        return new MoodTestNSamp(this.testColumn, this.getPopulationGrouping());
    }

    @Override
    protected void fillTestResult(AvailableResult result, double significanceLevel, ColumnFactory cf, Row row) {
        MoodTestNSamp.MoodTestNSampResult tr = result.as(MoodTestNSamp.MoodTestNSampResult.class);
        double pValue = tr.pvalue;
        String conclusion = TwoSampleMoodTestStat.conclusion(pValue, significanceLevel);
        row.put(cf.column("pearson_chi2_statistic"), tr.statistic);
        row.put(cf.column("p_value"), pValue);
        row.put(cf.column("conclusion"), conclusion);
    }
}

