/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.finetuning;

import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.GenericRecipeCreator;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.nlp.finetuning.FineTuningRecipePayloadParams;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class FineTuningRecipeCreator
extends GenericRecipeCreator {
    @Autowired
    private SavedModelsCRUDService savedModelsCRUDService;

    public FineTuningRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    public RecipeCreator.CreationResult create_NT(SerializedRecipe recipe, JsonObject creationData) throws Exception {
        assert (StringUtils.isNotBlank((String)recipe.projectKey));
        assert (this.meta.getType().equals(recipe.type));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)recipe.name), (Object)"Recipe has no name");
        if (!creationData.has("outputModelName") || StringUtils.isBlank((String)creationData.get("outputModelName").getAsString())) {
            throw new IllegalArgumentException("Fine tuning recipe requires one LLM output");
        }
        RecipeCreator.CreationResult ret = new RecipeCreator.CreationResult();
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            FineTuningRecipeCreationSettings settings = (FineTuningRecipeCreationSettings)JSON.parse((JsonElement)creationData, FineTuningRecipeCreationSettings.class);
            Pattern pattern = Pattern.compile("[./]");
            if (pattern.matcher(settings.outputModelName).find()) {
                throw new IllegalArgumentException("Invalid fine tuned model name '" + settings.outputModelName + "'");
            }
            recipe.name = this.recipeSaveService.transmogrifyName(recipe.projectKey, recipe.name);
            recipe.params = new ContainerRecipeParams();
            recipe.maxRunningActivities = 1;
            if (StringUtils.isBlank((String)settings.zone)) {
                settings.zone = this.flowZonesService.retrieveInputZone(recipe);
            }
            this.flowZonesService.attachObjectToZone(settings.zone, recipe.getProjectKey(), recipe);
            SavedModel sm = new SavedModel();
            sm.projectKey = recipe.getProjectKey();
            sm.id = SecretKeyGenerator.generate((int)8);
            sm.name = settings.outputModelName;
            sm.savedModelType = SavedModel.SavedModelType.LLM_GENERIC;
            sm.contentType = SavedModel.llmFinetuningContentType;
            this.savedModelsCRUDService.save(sm, true, false);
            this.flowZonesService.attachObjectToZone(settings.zone, recipe.getProjectKey(), sm);
            recipe.addOutput("finetuned_model", sm.id, false);
            new PDepsFixuper().fixupInPlace(recipe);
            this.checkOutputOwnership_T(recipe);
            FineTuningRecipePayloadParams recipeParams = new FineTuningRecipePayloadParams();
            recipeParams.hyperparameters.setDefaultHyperparameters();
            this.recipeSaveService.create(recipe.projectKey, recipe, JSON.pretty((Object)recipeParams));
            t.commitV("Created %s recipe: %s", new Object[]{recipe.type, recipe.getFullId()});
            ret.id = recipe.name;
            RecipeCreator.CreationResult creationResult = ret;
            return creationResult;
        }
    }

    public static class FineTuningRecipeCreationSettings {
        public String outputModelName;
        public String zone;
    }
}

