/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.DockerExecUtils;
import com.dataiku.dip.containers.exec.KubectlHelper;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.common.CodeBasedThingHelper;
import com.dataiku.dip.dataflow.common.JobProcessExecution;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.Initializable;
import com.dataiku.dip.dataflow.exec.JobExecutionResultHandler;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.k8s.IK8SContainerLimits;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.facet.CountMap;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCodeBasedContinuousActivityRunner
implements FlowRunnable,
Initializable,
AbortableRecipeRunner {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.continuous.base");
    protected final ContinuousActivity activity;
    protected final SerializedRecipe recipe;
    protected String projectKey;
    private List<Runnable> abortables = Lists.newArrayList();
    private volatile boolean aborted;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    protected APITicketService apiTicketService;
    @Autowired
    protected JobAuthCtxService authCtxService;

    public AbstractCodeBasedContinuousActivityRunner(ContinuousActivity activity, SerializedRecipe recipe) {
        this.activity = activity;
        this.recipe = recipe;
        this.projectKey = activity.projectKey;
    }

    protected synchronized void addAbortable(Runnable abortHook) {
        this.abortables.add(abortHook);
    }

    protected synchronized void removeAbortable(Runnable abortHook) {
        this.abortables.remove(abortHook);
    }

    protected synchronized List<Runnable> getAbortables() {
        return Lists.newArrayList(this.abortables);
    }

    @Override
    public void notifyBeforeAborting() {
        logger.info((Object)("Aborting continuous runner " + this.getClass().getCanonicalName()));
        this.aborted = true;
        for (Runnable abortHook : this.getAbortables()) {
            abortHook.run();
        }
    }

    protected JobExecutionResultHandler getExecutionResultHandler() {
        return new JobExecutionResultHandler();
    }

    protected void writeRemoteRunEnvDefForLocalExecution(File recipeTmpDir, Map<String, String> extraEnv, String envName) throws IOException, SQLException, CodedException, DKUSecurityException, InterruptedException {
        EnvironmentStash stash = this.prepareEnvStash(recipeTmpDir, extraEnv, envName);
        stash.setCommunicationVarsForLocalOnlyExecution();
        RemoteRunEnvDef envResource = new RemoteRunEnvDef();
        envResource.runsRemotely = false;
        envResource.cwd = recipeTmpDir.getAbsolutePath();
        stash.copyToRemoteRunEnvDef(envResource, true, true, false);
        envResource.jobId = this.activity.recipeId;
        envResource.python = new RemoteRunEnvDef.PythonEnvResource();
        envResource.python.pythonPathChunks = stash.pythonPath;
        File envFile = new File(recipeTmpDir, "remote-run-env-def.json");
        logger.info((Object)("Writing dku-exec-env for local execution in " + envFile.getAbsolutePath()));
        DKUFileUtils.writeFileUTF8((File)envFile, (String)JSON.pretty((Object)envResource));
    }

    protected EnvironmentStash prepareEnvStash(File tmpDir, Map<String, String> extraEnv, String envName) throws IOException, SQLException, CodedException, DKUSecurityException, InterruptedException {
        EnvironmentStash environmentStash = new EnvironmentStash();
        environmentStash.fillDefault();
        environmentStash.fillForContinuousRecipe(this.authCtxService.getAuthCtx(), this.activity, tmpDir);
        environmentStash.env.putAll(extraEnv);
        if (StringUtils.isNotBlank((String)envName)) {
            environmentStash.env.put("DKU_CODE_ENV_NAME", envName);
        }
        return environmentStash;
    }

    protected ContinuousProcessExecution getLocalProcessExecution() {
        return new ContinuousLocalProcessExecution(this.authCtxService.getAuthCtx(), this.projectKey);
    }

    protected void executeLocal(ProcessBuilder builder, Object optionalInput, String languageInfo, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, boolean forceDisableImpersonation, File logFile) throws Exception {
        try (AbortableContinuousProcessExecution abortHook = new AbortableContinuousProcessExecution(this.getLocalProcessExecution());){
            CodeBasedThingHelper.ExecutionResult result = abortHook.p.executeNoFail(builder, optionalInput, logFile, cgrouppableProcessType, forceDisableImpersonation);
            this.getExecutionResultHandler().handleExecutionResult(builder.directory(), languageInfo, result);
        }
    }

    protected ContinuousProcessExecution getDockerProcessExecution(ContainerExecRuntimeConfig containerConfig, String containerJobId) {
        return new ContinuousDockerProcessExecution(this.authCtxService.getAuthCtx(), this.projectKey, containerConfig, containerJobId);
    }

    protected void executeDocker(ProcessBuilder builder, Object optionalInput, String languageInfo, ContainerExecRuntimeConfig containerConfig, String containerJobId, File logFile) throws Exception {
        try (AbortableContinuousProcessExecution abortHook = new AbortableContinuousProcessExecution(this.getDockerProcessExecution(containerConfig, containerJobId));){
            CodeBasedThingHelper.ExecutionResult result = abortHook.p.executeNoFail(builder, optionalInput, logFile, null, true);
            this.getExecutionResultHandler().handleExecutionResult(builder.directory(), languageInfo, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDockerCodeRecipe(CodeEnvModel.UsedCodeEnvRef codeEnvRef, ContainerExecRuntimeConfig containerConfig, File contextPath, File recipeTmpDir, RemoteRunsRegistry.ExecutionType executionType, String definition, String payload, Map<String, String> extraEnv, File logFile, Collection<String> readablePaths) throws Exception {
        String executionId = this.recipe.type + "-" + SecretKeyGenerator.generateSmall();
        String imageId = this.prepareContainerExecution(contextPath, recipeTmpDir, executionId, containerConfig.dockerHost, containerConfig.baseImage, codeEnvRef, executionType, definition, payload, readablePaths);
        imageId = ContainerExecImagesHelper.withRepositoryURL(containerConfig.repositoryURL, imageId);
        String containerJobId = "dku_cexec-" + executionId;
        RemoteRunEnvDef envResource = new RemoteRunEnvDef();
        envResource.runsRemotely = true;
        envResource.cwd = recipeTmpDir.getAbsolutePath();
        EnvironmentStash envStash = this.prepareEnvStash(recipeTmpDir, extraEnv, codeEnvRef.envName);
        envStash.copyToRemoteRunEnvDef(envResource, false, false, false);
        envResource.jobId = executionId;
        RemoteRunsRegistry.get((String)executionId).envResource = envResource;
        logger.infoV("Executing recipe on Docker with config=%s, using image '%s', container '%s'", new Object[]{containerConfig.name, imageId, containerJobId});
        AuthCtx submitter = ((JobAuthCtxService)SpringUtils.getBean(JobAuthCtxService.class)).getAuthCtx();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(recipeTmpDir);
        pb.environment().put("DKU_API_TICKET", this.apiTicketService.getSingleTicket().getSecret());
        pb.command(DockerExecUtils.getDockerRunCommand(submitter, executionType, this.activity.projectKey, this.activity.recipeId, this.activity.recipeId, containerConfig, "--name", containerJobId, "-e", "DKU_API_TICKET"));
        pb.command().addAll(DockerExecUtils.getEnvironmentCommandFlags(containerConfig));
        pb.command().add(imageId);
        pb.command().add(executionId);
        ContainerExecUtils.enrichDockerEnv(containerConfig, pb.environment());
        try {
            this.executeDocker(pb, null, codeEnvRef.envLang.getLanguageInfo(), containerConfig, containerJobId, logFile);
        }
        finally {
            RemoteRunsRegistry.remove(executionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeKubernetesCodeRecipe(CodeEnvModel.UsedCodeEnvRef codeEnvRef, ContainerExecRuntimeConfig containerConfig, File contextPath, File recipeTmpDir, RemoteRunsRegistry.ExecutionType executionType, String definition, String payload, Map<String, String> extraEnv, int parallelism, boolean restartOnFailure, Collection<String> readablePaths) throws Exception {
        KubernetesReplicaSetExecution k8sExecution;
        ComputeResourceUsage cru;
        String executionId;
        block21: {
            AuthCtx authCtx = this.authCtxService.getAuthCtx();
            this.cleanupPreviousReplicaSet(authCtx);
            executionId = KubernetesExecUtils.getNormalizedExecutionId(this.recipe.type + "-" + SecretKeyGenerator.generateSmall());
            String imageId = this.prepareContainerExecution(contextPath, recipeTmpDir, executionId, containerConfig.dockerHost, containerConfig.baseImage, codeEnvRef, executionType, definition, payload, readablePaths);
            imageId = ContainerExecImagesHelper.withRepositoryURL(containerConfig.repositoryURL, imageId);
            logger.infoV("Executing recipe on Kubernetes with config=%s, using image '%s'", new Object[]{containerConfig.name, imageId});
            AuthCtx submitter = ((JobAuthCtxService)SpringUtils.getBean(JobAuthCtxService.class)).getAuthCtx();
            File secretFile = new File(recipeTmpDir, "secret.yaml");
            File replicaSetFile = new File(recipeTmpDir, "replicaset.yaml");
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.directory(recipeTmpDir);
            pb.command(Lists.newArrayList((Object[])KubernetesExecUtils.getKubeCtlCreateCommand(authCtx, this.projectKey, containerConfig, "-f", secretFile.getAbsolutePath(), "-f", replicaSetFile.getAbsolutePath())));
            pb.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(containerConfig));
            RemoteRunEnvDef envResource = new RemoteRunEnvDef();
            envResource.runsRemotely = true;
            envResource.cwd = recipeTmpDir.getAbsolutePath();
            EnvironmentStash envStash = this.prepareEnvStash(recipeTmpDir, extraEnv, codeEnvRef.envName);
            envStash.copyToRemoteRunEnvDef(envResource, false, false, false);
            envResource.jobId = executionId;
            RemoteRunsRegistry.get((String)executionId).envResource = envResource;
            KubernetesExecUtils.LabelsAndAnnotations laa = KubernetesExecUtils.getIdentifiersBasedOnCRUContext(submitter, executionId, containerConfig);
            String secretDesc = KubernetesExecUtils.getTicketSecretConf(executionId, this.apiTicketService.getSingleTicket().getSecret());
            String replicaSetDesc = KubernetesExecUtils.getReplicaSetConfForContinuous(submitter, executionId, this.activity.projectKey, laa, pb.environment(), imageId, containerConfig, parallelism);
            DKUFileUtils.writeFileUTF8((File)secretFile, (String)secretDesc);
            DKUFileUtils.writeFileUTF8((File)replicaSetFile, (String)replicaSetDesc);
            logger.infoV("Final replica set YAML: %s", new Object[]{replicaSetDesc});
            String k8sClusterId = new ClusterSelector().getClusterForProject(this.activity.projectKey, Cluster.ClusterArchitecture.KUBERNETES);
            K8SAPIDeploymentInfra.K8SContainerLimits k8sContainerLimits = containerConfig.kubernetesResources;
            cru = ComputeResourceUsage.forSingleK8SJob((String)k8sClusterId, (String)executionId, (IK8SContainerLimits)k8sContainerLimits).reportStartNoFail();
            File logFile = new File(pb.directory(), "process-out.log");
            FileUtils.touch((File)logFile);
            String replicaSetName = KubernetesExecUtils.getPodName(executionId);
            ReplicaSetInfo runInfo = new ReplicaSetInfo();
            runInfo.containerConfig = containerConfig;
            runInfo.executionId = executionId;
            runInfo.replicaSet = replicaSetName;
            runInfo.secret = KubernetesExecUtils.getTicketSecretName(executionId);
            this.savePersistedRunInfo(runInfo);
            k8sExecution = null;
            try {
                this.executeLocal(pb, null, "kubectl", null, true, logFile);
                k8sExecution = new KubernetesReplicaSetExecution(authCtx, containerConfig, recipeTmpDir, replicaSetName);
                this.addAbortable(k8sExecution);
                HashMap pods = Maps.newHashMap();
                Exception exception = null;
                while (!this.aborted) {
                    PodMonitorThread t;
                    JsonObject podObj;
                    JsonArray podList;
                    Thread.sleep(5000L);
                    ProcessBuilder pollReplicaSetProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(authCtx, this.projectKey, containerConfig, false, "get", "replicasets", "-o", "json", "-l", "dataiku.com/dku-execution-id=" + executionId));
                    pollReplicaSetProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(containerConfig));
                    pollReplicaSetProcessBuilder.directory(recipeTmpDir);
                    RegularProcess pollReplicaSetProcess = new RegularProcess(pollReplicaSetProcessBuilder, recipeTmpDir);
                    pollReplicaSetProcess.start();
                    DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
                    DKUtils.ExecOutputConsumer pollReplicaSetEoc = new DKUtils.ExecOutputConsumer().withOutputConsumer((DKUtils.ExecSubscription)outputCollector).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(logger, Level.WARN));
                    pollReplicaSetEoc.start(pollReplicaSetProcess.getInputStream(), pollReplicaSetProcess.getErrorStream(), null);
                    int rv = pollReplicaSetProcess.waitFor();
                    if (rv != 0) {
                        exception = new Exception("Unable to get status of replicaset " + replicaSetName + " (poll failed)");
                        break;
                    }
                    pollReplicaSetEoc.finish();
                    JsonObject obj = (JsonObject)JSON.parse((InputStream)new ByteArrayInputStream(outputCollector.getCollected()), JsonObject.class);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Replica sets JSON: " + JSON.pretty((Object)obj)));
                    }
                    if (obj == null || obj.isJsonNull() || !obj.has("items") || obj.getAsJsonArray("items").size() == 0) {
                        exception = new Exception("Unable to get status of replica set " + replicaSetName + " (poll empty)");
                        break;
                    }
                    JsonObject replicaSet = obj.getAsJsonArray("items").get(0).getAsJsonObject();
                    JsonObject replicaSetStatus = replicaSet.has("status") ? replicaSet.getAsJsonObject("status") : new JsonObject();
                    logger.info((Object)("Replica set has status=" + JSON.json((Object)replicaSetStatus)));
                    ProcessBuilder pollPodsProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(authCtx, this.projectKey, containerConfig, false, "get", "pods", "-o", "json", "-l", "dataiku.com/dku-execution-id=" + executionId));
                    pollPodsProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(containerConfig));
                    pollPodsProcessBuilder.directory(recipeTmpDir);
                    RegularProcess pollPodsProcess = new RegularProcess(pollPodsProcessBuilder, recipeTmpDir);
                    pollPodsProcess.start();
                    DKUtils.ByteCollectingSubscription podsOutputCollector = new DKUtils.ByteCollectingSubscription();
                    DKUtils.ExecOutputConsumer pollPodsEoc = new DKUtils.ExecOutputConsumer().withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(logger, Level.WARN)).withOutputConsumer((DKUtils.ExecSubscription)podsOutputCollector);
                    pollPodsEoc.start(pollPodsProcess.getInputStream(), pollPodsProcess.getErrorStream(), null);
                    int podsRv = pollPodsProcess.waitFor();
                    if (podsRv != 0) {
                        exception = new Exception("Unable to get pods of replica set " + replicaSetName);
                        break;
                    }
                    pollPodsEoc.finish();
                    obj = (JsonObject)JSON.parse((InputStream)new ByteArrayInputStream(podsOutputCollector.getCollected()), JsonObject.class);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Pods JSON: " + JSON.pretty((Object)obj)));
                    }
                    int totalRestartCount = 0;
                    if (obj.has("items")) {
                        CountMap<String> podStatuses = new CountMap<String>();
                        podList = obj.getAsJsonArray("items");
                        for (JsonElement e : podList) {
                            JsonObject statusObj;
                            podObj = (JsonObject)e;
                            if (!podObj.has("status") || !(statusObj = podObj.getAsJsonObject("status")).has("containerStatuses")) continue;
                            String podStatus = null;
                            if (statusObj.has("phase")) {
                                podStatus = statusObj.get("phase").getAsString();
                            }
                            JsonArray containerStatuses = statusObj.getAsJsonArray("containerStatuses");
                            for (JsonElement containerStatus : containerStatuses) {
                                JsonObject containerStatusObj = containerStatus.getAsJsonObject();
                                if (containerStatusObj.has("state") && containerStatusObj.getAsJsonObject("state").has("waiting") && containerStatusObj.getAsJsonObject("state").getAsJsonObject("waiting").has("reason")) {
                                    String reason;
                                    podStatus = reason = containerStatusObj.getAsJsonObject("state").getAsJsonObject("waiting").get("reason").getAsString();
                                    if ("ErrImagePull".equals(reason) || "CrashLoopBackOff".equals(reason) || "ImagePullBackOff".equals(reason)) {
                                        logger.warn((Object)("Found problematic status : " + JSON.json((Object)containerStatusObj.getAsJsonObject("state").getAsJsonObject("waiting"))));
                                    }
                                }
                                if (!containerStatusObj.has("restartCount")) continue;
                                totalRestartCount += containerStatusObj.getAsJsonPrimitive("restartCount").getAsInt();
                            }
                            if (podStatus == null) continue;
                            podStatuses.inc(podStatus);
                        }
                        logger.info((Object)("Pods statuses : " + JSON.json(podStatuses)));
                        if (!restartOnFailure && totalRestartCount > 0) {
                            logger.info((Object)"Found a failed pod, and job should not restart on failure, exiting");
                            exception = new Exception("One pod failed");
                            break;
                        }
                    }
                    HashSet podIds = Sets.newHashSet();
                    if (obj.has("items")) {
                        podList = obj.getAsJsonArray("items");
                        for (JsonElement e : podList) {
                            podObj = (JsonObject)e;
                            if (!podObj.has("metadata") || !podObj.getAsJsonObject("metadata").has("name")) continue;
                            podIds.add(podObj.getAsJsonObject("metadata").get("name").getAsString());
                        }
                    }
                    logger.info((Object)("Pod list is " + Joiner.on((String)", ").join((Iterable)podIds)));
                    HashSet currentPodIds = Sets.newHashSet(pods.keySet());
                    Sets.SetView deadPods = Sets.difference((Set)currentPodIds, (Set)podIds);
                    Sets.SetView newPods = Sets.difference((Set)podIds, (Set)currentPodIds);
                    for (String pod : deadPods) {
                        logger.info((Object)("Pod " + pod + " died"));
                        t = (PodMonitorThread)pods.remove(pod);
                        t.kill();
                    }
                    for (String pod : newPods) {
                        logger.info((Object)("Pod " + pod + " arrived"));
                        t = new PodMonitorThread(authCtx, containerConfig, recipeTmpDir, pod);
                        t.start();
                        pods.put(pod, t);
                    }
                }
                this.getExecutionResultHandler().throwFromErrorFileOrLogs(recipeTmpDir, codeEnvRef.envLang.getLanguageInfo(), new CodeBasedThingHelper.ExecutionResult(), null);
                if (exception == null) break block21;
                throw exception;
            }
            catch (Throwable throwable) {
                RemoteRunsRegistry.remove(executionId);
                cru.reportCompleteNoFail();
                if (k8sExecution != null) {
                    this.removeAbortable(k8sExecution);
                    k8sExecution.run();
                }
                throw throwable;
            }
        }
        RemoteRunsRegistry.remove(executionId);
        cru.reportCompleteNoFail();
        if (k8sExecution != null) {
            this.removeAbortable(k8sExecution);
            k8sExecution.run();
        }
    }

    private void cleanupPreviousReplicaSet(AuthCtx authCtx) throws IOException {
        ReplicaSetInfo info = this.getPersistedRunInfo(ReplicaSetInfo.class);
        if (info != null && StringUtils.isNotBlank((String)info.executionId)) {
            logger.info((Object)("Found traces of previous runs, attempting cleanup of " + info.executionId));
            try (AutoDelete tmpDir = FlowJobUtils.getTmpFolder("continuous-activity-cleanup", "k8s");){
                KubectlHelper.executeKubectlToVoid(info.containerConfig, "delete", "replicaSet", info.replicaSet, "--ignore-not-found");
                KubectlHelper.executeKubectlToVoid(info.containerConfig, "delete", "secret", info.secret, "--ignore-not-found");
            }
            catch (Exception e) {
                logger.error((Object)("Failed to clean kubernetes replica set" + info.replicaSet), (Throwable)e);
            }
        }
    }

    private String prepareContainerExecution(File contextPath, File recipeTmpDir, String executionId, String dockerHost, String baseImageRef, CodeEnvModel.UsedCodeEnvRef codeEnvRef, RemoteRunsRegistry.ExecutionType executionType, String definition, String payload, Collection<String> readablePaths) throws IOException {
        String envVersion = ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).getEnvVersionToUseForContainerImageLookup(codeEnvRef.envName, codeEnvRef.envLang, this.projectKey);
        CodeEnvModel.EnvFullRef env = new CodeEnvModel.EnvFullRef(codeEnvRef.envLang, codeEnvRef.envName, envVersion);
        RemoteRunsRegistry.add(executionId, this.apiTicketService.getSingleTicket().getOriginalUser(), this.projectKey, contextPath.getPath(), recipeTmpDir.getPath(), executionType, definition, payload, readablePaths, null, Collections.singletonList(env));
        return ContainerExecImagesHelper.getImageTagToUse(dockerHost, baseImageRef, ContainerExecUtils.BaseImageType.EXEC, codeEnvRef.envLang, codeEnvRef.envName, envVersion);
    }

    public void savePersistedRunInfo(Object data) throws IOException {
        File activityDir = ApplicationConfigurator.getFile((String[])new String[]{"streaming-logs", this.activity.projectKey, this.activity.recipeId});
        DKUFileUtils.mkdirs((File)activityDir);
        DKUFileUtils.writeFileUTF8((File)new File(activityDir, "run-info.json"), (String)JSON.pretty((Object)data));
    }

    public void clearPersistedRunInfo() throws IOException {
        File activityDir = ApplicationConfigurator.getFile((String[])new String[]{"streaming-logs", this.activity.projectKey, this.activity.recipeId});
        File runInfoFile = new File(activityDir, "run-info.json");
        if (runInfoFile.exists() && runInfoFile.isFile() && runInfoFile.canRead()) {
            logger.info((Object)"Remove run-info.json");
            if (!runInfoFile.delete()) {
                logger.warn((Object)"Could not remove run-info.json");
            }
        } else {
            logger.info((Object)"No run-info.json to remove");
        }
    }

    public <T> T getPersistedRunInfo(Class<? extends T> clazz) throws IOException {
        File activityDir = ApplicationConfigurator.getFile((String[])new String[]{"streaming-logs", this.activity.projectKey, this.activity.recipeId});
        File runInfoFile = new File(activityDir, "run-info.json");
        if (runInfoFile.exists() && runInfoFile.isFile() && runInfoFile.canRead()) {
            return (T)JSON.parse((String)DKUFileUtils.readFileToStringUTF8((File)runInfoFile), clazz);
        }
        return null;
    }

    public static class ContinuousLocalProcessExecution
    extends ContinuousProcessExecution {
        private IsolableProcess runningProcess;
        private volatile boolean done = false;

        public ContinuousLocalProcessExecution(AuthCtx authCtx, String projectKey) {
            super(authCtx, projectKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CodeBasedThingHelper.ExecutionResult executeNoFail(ProcessBuilder builder, Object optionalInput, File logOutput, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, boolean forceDisableImpersonation) throws Exception {
            try {
                CodeBasedThingHelper.ExecutionResult executionResult = super.executeNoFail(builder, optionalInput, logOutput, cgrouppableProcessType, forceDisableImpersonation);
                return executionResult;
            }
            finally {
                this.done = true;
            }
        }

        @Override
        protected void processStarted(IsolableProcess p) {
            this.runningProcess = p;
        }

        @Override
        public void notifyBeforeAborting() {
            logger.info((Object)("Aborting continuous runningProcess=" + String.valueOf(this.runningProcess)));
            if (this.runningProcess != null) {
                try {
                    this.runningProcess.niceKill();
                    long start = System.currentTimeMillis();
                    while (!this.done && System.currentTimeMillis() - start < 10000L) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            logger.warn((Object)"Waiting for abort interrupted");
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)"Unable to send SIGINT to running process", (Throwable)e);
                }
            }
        }
    }

    public class AbortableContinuousProcessExecution
    implements Runnable,
    AutoCloseable {
        private final ContinuousProcessExecution p;

        public AbortableContinuousProcessExecution(ContinuousProcessExecution p) {
            AbstractCodeBasedContinuousActivityRunner.this.addAbortable(this);
            this.p = p;
        }

        @Override
        public void run() {
            this.p.notifyBeforeAborting();
        }

        @Override
        public void close() throws Exception {
            AbstractCodeBasedContinuousActivityRunner.this.removeAbortable(this);
        }
    }

    public static abstract class ContinuousProcessExecution
    extends JobProcessExecution {
        public ContinuousProcessExecution(AuthCtx authCtx, String projectKey) {
            super(authCtx, projectKey);
        }

        public abstract void notifyBeforeAborting();

        @Override
        protected JobProcessExecution.LineSubscriptionProvider getFileLoggingSubscription(File logFile) throws FileNotFoundException {
            final DKUtils.RotatingLoggingSubscription writer = new DKUtils.RotatingLoggingSubscription(logFile.getParentFile(), logFile.getName(), 5, 0xA00000L);
            return new JobProcessExecution.LineSubscriptionProvider(){

                @Override
                public void close() throws Exception {
                    writer.close();
                }

                @Override
                public DKUtils.LineSubscription get() {
                    return writer;
                }
            };
        }
    }

    public static class ContinuousDockerProcessExecution
    extends ContinuousProcessExecution {
        protected final ContainerExecRuntimeConfig containerConfig;
        protected final String containerJobId;
        private IsolableProcess runningProcess;
        private volatile boolean done = false;

        public ContinuousDockerProcessExecution(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, String containerJobId) {
            super(authCtx, projectKey);
            this.containerConfig = containerConfig;
            this.containerJobId = containerJobId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CodeBasedThingHelper.ExecutionResult executeNoFail(ProcessBuilder builder, Object optionalInput, File logOutput, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, boolean forceDisableImpersonation) throws Exception {
            try {
                CodeBasedThingHelper.ExecutionResult executionResult = super.executeNoFail(builder, optionalInput, logOutput, cgrouppableProcessType, forceDisableImpersonation);
                return executionResult;
            }
            finally {
                this.done = true;
            }
        }

        @Override
        protected void processStarted(IsolableProcess p) {
            this.runningProcess = p;
        }

        @Override
        public void notifyBeforeAborting() {
            logger.info((Object)("Aborting continuous runningProcess=" + String.valueOf(this.runningProcess)));
            if (this.runningProcess != null && !this.done) {
                logger.warn((Object)("Abort received, will kill Docker container " + this.containerJobId));
                HashMap<String, String> env = new HashMap<String, String>(1);
                ContainerExecUtils.enrichDockerEnv(this.containerConfig, env);
                ContainerExecUtils.killDockerContainer(this.containerJobId, true, env, logger);
            }
        }
    }

    private static class ReplicaSetInfo {
        public String executionId;
        public ContainerExecRuntimeConfig containerConfig;
        public String replicaSet;
        public String secret;

        private ReplicaSetInfo() {
        }
    }

    public class KubernetesReplicaSetExecution
    implements Runnable {
        private final AuthCtx authCtx;
        private final ContainerExecRuntimeConfig containerConfig;
        private final File recipeTmpDir;
        private final String replicaSetName;
        private boolean deleteK8SJob = true;
        private volatile boolean ran = false;

        public KubernetesReplicaSetExecution(AuthCtx authCtx, ContainerExecRuntimeConfig containerConfig, File recipeTmpDir, String replicaSetName) {
            this.authCtx = authCtx;
            this.containerConfig = containerConfig;
            this.recipeTmpDir = recipeTmpDir;
            this.replicaSetName = replicaSetName;
        }

        public synchronized void dontDelete() {
            this.deleteK8SJob = false;
        }

        public synchronized boolean getDelete() {
            return this.deleteK8SJob;
        }

        @Override
        public void run() {
            if (this.getDelete() && !this.ran) {
                this.ran = true;
                logger.info((Object)("Cleaning Kubernetes replica set " + this.replicaSetName));
                try {
                    ProcessBuilder pb = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, AbstractCodeBasedContinuousActivityRunner.this.projectKey, this.containerConfig, false, "delete", "-f", "secret.yaml", "-f", "replicaset.yaml"));
                    pb.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
                    pb.directory(this.recipeTmpDir);
                    CodeBasedThingHelper.ExecutionResult cleanResult = new ContinuousLocalProcessExecution(this.authCtx, AbstractCodeBasedContinuousActivityRunner.this.projectKey).executeNoFail(pb, null, new File(this.recipeTmpDir, "remove-out.log"), null, true);
                    if (cleanResult.returnValue != 0) {
                        logger.error((Object)"Could not clean kubernetes job");
                    }
                    AbstractCodeBasedContinuousActivityRunner.this.clearPersistedRunInfo();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to clean kubernetes replica set" + this.replicaSetName), (Throwable)e);
                }
            }
        }
    }

    private class PodMonitorThread
    extends Thread {
        private final ContainerExecRuntimeConfig containerConfig;
        private final AuthCtx authCtx;
        private final String podId;
        private final File recipeTmpDir;
        private volatile boolean keepLooping = true;

        public PodMonitorThread(AuthCtx authCtx, ContainerExecRuntimeConfig containerConfig, File recipeTmpDir, String podId) {
            this.authCtx = authCtx;
            this.containerConfig = containerConfig;
            this.recipeTmpDir = recipeTmpDir;
            this.podId = podId;
        }

        public void kill() {
            this.keepLooping = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.info((Object)("Start retrieving logs for pod " + this.podId));
            Runnable abortHook = () -> {
                this.keepLooping = false;
                this.interrupt();
            };
            AbstractCodeBasedContinuousActivityRunner.this.addAbortable(abortHook);
            try {
                Long lastLogEnd = null;
                while (this.keepLooping && !AbstractCodeBasedContinuousActivityRunner.this.aborted) {
                    try {
                        ArrayList args = Lists.newArrayList((Object[])new String[]{"logs", "-f", "pods/" + this.podId, "-c", "c"});
                        if (lastLogEnd != null) {
                            long sinceLast = Math.max(0L, System.currentTimeMillis() - lastLogEnd) + 10L;
                            logger.info((Object)("Fetch logs since " + sinceLast + " ms"));
                            args.add("--since=" + sinceLast + "ms");
                        }
                        ProcessBuilder logProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, AbstractCodeBasedContinuousActivityRunner.this.projectKey, this.containerConfig, false, args.toArray(new String[0])));
                        logProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
                        logProcessBuilder.directory(this.recipeTmpDir);
                        RegularProcess logProcess = new RegularProcess(logProcessBuilder, this.recipeTmpDir);
                        logProcess.start();
                        DKUtils.ExecOutputConsumer logProcessEoc = new DKUtils.ExecOutputConsumer().withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(logger, Level.ERROR)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(logger, Level.INFO));
                        logProcessEoc.start(logProcess.getInputStream(), logProcess.getErrorStream(), null);
                        int logReturnValue = logProcess.waitFor();
                        if (logReturnValue != 0) {
                            logger.warn((Object)("Unable to get logs of pod " + this.podId));
                        }
                        logProcessEoc.finish();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Pod log retrieval failed", (Throwable)e);
                    }
                    lastLogEnd = System.currentTimeMillis();
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.warn((Object)"Interrupted in log forwarder loop", (Throwable)e);
                    }
                }
            }
            finally {
                AbstractCodeBasedContinuousActivityRunner.this.removeAbortable(abortHook);
            }
        }
    }

    public static class ContinuousKubernetesProcessExecution
    extends ContinuousProcessExecution {
        protected final ContainerExecRuntimeConfig containerConfig;
        protected final String containerJobId;
        private IsolableProcess runningProcess;
        private volatile boolean done = false;

        public ContinuousKubernetesProcessExecution(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, String containerJobId) {
            super(authCtx, projectKey);
            this.containerConfig = containerConfig;
            this.containerJobId = containerJobId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CodeBasedThingHelper.ExecutionResult executeNoFail(ProcessBuilder builder, Object optionalInput, File logOutput, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, boolean forceDisableImpersonation) throws Exception {
            try {
                CodeBasedThingHelper.ExecutionResult executionResult = super.executeNoFail(builder, optionalInput, logOutput, cgrouppableProcessType, forceDisableImpersonation);
                return executionResult;
            }
            finally {
                this.done = true;
            }
        }

        @Override
        protected void processStarted(IsolableProcess p) {
            this.runningProcess = p;
        }

        @Override
        public void notifyBeforeAborting() {
            logger.info((Object)("Aborting continuous runningProcess=" + String.valueOf(this.runningProcess)));
            if (this.runningProcess != null && !this.done) {
                logger.warn((Object)("Abort received, will kill Kubernetes container " + this.containerJobId));
                try {
                    KubernetesExecUtils.delete(this.authCtx, this.projectKey, this.containerConfig, true, this.containerJobId.split("\n"));
                }
                catch (IOException e) {
                    logger.error((Object)"Could not stop Kubernetes container", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Interrupted while stopping Kubernetes container", (Throwable)e);
                }
            }
        }
    }
}

