/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.sync;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeParams;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.SISORecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.google.gson.JsonObject;
import java.io.IOException;

public class SyncRecipeCreator
extends SISORecipeCreator {
    public SyncRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        ManagedDatasetsHelper.copySchema(this.authCtx, this.getInputDataset(recipe).getSchema(), outputDataset);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, StreamingEndpoint outputStreamingEndpoint) throws Exception {
        outputStreamingEndpoint.schema = this.getInputDataset(recipe).getSchema();
    }

    @Override
    protected SyncRecipeParams makeInitialParams(SerializedRecipe recipe, JsonObject creationData) throws IOException {
        SyncRecipeParams params = new SyncRecipeParams();
        params.schemaMode = creationData.has("schemaMode") && SyncRecipeParams.SchemaMode.FREE_SCHEMA_NAME_BASED.name().equals(creationData.get("schemaMode").getAsString()) ? SyncRecipeParams.SchemaMode.FREE_SCHEMA_NAME_BASED : SyncRecipeParams.SchemaMode.STRICT_SYNC;
        RecipeCreationUtils.setupAllEnginesCreationParams(this.authCtx, recipe.projectKey, params.engineParams);
        RecipeCreationUtils.switchToHiveserverForHiveDataset(this.getInputDataset(recipe), params.engineParams);
        params.engineParams.setRedShiftParams(true);
        return params;
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, Dataset outputDataset, JsonObject data) {
        return "";
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, StreamingEndpoint outputStreamingEndpoint, JsonObject data) {
        return "";
    }
}

