/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.io.AbstractImpersonableSecretProtectedPythonKernel;
import com.dataiku.dip.io.BasicKernelLink;
import com.dataiku.dip.scheduler.runnables.AbstractPythonDSSRunnable;
import com.dataiku.dip.scheduler.runnables.ImpersonableInlinePythonDSSRunnableKernel;
import com.dataiku.dip.scheduler.runnables.LoadedInlinePythonRunnable;
import com.dataiku.dip.scheduler.runnables.PythonRunnableDesc;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;

public class InlinePythonDSSRunnable
extends AbstractPythonDSSRunnable {
    private final String code;
    private final CodeEnvSelection envSelection;

    public InlinePythonDSSRunnable(AuthCtx authCtx, String projectKey, LoadedInlinePythonRunnable loaded, CodeEnvSelection envSelection, String code) {
        super(authCtx, projectKey, loaded);
        this.code = code;
        this.envSelection = envSelection;
    }

    @Override
    protected String getCode() {
        return this.code;
    }

    @Override
    protected AbstractImpersonableSecretProtectedPythonKernel<BasicKernelLink> getKernel(BasicKernelLink link, APITicketService.Ticket ticket, File tmpDir) throws IOException {
        String envName = new CodeEnvSelector().selectForPythonRecipe(this.projectKey, this.envSelection);
        return new ImpersonableInlinePythonDSSRunnableKernel(link, GeneralSettingsDAO.CGrouppableProcessType.PYTHON_MACRO, ticket, tmpDir, ((PythonRunnableDesc)this.loaded.desc).impersonate, this.projectKey, this.authCtx, envName);
    }

    @Override
    protected PluginSettingsResolver.ResolvedSettings getResolvedSettings() {
        return new PluginSettingsResolver.ResolvedSettings(new JsonObject(), new JsonObject());
    }
}

