/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.scheduler.runnables.DSSRunnableResult;
import com.dataiku.dip.scheduler.runnables.InlinePythonDSSRunnable;
import com.dataiku.dip.scheduler.runnables.LoadedInlinePythonRunnable;
import com.dataiku.dip.scheduler.runnables.PythonRunnableDesc;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.utils.SmartLogTail;
import java.io.File;
import javax.annotation.Nullable;

public class InlinePythonDSSRunnableThread
extends SimpleFutureThread<DSSRunnableResult> {
    private final File contextDir;
    private final String projectKey;
    private final LoadedInlinePythonRunnable loaded;
    private final String code;
    private final CodeEnvSelection envSelection;
    private final APITicketService apiTicketService;
    @Nullable
    private InlinePythonDSSRunnable runnable;

    public InlinePythonDSSRunnableThread(AuthCtx authCtx, String code, PythonRunnableDesc desc, CodeEnvSelection envSelection, String projectKey, File contextDir, APITicketService apiTicketService) {
        super(authCtx);
        this.code = code;
        this.envSelection = envSelection;
        this.loaded = new LoadedInlinePythonRunnable(desc);
        this.projectKey = projectKey;
        this.contextDir = contextDir;
        this.apiTicketService = apiTicketService;
    }

    @Override
    protected DSSRunnableResult compute() throws Exception {
        final APITicketService.Ticket ticket = this.apiTicketService.createTicket((AuthCtx)this.owner, "dss_macro:inline", (Object)this);
        this.apiTicketService.registerFutureUsingTicket(ticket, (FutureThreadBase)this);
        try {
            DSSRunnableResult dSSRunnableResult;
            block9: {
                FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InlinePythonDSSRunnableThread.this.apiTicketService.abortFutureUsingTicket(ticket);
                    }
                });
                try {
                    this.runnable = new InlinePythonDSSRunnable(this.owner, this.projectKey, this.loaded, this.envSelection, this.code);
                    dSSRunnableResult = this.runnable.run(this.contextDir, ticket);
                    if (aborter == null) break block9;
                }
                catch (Throwable throwable) {
                    if (aborter != null) {
                        try {
                            aborter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                aborter.close();
            }
            return dSSRunnableResult;
        }
        finally {
            this.apiTicketService.deregisterFutureUsingTicket(ticket, (FutureThreadBase)this);
            this.apiTicketService.expireTicket(ticket);
        }
    }

    public SmartLogTail getLog() {
        return this.runnable == null ? null : this.runnable.getLogTail();
    }

    public FuturePayload getPayload() {
        FuturePayload fp = new FuturePayload();
        fp.displayName = "Running inline Python";
        return fp;
    }
}

