/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.scenarios.testing;

import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.StepBasedScenarioRunner;
import com.dataiku.dip.scheduler.scenarios.testing.JunitXmlReport;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.api.client.util.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class TestScenarioRunReportGenerator {
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenarios.testing.TestScenarioRunReportGenerator");

    private TestScenarioRunReportGenerator() {
    }

    public static JunitXmlReport.TestSuite buildScenarioRunTestSuite(ScenarioRun scenarioRun, List<StepRun> stepRuns) {
        TestScenarioRunReportGenerator.assertValidInputs(scenarioRun);
        return TestScenarioRunReportGenerator.buildTestSuite(scenarioRun, stepRuns);
    }

    @VisibleForTesting
    static JunitXmlReport.TestSuite buildTestSuite(ScenarioRun scenarioRun, List<StepRun> stepRuns) {
        String scenarioName = scenarioRun.getScenario().getName();
        logger.infoV("Building JUnitXML report for scenario run %s of scenario %s", new Object[]{scenarioRun.getRunId(), scenarioName});
        List sortedStepRuns = stepRuns.stream().sorted(Comparator.comparingLong(StepRun::getStart)).collect(Collectors.toList());
        logger.infoV("Found %d test steps in scenario run %s of scenario %s", new Object[]{sortedStepRuns.size(), scenarioRun.getRunId(), scenarioName});
        int nFailures = 0;
        int nErrors = 0;
        int nSkipped = 0;
        ArrayList testCases = Lists.newArrayList();
        for (StepRun stepRun : sortedStepRuns) {
            ReportItem result = stepRun.getResult();
            if (result == null) {
                ++nSkipped;
                testCases.add(TestScenarioRunReportGenerator.buildSkippedTestCase(stepRun));
                continue;
            }
            switch (result.getOutcome()) {
                case FAILED: {
                    ++nFailures;
                    break;
                }
                case ABORTED: {
                    ++nErrors;
                    break;
                }
            }
            testCases.add(TestScenarioRunReportGenerator.buildTestCase(stepRun));
        }
        logger.infoV("Found %d failures and %d errors test steps in scenario run %s of scenario %s", new Object[]{nFailures, nErrors, scenarioRun.getRunId(), scenarioName});
        return new JunitXmlReport.TestSuite(scenarioName, sortedStepRuns.size(), nFailures, nErrors, nSkipped, (double)(scenarioRun.getEnd() - scenarioRun.getStart()) / 1000.0, testCases);
    }

    @VisibleForTesting
    static JunitXmlReport.TestCase buildSkippedTestCase(StepRun stepRun) {
        return new JunitXmlReport.TestCase(stepRun.getStep().getName(), 0.0, null);
    }

    @VisibleForTesting
    static JunitXmlReport.TestCase buildTestCase(StepRun stepRun) {
        WarningsContext.SerializedThrowable thrown = stepRun.getResult().getThrown();
        String message = thrown != null ? thrown.getMessage() : null;
        String stack = thrown != null ? thrown.getStack() : null;
        JunitXmlReport.Failure failure = null;
        switch (stepRun.getResult().getOutcome()) {
            case FAILED: {
                failure = new JunitXmlReport.Failure(message, "Failure", stack);
                break;
            }
            case ABORTED: {
                failure = new JunitXmlReport.Failure(message, "Error", stack);
                break;
            }
        }
        return new JunitXmlReport.TestCase(stepRun.getStep().getName(), (double)(stepRun.getEnd() - stepRun.getStart()) / 1000.0, failure);
    }

    public static void writeReportToFile(JunitXmlReport.TestSuites testSuites, File path) throws IOException {
        logger.infoV("Writing JUnitXML report to file %s", new Object[]{path});
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        xmlMapper.writeValue(path, (Object)testSuites);
    }

    private static void assertValidInputs(ScenarioRun scenarioRun) {
        Scenario scenario = scenarioRun.getScenario();
        if (!StepBasedScenarioRunner.META.getType().equals(scenario.getType())) {
            throw ErrorContext.iaef((String)"Scenario %s is not a step-based scenario. Report generation is only supported for step-based scenarios.", (Object)scenario.getName(), (Object[])new Object[0]);
        }
        if (!scenarioRun.isMarkedAsTest()) {
            throw ErrorContext.iaef((String)"Scenario %s was not marked as a test scenario during run %s", (Object)scenario.getName(), (Object[])new Object[]{scenarioRun.getRunId()});
        }
    }
}

