/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepParamsWithComputables;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.datasets.TestSchemaConsistencyFutureThread;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class ReloadSchemaStepRunner
implements StepRunner {
    private final Scenario scenario;
    private final ReloadSchemaStepParams params;
    @Autowired
    private FutureService futureService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return ReloadSchemaStepParams.class;
        }

        @Override
        public String getType() {
            return "reload_schema";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new ReloadSchemaStepRunner(scenario, step.getParamsAs(ReloadSchemaStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            ReloadSchemaStepParams stpeParams = step.getParamsAs(ReloadSchemaStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("Reload Schema");
            if (stpeParams != null) {
                for (FlowComputableSpecification built : stpeParams.getComputablesSpec()) {
                    sb.append(" ");
                    sb.append(built.getItemName());
                }
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            ReloadSchemaStepParams stpeParams = step.getParamsAs(ReloadSchemaStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("reload_schema");
            if (stpeParams != null) {
                sb.append("_");
                for (FlowComputableSpecification built : stpeParams.getComputablesSpec()) {
                    sb.append("_");
                    sb.append(built.getPartitionInvariantId());
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };

    ReloadSchemaStepRunner(Scenario scenario, ReloadSchemaStepParams params) {
        SpringUtils.getInstance().autowire((Object)this);
        this.scenario = scenario;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        String scenarioProjectKey = this.scenario.getProjectKey();
        DSSAuthCtx runAsUser = stepRun.getScenarioRun().getRunAsUser();
        boolean anyFailure = false;
        for (FlowComputableSpecification flowComputableSpecification : this.params.getComputablesSpec()) {
            if (flowComputableSpecification.type != FlowComputable.FCType.DATASET) continue;
            ReportTargetItem target = flowComputableSpecification.getTargetItem(scenarioProjectKey, null);
            ReportItem.ReloadSchema reportItem = (ReportItem.ReloadSchema)new ReportItem.ReloadSchema(target).withStart(System.currentTimeMillis()).withLogTail(new SmartLogTail());
            try {
                SerializedDataset dataset;
                try (Transaction ignored = this.transactionService.beginRead();){
                    dataset = (SerializedDataset)this.datasetsDAO.getMandatory(scenarioProjectKey, flowComputableSpecification.itemId);
                }
                Schema initialSchema = dataset.getSchema();
                SchemaDetection.SchemaDetectionResult detectionResult = this.reloadDatasetSchema(runAsUser, scenarioProjectKey, dataset);
                Schema newSchema = detectionResult != null ? detectionResult.detectedSchema : null;
                reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
                if (newSchema == null) continue;
                SchemaDiff diff = this.diffSchemas(initialSchema, newSchema);
                stepRun.payload = diff;
                stepRun.getScenarioRun().withStepRunOutput(stepRun, diff);
                reportItem.withChanges(diff.added.size() + diff.modified.size(), diff.deleted.size() + diff.modified.size());
            }
            catch (Exception e) {
                anyFailure = true;
                reportItem.withThrown(e).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            }
            finally {
                this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(scenarioProjectKey, flowComputableSpecification.itemId), null, null, stepRun.getScenarioRun(), stepRun, reportItem);
            }
        }
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
        if (anyFailure) {
            stepReportItem.withOutcome(ReportItem.Outcome.FAILED);
        }
    }

    private SchemaDetection.SchemaDetectionResult reloadDatasetSchema(AuthCtx user, String scenarioProjectKey, SerializedDataset dataset) throws Exception {
        DatasetTestHandler.SchemaConsistencyResult response = (DatasetTestHandler.SchemaConsistencyResult)this.futureService.runAndWait(new TestSchemaConsistencyFutureThread(user, Dataset.fromSerialized(dataset)), (TypeToken)new TypeToken<FutureResponse<DatasetTestHandler.SchemaConsistencyResult>>(){});
        if (!response.empty && response.result.warningLevel != null) {
            try (RWTransaction rwTransaction = this.transactionService.beginWriteAsLoggedInUser(user);){
                dataset.setSchema(response.result.detectedSchema);
                this.datasetSaveService.save(scenarioProjectKey, dataset.name, dataset, user);
                rwTransaction.commit("Update schema of " + dataset.name);
            }
            return response.result;
        }
        return null;
    }

    private SchemaDiff diffSchemas(Schema before, Schema after) {
        int i;
        SchemaDiff diff = new SchemaDiff();
        HashMap beforePositions = Maps.newHashMap();
        HashMap afterPositions = Maps.newHashMap();
        for (i = 0; i < before.columns.size(); ++i) {
            beforePositions.put(((SchemaColumn)before.columns.get(i)).getName(), i);
        }
        for (i = 0; i < after.columns.size(); ++i) {
            afterPositions.put(((SchemaColumn)after.columns.get(i)).getName(), i);
        }
        for (SchemaColumn afterColumn : after.columns) {
            String name = afterColumn.getName();
            Integer beforePosition = (Integer)beforePositions.get(name);
            int afterPosition = (Integer)afterPositions.get(name);
            if (beforePosition == null) {
                diff.added.add(afterColumn);
            } else {
                SchemaColumn beforeColumn = (SchemaColumn)before.columns.get(beforePosition);
                if (afterColumn.getType() != beforeColumn.getType()) {
                    SchemaColumnDiff columnDiff = new SchemaColumnDiff();
                    columnDiff.before = beforeColumn;
                    columnDiff.after = afterColumn;
                    diff.modified.add(columnDiff);
                }
            }
            if (beforePosition == null || beforePosition == afterPosition) continue;
            SchemaColumnMove columnMove = new SchemaColumnMove();
            columnMove.name = name;
            columnMove.before = beforePosition;
            columnMove.after = afterPosition;
            diff.moved.add(columnMove);
        }
        for (SchemaColumn beforeColumn : before.columns) {
            if (afterPositions.containsKey(beforeColumn.getName())) continue;
            diff.deleted.add(beforeColumn);
        }
        return diff;
    }

    public static class ReloadSchemaStepParams
    extends NonFatalStepParams
    implements StepParams,
    StepParamsWithComputables {
        public Set<FlowComputableSpecification> items = new HashSet<FlowComputableSpecification>();

        @Override
        public Collection<FlowComputableSpecification> getComputablesSpec() {
            return this.items;
        }
    }

    public static class SchemaDiff {
        public List<SchemaColumn> added = Lists.newArrayList();
        public List<SchemaColumn> deleted = Lists.newArrayList();
        public List<SchemaColumnDiff> modified = Lists.newArrayList();
        public List<SchemaColumnMove> moved = Lists.newArrayList();
    }

    public static class SchemaColumnDiff {
        public SchemaColumn before;
        public SchemaColumn after;
    }

    public static class SchemaColumnMove {
        public int before;
        public int after;
        public String name;
    }
}

