/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.custom.UnavailablePluginItemInfo;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.utils.DKULogger;
import java.util.List;

public interface StepMeta {
    public String getType();

    public Class<? extends StepParams> paramsClass();

    public StepRunner buildRunner(Scenario var1, Step var2);

    public String buildName(Step var1);

    public String buildId(Step var1);

    default public void prepareForSave(Step step, PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings security) {
    }

    public UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario var1, Step var2, PluginUsagesInspector var3);

    public static class UnavailableStepInfo
    extends UnavailablePluginItemInfo {
        public String stepId;

        public UnavailableStepInfo(Step step, UnavailablePluginItemInfo itemInfo) {
            super(itemInfo.pluginId, itemInfo.objectType, itemInfo.elementId);
            this.stepId = step.id;
        }

        public static UnavailableStepInfo checkFlowComputableSpecs(Scenario scenario, Step step, PluginUsagesInspector pluginUsagesInspector, List<FlowComputableSpecification> flowSpecs, DKULogger logger) {
            try {
                return pluginUsagesInspector.checkFlowComputableSpecs(scenario, step, flowSpecs);
            }
            catch (UnavailableDSSObjectException ue) {
                logger.error((Object)"Unavailable DSS object", (Throwable)((Object)ue));
                return ue.toUnavailableStepInfo(step);
            }
            catch (Exception e) {
                logger.error((Object)("Error while checking if step " + step.id + " is runnable"), (Throwable)e);
                return null;
            }
        }
    }
}

