/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.triggers;

import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.scheduler.triggers.TriggerMeta;
import com.dataiku.dip.scheduler.triggers.TriggerParams;
import com.dataiku.dip.scheduler.triggers.TriggerRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class FollowScenarioRunTriggerRunner
implements TriggerRunner {
    public static final TriggerMeta META = new TriggerMeta(){

        @Override
        public Class<? extends TriggerParams> paramsClass() {
            return FollowScenarioRunTriggerParams.class;
        }

        @Override
        public String getType() {
            return "follow_scenariorun";
        }

        @Override
        public TriggerRunner buildRunner(Scenario scenario, Trigger trigger) {
            return new FollowScenarioRunTriggerRunner(scenario, trigger, trigger.getParamsAs(FollowScenarioRunTriggerParams.class));
        }

        @Override
        public boolean delayIfScenarioAlreadyRuns() {
            return true;
        }

        @Override
        public String getDigest(Trigger trigger) {
            FollowScenarioRunTriggerParams triggerParams = trigger.getParamsAs(FollowScenarioRunTriggerParams.class);
            String projectPart = StringUtils.isNotBlank((String)triggerParams.getProjectKey()) ? " in " + triggerParams.getProjectKey() : "";
            return "When the scenario " + triggerParams.getScenarioId() + projectPart + " completes";
        }

        @Override
        public DateTime getExpectedNextRun(Trigger trigger, String stateString) {
            return null;
        }

        @Override
        public int getForcedTriggerLoopDelay(Trigger trigger, String currentState, boolean loopStarting) {
            if (loopStarting) {
                return 1;
            }
            return trigger.getDelay();
        }
    };
    @Autowired
    private ScenariosDAO scenariosDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    private final FollowScenarioRunTriggerParams params;
    private final Trigger trigger;
    private final Scenario scenario;
    private static Logger logger = Logger.getLogger((String)"dip.trigger.follow_scenario");

    public FollowScenarioRunTriggerRunner(Scenario scenario, Trigger trigger, FollowScenarioRunTriggerParams params) {
        this.trigger = trigger;
        this.params = params;
        this.scenario = scenario;
    }

    @Override
    public TriggerFire run(ScenariosTriggerService triggerService, AuthCtx authCtx) throws Exception {
        Scenario scenarioToFollow;
        String otherProjectKey = this.params.getProjectKey();
        if (StringUtils.isBlank((String)otherProjectKey)) {
            otherProjectKey = this.scenario.getProjectKey();
        }
        try (Transaction t = this.transactionService.beginRead();){
            scenarioToFollow = (Scenario)this.scenariosDAO.getMandatory(otherProjectKey, this.params.getScenarioId());
        }
        try {
            boolean stateChanged;
            boolean passesOutcomeFilter;
            String stateString = triggerService.getTriggerState(this.scenario, this.trigger);
            FollowScenarioRunTriggerState lastState = stateString == null ? null : (FollowScenarioRunTriggerState)JSON.parse((String)stateString, FollowScenarioRunTriggerState.class);
            String newParamsHash = DKUtils.md5Base64((String)JSON.json((Object)this.params));
            boolean paramsChanged = lastState == null || !lastState.paramsHash.equals(newParamsHash);
            String scenarioRunId = this.jobsDatabaseService.getLastRunId(scenarioToFollow.getProjectKey(), scenarioToFollow.getId());
            if (scenarioRunId == null) {
                logger.info((Object)"No run exist for the followed scenario");
                if (paramsChanged) {
                    this.createInitialState(triggerService, newParamsHash, 0L);
                }
                return null;
            }
            ScenarioRun scenarioRun = this.jobsDatabaseService.getSimpleScenarioRun(scenarioToFollow.getProjectKey(), scenarioToFollow.getId(), scenarioRunId);
            if (scenarioRun == null) {
                logger.warn((Object)("Unable to retrieve run for max(scenario_run_id)=" + scenarioRunId));
                if (paramsChanged) {
                    this.createInitialState(triggerService, newParamsHash, 0L);
                }
                return null;
            }
            if (scenarioRun.getResult() == null || scenarioRun.getResult().getOutcome() == null) {
                logger.info((Object)"Followed scenario still running");
                if (paramsChanged) {
                    this.createInitialState(triggerService, newParamsHash, scenarioRun.getStart());
                }
                return null;
            }
            boolean bl = passesOutcomeFilter = this.params.getOutcomeFilter() == null || scenarioRun.getResult().getOutcome() == this.params.getOutcomeFilter();
            if (!passesOutcomeFilter) {
                logger.info((Object)"Last run of followed scenario had the wrong outcome");
            }
            FollowScenarioRunTriggerState state = new FollowScenarioRunTriggerState(newParamsHash, scenarioRun.getStart());
            boolean bl2 = stateChanged = !paramsChanged && lastState.lastStart != state.lastStart && passesOutcomeFilter;
            if (paramsChanged) {
                TriggerFire triggerFire = new TriggerFire().withProjectKey(this.scenario.getProjectKey()).withScenarioId(this.scenario.getId()).withTrigger(this.trigger);
                triggerFire = triggerFire.withTriggerState(JSON.json((Object)state));
                triggerService.recordState(triggerFire);
                return null;
            }
            if (stateChanged) {
                TriggerFire triggerFire = new TriggerFire().withProjectKey(this.scenario.getProjectKey()).withScenarioId(this.scenario.getId()).withTrigger(this.trigger);
                triggerFire = triggerFire.withTriggerState(JSON.json((Object)state));
                triggerFire = triggerFire.withParam("runResult", JSON.json((Object)scenarioRun.getResult()));
                return triggerFire;
            }
            return null;
        }
        catch (SQLException ex) {
            throw new Exception(String.format("(triggerId: %s) Could not find the scenario run the trigger is waiting on", this.trigger.id), ex);
        }
    }

    private void createInitialState(ScenariosTriggerService triggerService, String paramsHash, long lastStart) throws SQLException {
        TriggerFire triggerFire = new TriggerFire().withProjectKey(this.scenario.getProjectKey()).withScenarioId(this.scenario.getId()).withTrigger(this.trigger);
        triggerFire = triggerFire.withTriggerState(JSON.json((Object)new FollowScenarioRunTriggerState(paramsHash, lastStart)));
        triggerService.recordState(triggerFire);
    }

    public static class FollowScenarioRunTriggerParams
    implements TriggerParams {
        public String projectKey;
        public String scenarioId;
        public ReportItem.Outcome outcomeFilter;

        public String getProjectKey() {
            return this.projectKey;
        }

        public String getScenarioId() {
            return this.scenarioId;
        }

        public ReportItem.Outcome getOutcomeFilter() {
            return this.outcomeFilter;
        }

        public FollowScenarioRunTriggerParams withProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public FollowScenarioRunTriggerParams withScenarioId(String scenarioId) {
            this.scenarioId = scenarioId;
            return this;
        }

        public FollowScenarioRunTriggerParams withOutcomeFilter(ReportItem.Outcome outcomeFilter) {
            this.outcomeFilter = outcomeFilter;
            return this;
        }
    }

    public static class FollowScenarioRunTriggerState {
        public String paramsHash;
        public long lastStart;

        FollowScenarioRunTriggerState(String paramsHash, long lastStart) {
            this.paramsHash = paramsHash;
            this.lastStart = lastStart;
        }

        public String getParamsHash() {
            return this.paramsHash;
        }

        public long getLastStart() {
            return this.lastStart;
        }
    }
}

