/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.scoring.exports.PythonScoring;
import com.dataiku.dip.utils.DKUFileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Timestamp;
import java.util.List;
import javax.annotation.Nonnull;

public class MLflowScoring
extends PythonScoring {
    private static final String ML_MODEL_BACKUP_FILE_NAME = "MLmodel_backup";
    private static final List<String> DSS_FILES_TO_DELETE = Lists.newArrayList((Object[])new String[]{"mlflow_imported_model.json", "MLmodel_backup", "user_meta.json"});
    private boolean useOriginalModel;
    private boolean useEnhancedMLmodel;

    public MLflowScoring(FullModelId fullModelId, boolean useOriginalModel) {
        this(fullModelId, useOriginalModel, false);
    }

    public MLflowScoring(FullModelId fullModelId, boolean useOriginalModel, boolean useEnhancedMLmodel) {
        super(fullModelId);
        this.useOriginalModel = useOriginalModel;
        this.useEnhancedMLmodel = useEnhancedMLmodel;
        if (useOriginalModel && !fullModelId.isExternalMLflowModelVersion()) {
            logger.warnV("Model %s is not an MLflow model imported in DSS. Ignoring request to export it as the original MLflow model.", new Object[]{fullModelId.toString()});
        }
    }

    @Override
    protected String getSampleFileContent(String samplePath, FullModelId fullModelId) throws IOException {
        String mlflowSamplesDirName = "samples-mlflow";
        File mlflowSamplesDir = new File(samplePath, mlflowSamplesDirName);
        String sampleFileName = "sample.py";
        return DKUFileUtils.readFileToStringUTF8((File)new File(mlflowSamplesDir, sampleFileName));
    }

    @Override
    protected File getRequirementsFileFromSamples(@Nonnull String modelRequirementsContent) {
        String samplePath = MLflowScoring.getSamplesPath();
        if (this.fullModelId.isExternalMLflowModelVersion()) {
            return new File(samplePath, !modelRequirementsContent.contains("mlflow") ? "requirements_mlflow.txt" : "requirements.txt");
        }
        return new File(samplePath, "requirements_mlflow.txt");
    }

    @Override
    public void writeToDir(File tmpExportDir) throws IOException {
        if (this.useOriginalModel && this.fullModelId.isExternalMLflowModelVersion()) {
            this.writeOriginalModelToDir(tmpExportDir);
        } else {
            super.writeToDir(tmpExportDir);
            String dssVersion = MLflowScoring.getDssVersion();
            String samplePath = MLflowScoring.getSamplesPath();
            File exportMLmodel = new File(tmpExportDir.getAbsolutePath(), "MLmodel");
            File exportConda = new File(tmpExportDir.getAbsolutePath(), "conda.yaml");
            String mlModelContent = DKUFileUtils.readFileToStringUTF8((File)new File(samplePath, "MLmodel"));
            mlModelContent = mlModelContent.replaceAll("DATAIKUSCORING_VERSION", dssVersion);
            mlModelContent = mlModelContent.replaceAll("TIMESTAMP", String.valueOf(new Timestamp(System.currentTimeMillis())));
            String pythonVersion = this.getPythonVersion();
            String condaContent = DKUFileUtils.readFileToStringUTF8((File)new File(samplePath, "conda.yaml"));
            condaContent = condaContent.replaceAll("DATAIKUSCORING_VERSION", dssVersion);
            if (pythonVersion == null) {
                logger.error((Object)("Could not find Python version for model " + String.valueOf(this.fullModelId) + ", it might be necessary to manually edit the resulting MLmodel and conda.yaml files to make MLflow compatibility checks work."));
            } else {
                mlModelContent = mlModelContent.replaceAll("PYTHON_VERSION", pythonVersion);
                condaContent = condaContent.replaceAll("PYTHON_VERSION", pythonVersion);
            }
            DKUFileUtils.writeFileUTF8((File)exportMLmodel, (String)mlModelContent);
            DKUFileUtils.writeFileUTF8((File)exportConda, (String)condaContent);
        }
    }

    public void writeOriginalModelToDir(File tmpExportDir) throws IOException {
        File mlflowFolder = this.fullModelId.getModelFolder();
        DKUFileUtils.copyDirectory((File)mlflowFolder, (File)tmpExportDir);
        if (!this.useEnhancedMLmodel) {
            this.restoreMLModelFile(tmpExportDir);
        }
        for (String fileToDelete : DSS_FILES_TO_DELETE) {
            Files.deleteIfExists(new File(tmpExportDir, fileToDelete).toPath());
        }
    }

    private void restoreMLModelFile(File directory) throws IOException {
        File mlModelBackup = new File(directory, ML_MODEL_BACKUP_FILE_NAME);
        File mlModel = new File(directory, "MLmodel");
        if (mlModelBackup.exists()) {
            Files.move(mlModelBackup.toPath(), mlModel.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

