/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.audit.targets;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.filters.RoutingKeyFiltering;
import com.dataiku.dip.filters.TopicsFiltering;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.processors.AbstractProcessor;
import com.dataiku.dip.processors.ConnectionPathTargetProcessorSettings;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.model.FsLikeTargetSettings;
import com.dataiku.dip.security.audit.targets.AuditTarget;
import com.dataiku.dip.security.audit.targets.ConnectionPathAuditTargetProcessor;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class FsLikeTarget
extends AuditTarget {
    private static final String RANDOM_NODE_FOLDER = UUID.randomUUID().toString();
    private final FsLikeTargetSettings settings;
    private final DKULogger logger = DKULogger.getLogger((String)"dku.auditmechanism.fsLikeTarget");
    private final ProcessingQueue processingQueue = new ProcessingQueue();

    public FsLikeTarget(FsLikeTargetSettings inputSettings) throws IOException, DKUSecurityException, CodedException {
        this.logger.info((Object)"Building an object storage (or filesystem) audit target");
        this.settings = inputSettings;
        this.baseSettings = this.settings;
        ConnectionPathTargetProcessorSettings serverTargetSettings = FsLikeTarget.getProcessorSettings(this.settings);
        this.processingQueue.initialize(serverTargetSettings);
    }

    private static ConnectionPathTargetProcessorSettings getProcessorSettings(FsLikeTargetSettings settings) {
        ConnectionPathTargetProcessorSettings targetSettings = new ConnectionPathTargetProcessorSettings();
        targetSettings.topics = settings.topics;
        targetSettings.topicsFiltering = settings.topicsFiltering;
        targetSettings.routingKeys = settings.routingKeys;
        targetSettings.routingKeysFiltering = settings.routingKeysFiltering;
        targetSettings.type = ConnectionPathTargetProcessorSettings.TargetType.FILE_LIKE_CONNECTION_PATH;
        targetSettings.fileLikeConnectionName = settings.fileLikeConnectionName;
        targetSettings.fileLikePathWithinConnection = settings.fileLikePathWithinConnection;
        targetSettings.bucket = settings.bucket;
        targetSettings.partitioningPeriod = FsLikeTarget.map(settings.partitioningPeriod);
        targetSettings.flushEveryBytes = settings.flushEveryBytes;
        targetSettings.flushEveryS = settings.flushEveryS;
        targetSettings.folderByTopic = settings.folderByTopic;
        targetSettings.folderByRoutingKey = settings.folderByRoutingKey;
        targetSettings.nodeFolder = RANDOM_NODE_FOLDER;
        return targetSettings;
    }

    private static TimeDimension.Period map(FsLikeTargetSettings.Period period) {
        switch (period) {
            case YEAR: {
                return TimeDimension.Period.YEAR;
            }
            case HOUR: {
                return TimeDimension.Period.HOUR;
            }
            case MONTH: {
                return TimeDimension.Period.MONTH;
            }
        }
        return TimeDimension.Period.DAY;
    }

    public void handle(AuditObj auditObj) throws Exception {
        this.logger.trace((Object)("Storage audit target thread handling " + JSON.json((Object)auditObj)));
        AuditObj copy = (AuditObj)JSON.deepCopy((Object)auditObj);
        copy.get().addProperty("auditTopic", auditObj.topic);
        if (auditObj.routingKey != null) {
            copy.get().addProperty("auditRoutingKey", copy.routingKey);
        }
        copy.get().addProperty("timestamp", DKUDateUtils.isoFormatLocal((long)System.currentTimeMillis()));
        this.processingQueue.push(copy);
    }

    public void shutdown() throws InterruptedException {
        this.processingQueue.shutdown();
    }

    private static class ProcessingQueue {
        private static final int QUEUE_SIZE = 5000;
        private volatile boolean shutdown;
        private ConnectionPathTargetProcessorSettings settings;
        @Nullable
        private QueueHandler handler;
        @Nullable
        private Thread thread;
        private static final Logger logger = Logger.getLogger((String)"dku.auditmechanism.fsLikeTarget.queue");

        private ProcessingQueue() {
        }

        public synchronized void shutdown() {
            logger.info((Object)("Stopping " + this.getClass().getSimpleName() + " existing thread"));
            this.shutdown = true;
            this.handler = null;
            if (this.thread != null) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            logger.info((Object)"Shutdown complete");
        }

        public synchronized void initialize(ConnectionPathTargetProcessorSettings newSettings) throws CodedException, IOException, DKUSecurityException {
            logger.info((Object)"Loading new settings");
            this.settings = (ConnectionPathTargetProcessorSettings)JSON.deepCopy((Object)newSettings);
            ConnectionPathAuditTargetProcessor processor = new ConnectionPathAuditTargetProcessor(newSettings);
            processor.init();
            logger.info((Object)("Initialized " + String.valueOf(processor)));
            QueueHandler queueHandler = new QueueHandler();
            queueHandler.name = "target-" + processor.getClass().getSimpleName();
            queueHandler.inQueue = new LinkedBlockingQueue(5000);
            queueHandler.processor = processor;
            this.handler = queueHandler;
            this.thread = new Thread(queueHandler);
            this.thread.start();
            logger.info((Object)"Handler has started");
        }

        public synchronized void push(AuditObj req) {
            block12: {
                if (this.handler == null) {
                    return;
                }
                try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.auditmechanism.fsLikeTarget.events.enqueue");){
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"enqueue the handler");
                    }
                    try {
                        boolean success;
                        if (this.settings.topicsFiltering != TopicsFiltering.ALL && !this.settings.topics.contains(req.topic) || this.settings.routingKeysFiltering != RoutingKeyFiltering.ALL && !this.settings.routingKeys.contains(req.routingKey)) break block12;
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Event matched for handler " + this.handler.name));
                        }
                        if (success = this.handler.inQueue.offer(req, 5L, TimeUnit.MILLISECONDS)) {
                            DSSMetrics.registry().meter("dku.auditmechanism.fsLikeTarget.handler." + this.handler.name + ".queued").mark();
                            break block12;
                        }
                        DSSMetrics.registry().meter("dku.auditmechanism.fsLikeTarget.handler." + this.handler.name + ".lostInQueue").mark();
                    }
                    catch (Exception e) {
                        DSSMetrics.registry().meter("dku.auditmechanism.fsLikeTarget.handler." + this.handler.name + ".lostInQueue").mark();
                    }
                }
            }
        }

        private class QueueHandler
        implements Runnable {
            String name;
            AbstractProcessor<AuditObj> processor;
            LinkedBlockingQueue<AuditObj> inQueue;

            private QueueHandler() {
            }

            @Override
            public void run() {
                Thread.currentThread().setName("QueueHandler-" + this.name);
                logger.info((Object)("Processing queue starting up for " + this.name));
                while (!ProcessingQueue.this.shutdown) {
                    AuditObj req;
                    try {
                        req = this.inQueue.poll(2000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    if (req == null) continue;
                    try {
                        DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)("dku.auditmechanism.fsLikeTarget.queuehandler." + this.name + ".process"));
                        try {
                            this.processor.process(req);
                        }
                        finally {
                            if (tctx == null) continue;
                            tctx.close();
                        }
                    }
                    catch (Exception e) {
                        DSSMetrics.registry().meter("dku.auditmechanism.fsLikeTarget.queuehandler." + this.name + ".processFailed");
                        logger.warn((Object)"Processing error", (Throwable)e);
                    }
                }
                logger.info((Object)("Processing queue thread for " + this.name + " shutting down"));
                try {
                    this.processor.shutdown();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to shutdown processing queue", (Throwable)e);
                }
            }
        }
    }
}

