/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.auth.APIAuthUtils;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.PublicAPIKeyAuthService;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetaAuthService {
    @Autowired
    private PublicAPIKeyAuthService publicApi;
    @Autowired
    private UIAuthService ui;
    @Autowired
    private TicketAuthService ticket;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.security.auth");

    public AuthCtxUsage getTicketOrKeyAndContext_NT(HttpServletRequest req) throws DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtxUsage authCtxUsage = this.getTicketOrKeyAndContext(req);
            return authCtxUsage;
        }
    }

    public AuthCtxUsage getTicketOrKeyAndContext(HttpServletRequest req) throws DKUSecurityException {
        try {
            if (req.getHeader("x-dku-apiticket") != null) {
                APITicketService.TicketUsage tu = this.ticket.getAndUseMandTicket(req);
                AuthCtx authCtx = this.applyProxyUser(req, tu.getAuthCtx());
                AuditContextBase.setAuthContext((AuthCtx)authCtx);
                return new ProxyTicketUsage(tu, authCtx);
            }
            if (req.getHeader("authorization") != null) {
                PublicAPIKey key = this.publicApi.getKey(req);
                DSSAuthCtx authCtx = DSSAuthCtx.forAPIKey(key);
                authCtx = this.applyProxyUser(req, authCtx);
                AuditContextBase.setAuthContext((AuthCtx)authCtx);
                return new SimpleDSSAuthCtxUsage(authCtx);
            }
            throw new NotAuthenticatedException("Authentication not provided", "no-authentication");
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read authentication info ", (Throwable)e);
            throw new DKUSecurityException("Failed to read authentication info");
        }
    }

    public AuthCtx getTicketOrKey_NT(HttpServletRequest req) throws DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.getTicketOrKey(req);
            return authCtx;
        }
    }

    public AuthCtx getTicketOrKey(HttpServletRequest req) throws DKUSecurityException {
        try {
            AuthCtx authCtx;
            if (req.getHeader("x-dku-apiticket") != null) {
                authCtx = this.ticket.getMandTicketAuthCtx(req);
            } else if (req.getHeader("authorization") != null) {
                PublicAPIKey key = this.publicApi.getKey(req);
                authCtx = DSSAuthCtx.forAPIKey(key);
            } else {
                throw new NotAuthenticatedException("Authentication not provided", "no-authentication");
            }
            AuthCtx proxyAuthCtx = this.applyProxyUser(req, authCtx);
            AuditContextBase.setAuthContext((AuthCtx)proxyAuthCtx);
            return proxyAuthCtx;
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read authentication info ", (Throwable)e);
            throw new DKUSecurityException("Failed to read authentication info");
        }
    }

    public AuthCtx getFromAnyNoXSRF(HttpServletRequest req) throws DKUSecurityException {
        try {
            AuthCtx authCtx;
            if (req.getHeader("x-dku-apiticket") != null) {
                authCtx = this.ticket.getMandTicketAuthCtx(req);
            } else if (APIAuthUtils.hasBasicOrBearerHeader((HttpServletRequest)req)) {
                PublicAPIKey key = this.publicApi.getKey(req);
                authCtx = DSSAuthCtx.forAPIKey(key);
            } else {
                authCtx = this.ui.getUserNoXSRF(req);
            }
            return this.applyProxyUser(req, authCtx);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read authentication info ", (Throwable)e);
            throw new DKUSecurityException("Failed to read authentication info");
        }
    }

    public AuthCtx getFromAny(HttpServletRequest req) throws DKUSecurityException {
        try {
            AuthCtx authCtx;
            if (req.getHeader("x-dku-apiticket") != null) {
                authCtx = this.ticket.getMandTicketAuthCtx(req);
            } else if (APIAuthUtils.hasBasicOrBearerHeader((HttpServletRequest)req)) {
                PublicAPIKey key = this.publicApi.getKey(req);
                authCtx = DSSAuthCtx.forAPIKey(key);
            } else {
                authCtx = this.ui.getUser(req);
            }
            return this.applyProxyUser(req, authCtx);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read authentication info ", (Throwable)e);
            throw new DKUSecurityException("Failed to read authentication info");
        }
    }

    public AuthCtxUsage getWithContextFromAnyOrNullNoXSRF(HttpServletRequest req) throws DKUSecurityException {
        try {
            if (req.getHeader("x-dku-apiticket") != null) {
                APITicketService.TicketUsage tu = this.ticket.getAndUseMandTicket(req);
                AuthCtx authCtx = this.applyProxyUser(req, tu.getAuthCtx());
                return new ProxyTicketUsage(tu, authCtx);
            }
            if (req.getHeader("authorization") != null) {
                PublicAPIKey key = this.publicApi.getKey(req);
                DSSAuthCtx authCtx = DSSAuthCtx.forAPIKey(key);
                AuthCtx proxyAuthCtx = this.applyProxyUser(req, authCtx);
                return new SimpleDSSAuthCtxUsage(proxyAuthCtx);
            }
            AuthCtx authCtx = this.ui.getUserNoXSRF(req);
            if (authCtx == null) {
                return null;
            }
            AuthCtx proxyAuthCtx = this.applyProxyUser(req, authCtx);
            return new SimpleDSSAuthCtxUsage(proxyAuthCtx);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read authentication info ", (Throwable)e);
            throw new DKUSecurityException("Failed to read authentication info");
        }
    }

    public AuthCtxUsage getWithContextFromAny(HttpServletRequest req) throws DKUSecurityException {
        try {
            if (req.getHeader("x-dku-apiticket") != null) {
                APITicketService.TicketUsage tu = this.ticket.getAndUseMandTicket(req);
                AuthCtx authCtx = this.applyProxyUser(req, tu.getAuthCtx());
                return new ProxyTicketUsage(tu, authCtx);
            }
            if (req.getHeader("authorization") != null) {
                PublicAPIKey key = this.publicApi.getKey(req);
                DSSAuthCtx authCtx = DSSAuthCtx.forAPIKey(key);
                AuthCtx proxyAuthCtx = this.applyProxyUser(req, authCtx);
                return new SimpleDSSAuthCtxUsage(proxyAuthCtx);
            }
            AuthCtx authCtx = this.ui.getUser(req);
            if (authCtx != null) {
                AuthCtx proxyAuthCtx = this.applyProxyUser(req, authCtx);
                return new SimpleDSSAuthCtxUsage(proxyAuthCtx);
            }
            throw new NotAuthenticatedException("Authentication not provided", "no-authentication");
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read authentication info ", (Throwable)e);
            throw new DKUSecurityException("Failed to read authentication info");
        }
    }

    public void verifyDebugAccess_NT(HttpServletRequest req) throws DKUSecurityException {
        this.verifyDebugAccess_NT(req, false);
    }

    public void verifyDebugAccess_NT(HttpServletRequest req, boolean checkXSRF) throws DKUSecurityException {
        String ss = req.getHeader("X-DKU-IPythonSharedSecret");
        if (ss != null && StringUtils.equals((String)ss.trim(), (String)SharedSecretUtils.getSharedSecret((boolean)true))) {
            logger.debug((Object)"Debug call allowed via shared secret");
            return;
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = checkXSRF ? this.getFromAny(req) : this.getFromAnyNoXSRF(req);
            if (authCtx == null) {
                throw new DKUSecurityException("You are not allowed to call this");
            }
            if (!authCtx.isAdmin()) {
                throw new DKUSecurityException("You are not allowed to call this");
            }
            logger.debug((Object)"Debug call allowed via AuthCtx");
        }
    }

    private AuthCtx applyProxyUser(HttpServletRequest req, AuthCtx originalAuthCtx) throws DKUSecurityException {
        if (req.getHeader("X-DKU-ProxyUser") != null) {
            if (!originalAuthCtx.isAdmin()) {
                throw new UnauthorizedException("Original AuthCtx is not admin, proxyuser denied", "proxyuser-denied");
            }
            String proxyUser = req.getHeader("X-DKU-ProxyUser");
            AuthCtx proxyAuthCtx = this.authCtxCreationService.create(proxyUser);
            proxyAuthCtx.addParent(originalAuthCtx);
            proxyAuthCtx.addVia("proxyuser-from: " + originalAuthCtx.getIdentifier());
            return proxyAuthCtx;
        }
        return originalAuthCtx;
    }

    private static class ProxyTicketUsage
    implements AuthCtxUsage {
        private final APITicketService.TicketUsage ticketUsage;
        private final AuthCtx proxyAuthCtx;

        public ProxyTicketUsage(APITicketService.TicketUsage ticketUsage, AuthCtx proxyAuthCtx) {
            this.ticketUsage = ticketUsage;
            this.proxyAuthCtx = proxyAuthCtx;
        }

        public void close() throws Exception {
            this.ticketUsage.close();
        }

        public AuthCtx getAuthCtx() {
            return this.proxyAuthCtx;
        }

        public Object getPayload() {
            return this.ticketUsage.getTicket();
        }
    }

    private static class SimpleDSSAuthCtxUsage
    implements AuthCtxUsage {
        private final AuthCtx authCtx;

        public SimpleDSSAuthCtxUsage(AuthCtx authCtx) {
            this.authCtx = authCtx;
        }

        public void close() throws Exception {
        }

        public AuthCtx getAuthCtx() {
            return this.authCtx;
        }

        public Object getPayload() {
            return null;
        }
    }
}

