/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.dev.DevPluginsService;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.projects.apps.CustomAppTemplatesService;
import com.dataiku.dip.projects.apps.LoadedCustomAppTemplate;
import com.dataiku.dip.projects.importexport.model.BundleContainerSettings;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.ProjectImportExportController;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.TimelinesInternalDB;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.jsoup.helper.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DevAppsController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    protected TimelinesInternalDB timelinesDAO;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    protected AppsService appsService;
    @Autowired
    protected ProjectsService projectsService;
    @Autowired
    protected UsersService usersService;
    @Autowired
    protected IPluginsRegistryService pluginsRegistryService;
    @Autowired
    protected DevPluginsService devPluginsService;
    @Autowired
    protected FutureService futureService;
    @Autowired
    protected CustomAppTemplatesService appTemplatesService;
    @Autowired
    protected WorkspacesService workspacesService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.apps.dev.controller");

    @RequestMapping(value={"/api/projects/get-app-manifest"}, method={RequestMethod.GET})
    public void getProjectAppManifest(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            DevAppsController.writeJSON((HttpServletResponse)resp, (Object)this.appsService.getAppTemplateManifestForProject_T(projectKey));
        }
    }

    @RequestMapping(value={"/api/projects/save-app-manifest"}, method={RequestMethod.POST})
    public void saveProjectAppManifest(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String appManifest) throws Exception {
        AppManifest am = (AppManifest)JSON.parse((String)appManifest, AppManifest.class);
        Validate.notNull((Object)am);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, AppsService.minimumPermissionForAppDesigner());
            this.appsService.saveAppTemplateManifestForProject(projectKey, am);
            t.commit("Saved app manifest");
        }
    }

    @RequestMapping(value={"/api/projects/get-app-remapping"}, method={RequestMethod.GET})
    public void getProjectAppRemapping(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
            if (sp.bundleContainerSettings == null) {
                DevAppsController.writeJSON((HttpServletResponse)resp, (Object)new ProjectRemappingSettings());
            } else {
                DevAppsController.writeJSON((HttpServletResponse)resp, (Object)sp.bundleContainerSettings.remapping);
            }
        }
    }

    @AuditedCall(value={"msgType", "automation-bundle-set-settings", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/save-app-remapping"}, method={RequestMethod.POST})
    public void saveRemappingsSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String settings) throws Exception {
        if (ApplicationConfigurator.getNodeType() != ApplicationConfigurator.DSSNodeType.DESIGN) {
            throw new IllegalStateException("Setting app remappings is only possible on a design node");
        }
        ProjectRemappingSettings remapping = (ProjectRemappingSettings)JSON.parse((String)settings, ProjectRemappingSettings.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, AppsService.minimumPermissionForAppDesigner());
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            if (sp.bundleContainerSettings == null) {
                sp.bundleContainerSettings = new BundleContainerSettings();
            }
            sp.bundleContainerSettings.remapping = remapping;
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY);
            t.commit("Updated app remapping settings");
        }
    }

    @RequestMapping(value={"/api/projects/switch-app-type"}, method={RequestMethod.POST})
    public void switchAppType(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="appType") String appTypeStr, @RequestParam(required=false, value="manifest") String manifestStr, @RequestParam(required=false, value="settings") String settingsStr) throws Exception {
        AppManifest manifest = StringUtils.isNotBlank((String)manifestStr) ? (AppManifest)JSON.parse((String)manifestStr, AppManifest.class) : null;
        AppsService.ManifestCreationSettings settings = StringUtils.isNotBlank((String)settingsStr) ? (AppsService.ManifestCreationSettings)JSON.parse((String)settingsStr, AppsService.ManifestCreationSettings.class) : null;
        SerializedProject.ProjectAppType appType = SerializedProject.ProjectAppType.valueOf(appTypeStr);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = t.getUser();
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, AppsService.minimumPermissionForAppDesigner());
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            if (sp.hasSetupSection && appType == SerializedProject.ProjectAppType.REGULAR) {
                sp.hasSetupSection = false;
                sp.projectAppType = SerializedProject.ProjectAppType.REGULAR;
            } else if (sp.projectAppType == appType) {
                throw new IllegalArgumentException("Project " + projectKey + " is already a " + String.valueOf((Object)appType));
            }
            sp.projectAppType = appType;
            SerializedProject saved = this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY);
            if (manifest != null) {
                this.appsService.saveAppTemplateManifestForProject(projectKey, manifest);
            } else if (appType == SerializedProject.ProjectAppType.APP_TEMPLATE && settings != null) {
                this.appsService.appTemplatify_T(sp, settings);
            } else if (appType != SerializedProject.ProjectAppType.REGULAR) {
                this.appsService.appTemplatify_T(sp);
            }
            if (appType == SerializedProject.ProjectAppType.REGULAR) {
                this.workspacesService.notifyApplicationDeleted(authCtx, AppsService.buildApplicationId(projectKey));
                this.appsService.unAppTemplatify_T(sp);
            }
            t.commit("Converted " + projectKey + " to a " + String.valueOf((Object)appType));
            DevAppsController.writeJSON((HttpServletResponse)resp, (Object)saved);
        }
    }

    @RequestMapping(value={"/api/projects/set-setup-section"}, method={RequestMethod.POST})
    public void addSetupAction(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam boolean enabled) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, AppsService.minimumPermissionForAppDesigner());
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            sp.hasSetupSection = enabled;
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY);
            this.appsService.createManifestForSetupSection_T(sp);
            t.commit("Set setup section in " + projectKey + " to: " + enabled);
        }
    }

    @RequestMapping(value={"/api/projects/create-or-update-plugin"}, method={RequestMethod.POST})
    public void createOrUpdatePlugin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String pluginId, @RequestParam String appName) throws Exception {
        AppManifest manifest;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, AppsService.minimumPermissionForAppDesigner());
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            if (sp.projectAppType != SerializedProject.ProjectAppType.APP_TEMPLATE) {
                throw new IllegalArgumentException("Project " + projectKey + " is not an APP_TEMPLATE");
            }
            manifest = this.appsService.getAppTemplateManifestForProject_T(projectKey);
        }
        if (!this.pluginsRegistryService.getLoadedPluginIds().contains(pluginId)) {
            this.devPluginsService.createEmptyPluginAndWait(pluginId, authCtx);
        } else if (!this.pluginsRegistryService.isPluginInstalledAsDev(pluginId)) {
            throw new IllegalArgumentException("Cannot update app template in non-dev plugin");
        }
        LoadedCustomAppTemplate loadedDesc = (LoadedCustomAppTemplate)this.appTemplatesService.getLoadedDescById(appName);
        DevPluginsService.RecipeConversionResult result = loadedDesc == null ? this.devPluginsService.addNewAppTemplateToDevPlugin(pluginId, appName, authCtx) : this.devPluginsService.getRecipeConversionResult(pluginId, "apps", appName, authCtx);
        ExportProjectForTemplateThread ft = new ExportProjectForTemplateThread(authCtx, projectKey, manifest, result);
        DevAppsController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<DevPluginsService.RecipeConversionResult>>(){}));
    }

    private class ExportProjectForTemplateThread
    extends SimpleFutureThread<DevPluginsService.RecipeConversionResult> {
        private final DevPluginsService.RecipeConversionResult conversionResult;
        private final String projectKey;
        private final AppManifest manifest;

        public ExportProjectForTemplateThread(AuthCtx owner, String projectKey, AppManifest manifest, DevPluginsService.RecipeConversionResult conversionResult) {
            super(owner, "ExportApp");
            this.projectKey = projectKey;
            this.manifest = manifest;
            this.conversionResult = conversionResult;
        }

        @Override
        protected DevPluginsService.RecipeConversionResult compute() throws Exception {
            String appExportId = SecretKeyGenerator.generate((int)12);
            File appArchive = DSSTempUtils.getTempFileWithSpecificName((String)"plugin-app-export", (String)appExportId, (String)"zip");
            DKUFileUtils.mkdirsParent((File)appArchive);
            ProjectImportExportController.ProjectExportResult exportResult = DevAppsController.this.appsService.exportProjectAccordingToManifest(this.owner, this.projectKey, this.manifest, appExportId, appArchive);
            logger.info((Object)("Export returned : " + JSON.pretty((Object)((Object)exportResult))));
            File targetArchive = new File(this.conversionResult.pathToFiles, "project.zip");
            logger.info((Object)("Final location is " + targetArchive.getAbsolutePath()));
            if (targetArchive.exists()) {
                DKUFileUtils.delete((File)targetArchive);
            }
            FileUtils.moveFile((File)appArchive, (File)targetArchive);
            return this.conversionResult;
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "export-app";
            fp.displayName = "Refresh plugin app " + this.conversionResult.recipeId + " with project " + this.projectKey;
            return fp;
        }
    }
}

