/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.cluster.ClusterDependentKernelItem;
import com.dataiku.dip.dataflow.kernel.master.BuildService;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.hive.HProxyKernelsManager;
import com.dataiku.dip.recipes.code.scala.ScalaKernelsManager;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class RunningTasksController
extends DIPInternalControllerBase {
    @Autowired
    private FutureService futureService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FlowExecutionService2 flowExecutionService;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private BuildService buildService;
    @Autowired
    private HProxyKernelsManager hProxyKernelsManager;
    @Autowired
    private ScalaKernelsManager scalaKernelsManager;
    private static Logger logger = Logger.getLogger((String)"dip.running.tasks");

    @AuditedCall(value={"msgType", "running-list-personal"})
    @RequestMapping(value={"/api/running/list-personal"})
    public void listPersonalRunning(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        AllRunningResponse ret = new AllRunningResponse();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        try {
            List<JupyterUtils.ActiveSession> sessions = this.jupyterService.listActiveSessions();
            List<JupyterService.KernelSpec> kernelSpecs = this.jupyterService.listKernelSpecs();
            try (Transaction t = this.transactionService.beginRead();){
                ret.notebooks = this.buildPersonalNotebooksList(authCtx, sessions, kernelSpecs);
            }
        }
        catch (ConnectException e) {
            logger.error((Object)e);
            ret.notebooks = new ArrayList<JupyterUtils.JupyterNotebookListEntry>();
        }
        ret.futures = this.futureService.buildActiveFuturesList(this.futureService.getThreads(authCtx.getIdentifier()));
        ret.jobs = this.buildJobsList(authCtx);
        RunningTasksController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "running-list-all"})
    @RequestMapping(value={"/api/running/list-all"})
    public void listAllRunning(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AllRunningResponse ret = new AllRunningResponse();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        try {
            List<JupyterUtils.ActiveSession> sessions = this.jupyterService.listActiveSessions();
            List<JupyterService.KernelSpec> kernelSpecs = this.jupyterService.listKernelSpecs();
            try (Transaction t = this.transactionService.beginRead();){
                ret.notebooks = this.buildGlobalNotebooksList(sessions, kernelSpecs);
            }
        }
        catch (ConnectException e) {
            logger.error((Object)e);
            ret.notebooks = new ArrayList<JupyterUtils.JupyterNotebookListEntry>();
        }
        ret.futures = this.futureService.buildActiveFuturesList(this.futureService.getAllThreads());
        ret.jobs = this.buildAllJobsList();
        ret.clusterKernels = Lists.newArrayList();
        ret.clusterKernels.addAll(this.hProxyKernelsManager.getKernelItems());
        ret.clusterKernels.addAll(this.scalaKernelsManager.getKernelItems());
        ret.clusterKernels.sort((a, b) -> {
            long diff = a.lastTouched - b.lastTouched;
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        });
        RunningTasksController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    private List<JupyterUtils.JupyterNotebookListEntry> buildPersonalNotebooksList(AuthCtx authCtx, List<JupyterUtils.ActiveSession> sessions, List<JupyterService.KernelSpec> kernelSpecs) throws Exception {
        List<JupyterUtils.JupyterNotebookListEntry> allNotebooks = this.jupyterService.listActiveNotebooksUnsafe(sessions, kernelSpecs);
        ArrayList<JupyterUtils.JupyterNotebookListEntry> notebooks = new ArrayList<JupyterUtils.JupyterNotebookListEntry>(allNotebooks.size());
        HashMap<String, Boolean> projectsAccessibility = new HashMap<String, Boolean>();
        for (JupyterUtils.JupyterNotebookListEntry nbk : allNotebooks) {
            Boolean access = (Boolean)projectsAccessibility.get(nbk.projectKey);
            if (access == null) {
                access = this.permissionsService.hasProjectPrivilege(authCtx, nbk.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                projectsAccessibility.put(nbk.projectKey, access);
            }
            if (!access.booleanValue()) continue;
            ListIterator<JupyterUtils.ActiveSession> it = nbk.activeSessions.listIterator();
            while (it.hasNext()) {
                JupyterUtils.ActiveSession as = it.next();
                if (authCtx.getIdentifier().equals(as.sessionCreator)) continue;
                it.remove();
            }
            if (nbk.activeSessions.size() <= 0) continue;
            notebooks.add(nbk);
        }
        Collections.sort(notebooks, new Comparator<JupyterUtils.JupyterNotebookListEntry>(){

            @Override
            public int compare(JupyterUtils.JupyterNotebookListEntry a, JupyterUtils.JupyterNotebookListEntry b) {
                int diff = a.lastModifiedOn < b.lastModifiedOn ? -1 : (a.lastModifiedOn > b.lastModifiedOn ? 1 : 0);
                return -diff;
            }
        });
        return notebooks;
    }

    private List<JupyterUtils.JupyterNotebookListEntry> buildGlobalNotebooksList(List<JupyterUtils.ActiveSession> sessions, List<JupyterService.KernelSpec> kernelSpecs) throws Exception {
        List<JupyterUtils.JupyterNotebookListEntry> notebooks = this.jupyterService.listActiveNotebooksUnsafe(sessions, kernelSpecs);
        notebooks.sort((a, b) -> {
            int diff = a.lastModifiedOn < b.lastModifiedOn ? -1 : (a.lastModifiedOn > b.lastModifiedOn ? 1 : 0);
            return -diff;
        });
        return notebooks;
    }

    private List<FlowExecutionService2.JobSummary> buildJobsList(AuthCtx authCtx) throws Exception {
        List<FlowExecutionService2.JobSummary> allJobs = this.buildService.listAllRunningJobs(false);
        ArrayList<FlowExecutionService2.JobSummary> jobs = new ArrayList<FlowExecutionService2.JobSummary>(allJobs.size());
        for (FlowExecutionService2.JobSummary job : allJobs) {
            if (!authCtx.getIdentifier().equals(job.def.initiator)) continue;
            jobs.add(job);
        }
        Collections.sort(jobs, new Comparator<FlowExecutionService2.JobSummary>(){

            @Override
            public int compare(FlowExecutionService2.JobSummary a, FlowExecutionService2.JobSummary b) {
                return -((int)(a.def.initiationTimestamp - b.def.initiationTimestamp));
            }
        });
        return jobs;
    }

    private List<FlowExecutionService2.JobSummary> buildAllJobsList() {
        List<FlowExecutionService2.JobSummary> allJobs = this.buildService.listAllRunningJobs(true);
        Collections.sort(allJobs, new Comparator<FlowExecutionService2.JobSummary>(){

            @Override
            public int compare(FlowExecutionService2.JobSummary a, FlowExecutionService2.JobSummary b) {
                return -((int)(a.def.initiationTimestamp - b.def.initiationTimestamp));
            }
        });
        return allJobs;
    }

    static class AllRunningResponse {
        List<FutureResponse<?>> futures;
        List<FlowExecutionService2.JobSummary> jobs;
        List<JupyterUtils.JupyterNotebookListEntry> notebooks;
        List<ClusterDependentKernelItem> clusterKernels;

        AllRunningResponse() {
        }
    }
}

