/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SessionsDAO;
import com.dataiku.dip.dao.UserLastActivity;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.license.TrialToken;
import com.dataiku.dip.onboarding.OnboardingQuestionnaire;
import com.dataiku.dip.onboarding.PageSpecificTourSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.IWorkspacePermissionsService;
import com.dataiku.dip.security.PermissionsWatcher;
import com.dataiku.dip.security.PermissionsWatchersService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.ExternalUser;
import com.dataiku.dip.security.auth.FetchedUsersResponse;
import com.dataiku.dip.security.auth.GroupDiff;
import com.dataiku.dip.security.auth.OAuth2CallbackResponse;
import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.auth.UserAuthenticationService;
import com.dataiku.dip.security.auth.UserDiff;
import com.dataiku.dip.security.auth.UserQueryFilter;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.model.ConnectionCredentialsCRUDService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.security.model.PluginCredentialRequestService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ATSurveyService;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.server.services.DkuUsersService;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.NPSSurveyService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TrackingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.TrialTokenAcquisitionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.collect.Multimap;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URLEncodedUtils;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class UsersController
extends DIPInternalControllerBase {
    private static final String OAUTH_2_FRONTEND_ROUTE = "/oauth2-callback";
    private static final String USER_STATE_PARAMETER = "userState";
    private static final String SUCCESS_PARAMETER = "success";
    private static final String MESSAGE_PARAMETER = "message";
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private TrackingService trackingService;
    @Autowired
    private UsersService service;
    @Autowired
    private AchievementsService achievementService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private NPSSurveyService npsSurveyService;
    @Autowired
    private ATSurveyService atSurveyService;
    @Autowired
    private PermissionsWatchersService permissionsWatchersService;
    @Autowired
    private ConnectionCredentialsCRUDService connectionCredentialsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IWorkspacePermissionsService workspacePermissionsService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private SessionsDAO sessionsDAO;
    @Autowired
    private LicenseStatusService licenseService;
    @Autowired
    private UserAuthenticationService userAuthenticationService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private DkuUsersService usersService;
    @VisibleForTesting
    int syncUsersFutureWaitTime = 0;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.admin.security");

    @AuditedCall(value={"msgType", "security-users-list"})
    @RequestMapping(value={"/api/security/list-users"})
    public void listUsers(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String workspaceKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx ac;
            UsersService.UIUser u;
            ListIterator<UsersService.UIUser> it;
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            List<UsersService.UIUser> users = this.service.listUsersEnabledOnly_RestrictionCheck_NoLeak(authCtx);
            if (StringUtils.isNotBlank((String)projectKey)) {
                this.projectsService.checkReadDashboardPerm(req, projectKey, null, null);
                it = users.listIterator();
                while (it.hasNext()) {
                    u = it.next();
                    ac = this.authCtxCreationService.create(u.login);
                    if (this.permissionsService.hasAnyProjectAccess(ac, projectKey)) continue;
                    it.remove();
                }
            }
            if (StringUtils.isNotBlank((String)workspaceKey)) {
                it = users.listIterator();
                while (it.hasNext()) {
                    u = it.next();
                    ac = this.authCtxCreationService.create(u.login);
                    if (this.workspacePermissionsService.hasWorkspacePrivileges(ac, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.READ)) continue;
                    it.remove();
                }
            }
            UsersController.writeJSON((HttpServletResponse)resp, users);
        }
    }

    @AuditedCall(value={"msgType", "security-connected-users-list"})
    @RequestMapping(value={"/api/security/list-connected-users"})
    @ResponseBody
    public List<PublicUser> listUsers(HttpServletRequest req, @RequestParam(required=false) String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            LinkedHashSet<PublicUser> connectedUsers = new LinkedHashSet<PublicUser>();
            if (StringUtils.isNotBlank((String)projectKey) && this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                connectedUsers.addAll(this.trackingService.getUsersOnProject(projectKey));
            }
            connectedUsers.addAll(this.trackingService.getConnectedUsers());
            List<PublicUser> list = this.trackingService.anonymizeUsers(authCtx, connectedUsers);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "security-groups-list-and-options"})
    @RequestMapping(value={"/api/security/list-groups-with-security-options"})
    public void listGroupsAndSecurityOptions(HttpServletRequest req, HttpServletResponse resp, @RequestParam boolean localOnly) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.listGroupNamesWithSecurity(authCtx, localOnly));
        }
    }

    @AuditedCall(value={"msgType", "security-groups-list"})
    @RequestMapping(value={"/api/security/list-groups"})
    public void listGroups(HttpServletRequest req, HttpServletResponse resp, @RequestParam boolean localOnly) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            UsersController.writeJSON((HttpServletResponse)resp, this.service.listGroupNames(authCtx, localOnly));
        }
    }

    @AuditedCall(value={"msgType", "security-admin-groups-list"})
    @RequestMapping(value={"/api/security/list-groups-full"})
    public void listGroupsFull(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(authCtx);
            UsersController.writeJSON((HttpServletResponse)resp, this.service.listGroupsFull());
        }
    }

    @AuditedCall(value={"msgType", "security-admin-group-prepare-edit"})
    @RequestMapping(value={"/api/security/prepare-update-group"})
    public void prepareUpdateGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String groupData) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(u);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
        }
        UsersDAO.Group group = (UsersDAO.Group)JSON.parse((String)groupData, UsersDAO.Group.class);
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.prepareUpdateGroup_NT(group, u));
    }

    @AuditInline
    @RequestMapping(value={"/api/security/update-group"})
    public void updateGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String groupData) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(t.getUser());
            UsersDAO.Group group = (UsersDAO.Group)JSON.parse((String)groupData, UsersDAO.Group.class);
            PermissionsWatcher pw = this.permissionsWatchersService.startGroupWatch(group.name);
            GroupDiff groupDiff = this.service.updateGroup(group);
            pw.stop();
            t.commit("Updated user group " + group.name);
            this.auditTrailService.generic("security-admin-group-edit").with("group", group.name).withAll(groupDiff.getDiff()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("security-admin-group-edit", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "security-admin-group-get", "group", "${groupName}"})
    @RequestMapping(value={"/api/security/get-group"})
    public void getGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String groupName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.getGroup(groupName));
        }
    }

    @AuditedCall(value={"msgType", "security-admin-group-prepare-delete", "group", "${groupName}"})
    @RequestMapping(value={"/api/security/prepare-delete-group"})
    public void prepareDeleteGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String groupName) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(u);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
        }
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.prepareDeleteGroup_NT(groupName, u));
    }

    @AuditedCall(value={"msgType", "security-admin-group-delete", "group", "${groupName}"})
    @RequestMapping(value={"/api/security/delete-group"})
    public void deleteGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String groupName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            PermissionsWatcher pw = this.permissionsWatchersService.startGroupWatch(groupName);
            this.authService.failIfNotAdmin(u);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
            this.service.deleteGroup(u, groupName);
            pw.stop();
            t.commit("Deleted user group " + groupName);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/security/create-group"})
    public void createGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String groupData) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(t.getUser());
            UsersDAO.Group group = (UsersDAO.Group)JSON.parse((String)groupData, UsersDAO.Group.class);
            this.service.addGroup(group);
            t.commit("Created group " + group.name);
            this.auditTrailService.generic("security-admin-group-create").with("group", group.name).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("security-admin-group-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/users/create"})
    @ResponseBody
    public InfoMessage.InfoMessages adminCreate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String user) throws Exception {
        try {
            AuthCtx authCtx = null;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.authService.failIfNotAdmin(req);
                this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            }
            UsersService.UIUser usr = (UsersService.UIUser)JSON.parse((String)user, UsersService.UIUser.class);
            InfoMessage.InfoMessages ret = this.service.addUserAdmin_NT(usr, authCtx);
            this.auditTrailService.generic("security-admin-user-create").with("user", usr.login).emit();
            return ret;
        }
        catch (Exception e) {
            this.auditTrailService.failure("security-admin-user-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "security-list-users-matching-email", "email", "${email}"})
    @RequestMapping(value={"/api/security/list-users-matching-email"})
    public void listUsersMatchingEmail(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String workspaceKey, @RequestParam String email) throws Exception {
        List users;
        try (Transaction ignored = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            if (!GeneralSettingsService.arePermissionsByEmailEnabled(generalSettings)) {
                throw new IllegalArgumentException("Cannot list users matching this email, invitations by email are not enabled");
            }
            if (StringUtils.isNotBlank((String)projectKey)) {
                this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS);
            } else if (StringUtils.isNotBlank((String)workspaceKey)) {
                this.workspacePermissionsService.checkWorkspacePrivileges((AuthCtx)authCtx, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.ADMIN);
            } else if (!authCtx.getPermissions().mayCreateWorkspaces()) {
                throw new SecurityException("You may not list users matching that email");
            }
            users = this.service.listUsersWithDisabled_RestrictionCheck_NoLeak(authCtx).stream().map(UsersDAO.User::new).collect(Collectors.toList());
        }
        Multimap<String, String> loginsByEmail = UsersService.buildLoginsByEmailMap(users);
        Collection matchingUsers = loginsByEmail.get((Object)email);
        UsersController.writeJSON((HttpServletResponse)resp, (Object)matchingUsers);
    }

    @AuditedCall(value={"msgType", "security-admin-users-switch-to-trial"})
    @RequestMapping(value={"/api/admin/users/switch-to-trial"})
    public void switchUserToTrial(HttpServletRequest req, HttpServletResponse resp, @RequestParam String login, @RequestParam String userProfile) throws Exception {
        UsersDAO.User user;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(authCtx);
            user = this.usersDAO.getMandatory(login);
            GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            this.generalSettingsService.checkTrialsEnabled(gs, this.licenseService.getLicensingStatus());
        }
        user.userProfile = userProfile;
        logger.info((Object)("Attempting to acquire a trial token for user " + login + " with profile " + userProfile));
        TrialTokenAcquisitionService acquisitionService = (TrialTokenAcquisitionService)SpringUtils.getBean(TrialTokenAcquisitionService.class);
        TrialToken token = acquisitionService.fetchForUser(user);
        logger.info((Object)"Successfully acquired trial token");
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            user = this.usersDAO.getMandatory(login);
            user.userProfile = userProfile;
            user.trialToken = token;
            UserDiff userDiff = this.service.saveUser(user, false, UsersService.UserSaveContext.buildDefaultWithoutPassword(), authCtx);
            this.auditTrailService.generic("security-admin-user-switch-to-trial").with("login", user.login).withAll(userDiff.getDiff()).emit();
            t.commit("Acquired trial token for user " + login);
        }
        this.usersService.sendWelcomeEmail((DkuUser)user);
    }

    @AuditedCall(value={"msgType", "security-admin-users-convert-from-trial"})
    @RequestMapping(value={"/api/admin/users/convert-from-trial"})
    public void convertFromTrial(HttpServletRequest req, HttpServletResponse resp, @RequestParam String login, @RequestParam ConvertFromTrialAction action) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            UsersDAO.User user = this.usersDAO.getOrNull(login);
            if (user == null) {
                throw new IllegalArgumentException("Invalid user");
            }
            if (user.trialToken == null) {
                throw new IllegalArgumentException("User does not have a trial token");
            }
            logger.info((Object)("Converting " + login + " from trial with action " + String.valueOf((Object)action)));
            user.trialToken = null;
            switch (action) {
                case SWITCH_TO_NONE: {
                    user.userProfile = "NONE";
                    break;
                }
                case SWITCH_TO_READER: {
                    if (this.licenseEnforcementService.getUserProfileByNameOrNull("AI_CONSUMER") != null) {
                        user.userProfile = "AI_CONSUMER";
                        break;
                    }
                    user.userProfile = "READER";
                    break;
                }
            }
            this.service.saveUser(user, false, UsersService.UserSaveContext.buildDefaultWithoutPassword(), authCtx);
            t.commit("Converted from trial for user " + login);
        }
    }

    @AuditedCall(value={"msgType", "security-admin-users-list"})
    @RequestMapping(value={"/api/admin/users/list"})
    public void adminList(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="false") boolean lastActivity) throws Exception {
        List<UsersService.UIUser> users;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            users = this.service.listUsers_RestrictionCheck_NoLeak(authCtx, null, true, true);
        }
        if (lastActivity) {
            Map<String, UserLastActivity> allActivity = this.service.getAllUsersActivity(true);
            for (UsersService.UIUser user : users) {
                user.activity = allActivity.getOrDefault(user.login, new UserLastActivity(user.login));
            }
        }
        UsersController.writeJSON((HttpServletResponse)resp, users);
    }

    @AuditedCall(value={"msgType", "security-admin-user-prepare-edit"})
    @RequestMapping(value={"/api/admin/users/prepare-edit"})
    public void prepareEdit(HttpServletRequest req, HttpServletResponse resp, @RequestParam String user) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(u);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
        }
        UsersService.UIUser usr = (UsersService.UIUser)JSON.parse((String)user, UsersService.UIUser.class);
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.prepareEditUser_NT(usr, u));
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/users/edit"})
    public void adminEdit(HttpServletRequest req, HttpServletResponse resp, @RequestParam String user) throws Exception {
        UsersDAO.User oldUser;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            UsersService.UIUser usr = (UsersService.UIUser)JSON.parse((String)user, UsersService.UIUser.class);
            oldUser = this.usersDAO.getOrNull(usr.login);
            PermissionsWatcher pw = this.permissionsWatchersService.startUserWatch(usr.login);
            UserDiff userDiff = this.service.editUserFromUI_NoCheck(usr, authCtx);
            pw.stop();
            t.commit("Edited user " + usr.login);
            this.auditTrailService.generic("security-admin-user-edit").with("user", usr.login).withAll(userDiff.getDiff()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("security-admin-user-edit", (Throwable)e).emit();
            throw e;
        }
        this.usersService.sendWelcomeEmailWhenProfileChange((DkuUser)oldUser);
    }

    @AuditedCall(value={"msgType", "security-admin-user-prepare-assign-groups"})
    @RequestMapping(value={"/api/admin/users/prepare-assign-groups"})
    public void prepareAssignUsersToGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> groupsToAdd, @RequestParam List<String> groupsToRemove, @RequestParam List<String> logins) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(u);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
        }
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.prepareAssignUsersToGroups_NT(logins, groupsToAdd, groupsToRemove, u));
    }

    @AuditedCall(value={"msgType", "security-admin-user-assign-groups", "groupsToAdd", "${groupsToAdd}", "groupsToRemove", "${groupsToRemove}", "users", "${logins}"})
    @RequestMapping(value={"/api/admin/users/assign-groups"})
    public void assignUsersToGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> groupsToAdd, @RequestParam List<String> groupsToRemove, @RequestParam List<String> logins) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            PermissionsWatcher pw = this.permissionsWatchersService.startUserWatch(logins);
            this.service.assignUsersToGroups(logins, groupsToAdd, groupsToRemove, authCtx);
            this.auditTrailService.generic("security-admin-assign-groups").with("users", String.join((CharSequence)",", logins)).with("groups-to-remove", String.join((CharSequence)",", groupsToRemove)).with("groups-to-add", String.join((CharSequence)",", groupsToAdd)).emit();
            pw.stop();
            t.commit("Added users to groups " + String.valueOf(groupsToAdd) + " and removed from groups " + String.valueOf(groupsToRemove));
        }
    }

    @AuditedCall(value={"msgType", "security-admin-assign-profile", "users", "${logins}", "new-profile", "${newProfile}"})
    @RequestMapping(value={"/api/admin/users/assign-profile"}, method={RequestMethod.POST})
    public void assignUsersToProfile(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> logins, @RequestParam String newProfile) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            PermissionsWatcher pw = this.permissionsWatchersService.startUserWatch(logins);
            this.service.assignUsersToProfile(logins, newProfile, authCtx);
            pw.stop();
            t.commit("Assigned users to profile " + newProfile);
        }
    }

    @AuditedCall(value={"msgType", "security-admin-user-get", "user", "${login}"})
    @RequestMapping(value={"/api/admin/users/get"})
    public void adminGet(HttpServletRequest req, HttpServletResponse resp, @RequestParam String login) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.getUserForUI_WithSensitive(login));
        }
    }

    @AuditedCall(value={"msgType", "security-admin-user-list-connection-credentials"})
    @RequestMapping(value={"/api/admin/users/list-connection-credentials"})
    public void adminGetUserConnectionCredentials(HttpServletRequest req, HttpServletResponse resp, @RequestParam String login) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            DSSAuthCtx authCtx = DSSAuthCtx.forUserLogin(this.usersDAO.getMandatory(login));
            UsersController.writeJSON((HttpServletResponse)resp, (Object)this.connectionCredentialsService.getUserCredentials(authCtx));
        }
    }

    @AuditedCall(value={"msgType", "security-admin-user-prepare-delete", "users", "${logins}"})
    @RequestMapping(value={"/api/admin/users/prepare-delete"})
    public void prepareDelete(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> logins) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
        }
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.prepareDeleteUsers_NT(logins, u));
    }

    @AuditedCall(value={"msgType", "security-admin-user-prepare-disable", "user", "${logins}"})
    @RequestMapping(value={"/api/admin/users/prepare-disable"})
    public void prepareDisable(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> logins) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
        }
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.prepareDisableUsers_NT(logins, u));
    }

    @AuditedCall(value={"msgType", "security-admin-user-delete", "users", "${logins}"})
    @RequestMapping(value={"/api/admin/users/delete"})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> logins) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
            this.service.deleteUsersAdmin(logins, u);
            t.commit("Deleted users " + String.valueOf(logins));
        }
    }

    @AuditedCall(value={"msgType", "security-admin-user-enable-disable", "users", "${logins}", "enable", "${enable}"})
    @RequestMapping(value={"/api/admin/users/enable-or-disable"})
    public void enableOrDisable(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> logins, @RequestParam boolean enable) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
            this.service.enableDisableUsersAdmin(logins, u, enable);
            if (!enable) {
                for (String login : logins) {
                    this.sessionsDAO.removeExistingSessionsForUser(login);
                }
            }
            t.commit((enable ? "Enabled" : "Disabled") + " users " + String.valueOf(logins));
        }
    }

    @AuditedCall(value={"msgType", "security-user-start-trial"})
    @RequestMapping(value={"/api/security/start-trial-from-none-user"})
    public void startTrialFromNoneUser(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        GeneralSettingsDAO.GeneralSettings gs;
        UsersDAO.User user;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            user = this.usersDAO.getMandatory(authCtx.getAssociatedDSSUserMand());
            gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            this.generalSettingsService.checkTrialsEnabled(gs, this.licenseService.getLicensingStatus());
        }
        if (!"NONE".equals(user.userProfile)) {
            throw new IllegalArgumentException("You do not have a user profile that can start a trial");
        }
        if (gs.licensingSettings.noneUsersCallToActionBehavior != GeneralSettingsDAO.NoneUsersCallToActionBehavior.ALLOW_START_TRIAL) {
            throw new IllegalArgumentException("You are not allowed to start a trial");
        }
        logger.info((Object)("Attempting to self-acquire a trial token for user " + user.login + " with profile " + gs.licensingSettings.userProfileForTrialsStartedByNoneUsers));
        TrialTokenAcquisitionService acquisitionService = (TrialTokenAcquisitionService)SpringUtils.getBean(TrialTokenAcquisitionService.class);
        user.userProfile = gs.licensingSettings.userProfileForTrialsStartedByNoneUsers;
        TrialToken token = acquisitionService.fetchForUser(user);
        logger.info((Object)"Successfully acquired trial token");
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            user = this.usersDAO.getMandatory(user.login);
            user.userProfile = gs.licensingSettings.userProfileForTrialsStartedByNoneUsers;
            user.trialToken = token;
            UserDiff userDiff = this.service.saveUser(user, false, UsersService.UserSaveContext.buildDefaultWithoutPassword(), authCtx);
            this.auditTrailService.generic("security-admin-user-start-trial").with("login", user.login).withAll(userDiff.getDiff()).emit();
            t.commit("Self-Acquired trial token for user " + user.login);
        }
        this.usersService.sendWelcomeEmail((DkuUser)user);
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/users/sync"})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> syncUsers(HttpServletRequest req, HttpServletResponse resp, final @RequestParam(required=false) List<String> logins) throws Exception {
        AuthCtx admin;
        try (Transaction t = this.transactionService.beginRead();){
            admin = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(admin);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(admin);
        }
        return this.futureService.runFuture(new SimpleFutureThread<InfoMessage.InfoMessages>(admin){

            @Override
            protected InfoMessage.InfoMessages compute() throws Exception {
                return UsersController.this.userAuthenticationService.explicitOnDemandSync(logins);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"syncUsers", (String)"Sync users from external sources");
            }
        }, this.syncUsersFutureWaitTime, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    @AuditedCall(value={"msgType", "security-admin-user-get-syncable-source-types"})
    @RequestMapping(value={"/api/admin/users/get-syncable-source-types"}, method={RequestMethod.GET})
    @ResponseBody
    public Set<String> getSyncableSourceTypes(HttpServletRequest req) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        return this.userAuthenticationService.getOnDemandSyncableSourceTypes();
    }

    @AuditedCall(value={"msgType", "security-admin-user-get-fetchable-source-types"})
    @RequestMapping(value={"/api/admin/users/get-fetchable-source-types"}, method={RequestMethod.GET})
    @ResponseBody
    public Set<String> getFetchableSourceTypes(HttpServletRequest req) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        return this.userAuthenticationService.getFetchableSourceTypes();
    }

    @AuditedCall(value={"msgType", "security-admin-fetch-users"})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/admin/users/fetch"})
    @ResponseBody
    public FutureResponse<FetchedUsersResponse> fetchUsers(HttpServletRequest req, final @RequestParam UserSourceType userSourceType, final @RequestParam UserQueryFilter userQueryFilter) throws Exception {
        AuthCtx admin;
        try (Transaction t = this.transactionService.beginRead();){
            admin = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(admin);
        }
        return this.futureService.runFuture(new SimpleFutureThread<FetchedUsersResponse>(admin){

            @Override
            protected FetchedUsersResponse compute() throws ServerAuthenticationFailure {
                return UsersController.this.userAuthenticationService.fetchUsers(userSourceType, userQueryFilter);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"fetchUsers", (String)"Fetch users from external sources");
            }
        }, this.syncUsersFutureWaitTime, new TypeToken<FutureResponse<FetchedUsersResponse>>(){});
    }

    @AuditedCall(value={"msgType", "security-admin-fetch-groups"})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/admin/groups/fetch"})
    @ResponseBody
    public FutureResponse<List<String>> fetchGroups(HttpServletRequest req, final @RequestParam UserSourceType userSourceType) throws Exception {
        AuthCtx admin;
        try (Transaction t = this.transactionService.beginRead();){
            admin = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(admin);
        }
        return this.futureService.runFuture(new SimpleFutureThread<List<String>>(admin){

            @Override
            protected List<String> compute() throws ServerAuthenticationFailure {
                return UsersController.this.userAuthenticationService.fetchGroups(userSourceType);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"fetchGroups", (String)"Fetch groups from external sources");
            }
        }, this.syncUsersFutureWaitTime, new TypeToken<FutureResponse<List<String>>>(){});
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/users/provision"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> provisionUsers(HttpServletRequest req, final @RequestParam UserSourceType userSourceType, final @RequestParam Set<ExternalUser> users) throws Exception {
        AuthCtx admin;
        try (Transaction t = this.transactionService.beginRead();){
            admin = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(admin);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(admin);
        }
        return this.futureService.runFuture(new SimpleFutureThread<InfoMessage.InfoMessages>(admin){

            @Override
            protected InfoMessage.InfoMessages compute() throws InterruptedException {
                return UsersController.this.userAuthenticationService.provisionUsers(userSourceType, users.stream().filter(e -> e.status == ExternalUser.Status.NOT_PROVISIONED).map(u -> u.userAttributes).collect(Collectors.toSet()));
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"provisionUsers", (String)"Provision users from external sources");
            }
        }, this.syncUsersFutureWaitTime, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    @AuditedCall(value={"msgType", "user-profile-get", "user", "${login}"})
    @RequestMapping(value={"/api/profile/get"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String login, @RequestParam(required=false) boolean includeProfileAndTrialComputation) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx usr = this.authService.getMandatoryUser(req);
            login = StringUtils.isBlank((String)login) ? usr.getAssociatedDSSUserMand() : login;
            UsersService.UIUser user = this.service.getUserForUI_RestrictionCheck_UserSensitive(usr, login, includeProfileAndTrialComputation);
            UsersController.writeJSON((HttpServletResponse)resp, (Object)user);
        }
    }

    @AuditedCall(value={"msgType", "user-profile-get-achievements", "user", "${login}"})
    @RequestMapping(value={"/api/profile/achievements"})
    public void achievements(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String login) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            login = StringUtils.isBlank((String)login) ? user.getAssociatedDSSUserMand() : login;
            UsersController.writeJSON((HttpServletResponse)resp, (Object)this.achievementService.getforUser(login));
        }
    }

    @AuditedCall(value={"msgType", "user-profile-achievements-disable"})
    @RequestMapping(value={"/api/admin/achievements/disable"})
    public void disableAchievements(HttpServletRequest req, HttpServletResponse resp, @RequestParam boolean isDisabled) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
            this.authService.failIfNotAdmin(req);
            GeneralSettingsDAO.GeneralSettings settings = this.generalSettingsService.read();
            settings.achievementsDisabled = isDisabled;
            this.generalSettingsService.save(t.getUser(), settings);
            t.commit("Changed achievements status in general settings");
        }
        UsersController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditInline
    @RequestMapping(value={"/api/myprofile/edit"})
    public void userEdit(HttpServletRequest req, HttpServletResponse resp, @RequestParam String user) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx ls = this.authService.getMandatoryUser(req);
            UsersService.UIUser usr = (UsersService.UIUser)JSON.parse((String)user, UsersService.UIUser.class);
            if (!ls.getAssociatedDSSUserMand().equals(usr.login)) {
                throw new DKUSecurityException("You're trying to edit the profile of someone else, aren't you? :)");
            }
            PermissionsWatcher pw = this.permissionsWatchersService.startUserWatch(usr.login);
            UserDiff userDiff = this.service.editUserFromUI_PasswordCheck_AllowedFieldsOnly(usr, ls);
            pw.stop();
            t.commit("Edited user profile");
            this.auditTrailService.generic("user-profile-edit").with("login", usr.getLogin()).withAll(userDiff.getDiff()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("user-profile-edit", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "user-profile-update-questionnaire"})
    @RequestMapping(value={"/api/myprofile/update-questionnaire"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateQuestionnaire(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="questionnaire") String questionnaire) throws Exception {
        OnboardingQuestionnaire parsedQuestionnaire = (OnboardingQuestionnaire)JSON.parse((String)questionnaire, OnboardingQuestionnaire.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            String login = u.getAssociatedDSSUserMand();
            UsersDAO.User user = this.usersDAO.getMandatory(login);
            user.questionnaire = parsedQuestionnaire;
            UsersService.UserSaveContext usc = UsersService.UserSaveContext.buildDefaultWithoutPassword();
            this.service.saveUser(user, false, usc, u);
            t.commit("Saved questionnaire for user " + login);
        }
    }

    @AuditedCall(value={"msgType", "user-profile-get-questionnaire"})
    @RequestMapping(value={"/api/myprofile/get-questionnaire"}, method={RequestMethod.GET})
    public void getQuestionnaire(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            String login = u.getAssociatedDSSUserMand();
            UsersDAO.User user = this.usersDAO.getMandatory(login);
            UsersController.writeJSON((HttpServletResponse)resp, (Object)user.questionnaire);
        }
    }

    @AuditedCall(value={"msgType", "user-profile-set-settings"})
    @RequestMapping(value={"/api/myprofile/set-user-settings"})
    @ResponseStatus(value=HttpStatus.OK)
    public void setUserSettings(HttpServletRequest req, @RequestParam(value="userSettingsAsString") UserSettingsService.UserSettings userSettings) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx ls = this.authService.getMandatoryUser(req);
            this.userSettingsService.setUserSettings(ls, userSettings);
            t.commit("Edited user settings");
        }
    }

    @AuditedCall(value={"msgType", "user-profile-update-nps-settings"})
    @RequestMapping(value={"/api/myprofile/update-nps-settings"}, method={RequestMethod.POST})
    public void setNPSSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String action) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            NPSSurveyService.NPSSurveySettings newSettings;
            AuthCtx u = this.authService.getMandatoryUser(req);
            String login = u.getAssociatedDSSUserMand();
            UsersDAO.User user = this.usersDAO.getMandatory(login);
            user.npsSurveySettings = newSettings = this.npsSurveyService.getNextSetting(user.npsSurveySettings, NPSSurveyService.NPSSurveyAction.valueOf(action));
            user.atSurveySettings = this.atSurveyService.getNextSettingsAfterNPSSurvey(user.atSurveySettings);
            UsersService.UserSaveContext usc = UsersService.UserSaveContext.buildDefaultWithoutPassword();
            this.service.saveUser(user, false, usc, u);
            t.commit("Edited user profile");
            UsersController.writeJSON((HttpServletResponse)resp, (Object)newSettings);
        }
    }

    @AuditedCall(value={"msgType", "user-profile-update-nps-settings-test"})
    @RequestMapping(value={"/api/myprofile/update-nps-settings-test/"}, method={RequestMethod.POST})
    public void setNPSFullSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String state, @RequestParam long nextAction) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            NPSSurveyService.NPSSurveySettings newSettings;
            AuthCtx u = this.authService.getMandatoryUser(req);
            String login = u.getAssociatedDSSUserMand();
            UsersDAO.User user = this.usersDAO.getMandatory(login);
            this.authService.failIfNotAdmin(u);
            user.npsSurveySettings = newSettings = new NPSSurveyService.NPSSurveySettings(NPSSurveyService.NPSSurveyState.valueOf(state), nextAction);
            user.atSurveySettings = this.atSurveyService.getNextSettingsAfterNPSSurvey(user.atSurveySettings);
            UsersService.UserSaveContext usc = UsersService.UserSaveContext.buildDefaultWithoutPassword();
            this.service.saveUser(user, false, usc, u);
            t.commit("Edited user profile");
            UsersController.writeJSON((HttpServletResponse)resp, (Object)newSettings);
        }
    }

    @AuditedCall(value={"msgType", "alert-banner-dismissed", "bannerId", "${bannerId}"})
    @RequestMapping(value={"/api/myprofile/notify-alert-banner-dismissed"}, method={RequestMethod.POST})
    public void dismissAlertBanner(HttpServletRequest req, HttpServletResponse resp, @RequestParam String bannerId) throws Exception {
    }

    @AuditedCall(value={"msgType", "user-profile-update-ats-settings"})
    @RequestMapping(value={"/api/myprofile/update-ats-settings"}, method={RequestMethod.POST})
    public void setATSSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String event, @RequestParam String action) throws Exception {
        ATSurveyService.ATSurveySettings newAtSurveySettings;
        ATSurveyService.ATSurveyAction surveyAction = ATSurveyService.ATSurveyAction.valueOf(action);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            String login = u.getAssociatedDSSUserMand();
            UsersDAO.User user = this.usersDAO.getMandatory(login);
            user.atSurveySettings = newAtSurveySettings = this.atSurveyService.getNextSettings(user.atSurveySettings, surveyAction, event);
            user.npsSurveySettings = this.npsSurveyService.getNextSettingAfterATSurvey(user.npsSurveySettings);
            UsersService.UserSaveContext usc = UsersService.UserSaveContext.buildDefaultWithoutPassword();
            this.service.saveUser(user, false, usc, u);
            t.commit("Edited user profile");
        }
        UsersController.writeJSON((HttpServletResponse)resp, (Object)newAtSurveySettings);
    }

    @AuditedCall(value={"msgType", "user-profile-update-page-specific-tour-settings"})
    @RequestMapping(value={"/api/myprofile/update-page-specific-tour-settings"}, method={RequestMethod.POST})
    public void updatePageSpecificTourSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam PageSpecificTourSettings pageSpecificTourSettings) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            String login = u.getAssociatedDSSUserMand();
            UsersDAO.User user = this.usersDAO.getMandatory(login);
            user.pageSpecificTourSettings = pageSpecificTourSettings;
            this.service.saveUser(user, false, UsersService.UserSaveContext.buildDefaultWithoutPassword(), u);
            t.commit("Updated page specific tour settings");
        }
        UsersController.writeJSON((HttpServletResponse)resp, (Object)pageSpecificTourSettings);
    }

    @AuditedCall(value={"msgType", "user-profile-list-connection-credentials"})
    @RequestMapping(value={"/api/myprofile/list-connection-credentials"})
    public void getMyConnectionCredentials(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            UsersController.writeJSON((HttpServletResponse)resp, (Object)this.connectionCredentialsService.getUserCredentials(authCtx));
        }
    }

    @AuditedCall(value={"msgType", "user-profile-set-connection-credential", "connection", "${connection}"})
    @RequestMapping(value={"/api/myprofile/set-basic-connection-credential"})
    public void setMyConnectionCredential(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connection, @RequestParam(required=false) String user, @RequestParam(required=false) String password) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.licenseEnforcementService.checkReadProjectContentAllowed(t.getUser());
            this.connectionCredentialsService.storeUserCredentialForConnection(t.getUser(), connection, user, password);
            t.commit("Stored connection credential for " + String.valueOf(t.getUser()));
        }
    }

    @AuditedCall(value={"msgType", "user-profile-set-connection-credential", "connection", "${connection}"})
    @RequestMapping(value={"/api/myprofile/connection-credentials/azure-oauth-devicecode-dance-step1"})
    public void startAzureDeviceCodeDanceStep1(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
        }
        ConnectionCredentialsCRUDService.OAuth2AuthorizationRequestInfo authorizationRequestInfo = (ConnectionCredentialsCRUDService.OAuth2AuthorizationRequestInfo)this.getRequestBodyAsOrNull(req, ConnectionCredentialsCRUDService.OAuth2AuthorizationRequestInfo.class);
        authorizationRequestInfo.userIdentifier = authCtx.getIdentifier();
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.connectionCredentialsService.runAzureOAuthDeviceCodeDanceStep1_NT(authCtx, authorizationRequestInfo));
    }

    @AuditedCall(value={"msgType", "user-profile-set-connection-credential", "connection", "${connection}"})
    @RequestMapping(value={"/api/myprofile/connection-credentials/azure-oauth-devicecode-dance-step2"})
    public void startAzureDeviceCodeDanceStep2(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
        }
        ConnectionCredentialsCRUDService.OAuth2AuthorizationRequestInfo authorizationRequestInfo = (ConnectionCredentialsCRUDService.OAuth2AuthorizationRequestInfo)this.getRequestBodyAsOrNull(req, ConnectionCredentialsCRUDService.OAuth2AuthorizationRequestInfo.class);
        authorizationRequestInfo.userIdentifier = authCtx.getIdentifier();
        this.connectionCredentialsService.runAzureOAuthDeviceCodeDanceStep2_NT(authCtx, authorizationRequestInfo);
    }

    @AuditedCall(value={"msgType", "user-profile-set-plugin-credential", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/myprofile/plugin-credentials/set-basic-credential"})
    public void setBasicPluginCredential(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String paramSetId, @RequestParam String presetId, @RequestParam String paramName, @RequestParam(required=false) String user, @RequestParam(required=false) String password) throws Exception {
        PluginCredentialRequestService.PluginCredentialRequestInfo credentialRequestInfo = new PluginCredentialRequestService.PluginCredentialRequestInfo();
        credentialRequestInfo.pluginId = pluginId;
        credentialRequestInfo.paramSetId = paramSetId;
        credentialRequestInfo.presetId = presetId;
        credentialRequestInfo.paramName = paramName;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.licenseEnforcementService.checkReadProjectContentAllowed(t.getUser());
            this.connectionCredentialsService.storeUserCredentialForPlugin(t.getUser(), credentialRequestInfo, user, password);
            t.commit("Stored plugin credential for " + String.valueOf(t.getUser()));
        }
    }

    @AuditedCall(value={"msgType", "user-profile-set-plugin-credential", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/myprofile/start-oauth2-authorization-flow"}, method={RequestMethod.POST})
    public void startOAuth2AuthorizationFlow(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
        }
        ConnectionCredentialsCRUDService.OAuth2AuthorizationRequestInfo authorizationRequestInfo = (ConnectionCredentialsCRUDService.OAuth2AuthorizationRequestInfo)this.getRequestBodyAsOrNull(req, ConnectionCredentialsCRUDService.OAuth2AuthorizationRequestInfo.class);
        authorizationRequestInfo.userIdentifier = authCtx.getIdentifier();
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.connectionCredentialsService.getOAuth2AuthorizationEndpoint(resp, authCtx, authorizationRequestInfo));
    }

    @Deprecated
    @RequestMapping(value={"/api/oauth2-callback"}, method={RequestMethod.GET})
    public RedirectView oauth2Callback(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String code, @RequestParam String state, @RequestParam(required=false) String error, @RequestParam(value="error_description", required=false) String errorDescription, @RequestParam(value="error_uri", required=false) String errorUri) throws Exception {
        return this.redirect("/oauth2-callback?" + URLEncodedUtils.format((Iterable)Stream.of(new BasicNameValuePair("code", code), new BasicNameValuePair("state", state), new BasicNameValuePair("error", error), new BasicNameValuePair("error_description", errorDescription), new BasicNameValuePair("error_uri", errorUri)).filter(n -> StringUtils.isNotBlank((String)n.getValue())).collect(Collectors.toList()), (Charset)StandardCharsets.UTF_8));
    }

    @RequestMapping(value={"/api/myprofile/oauth2-callback"}, method={RequestMethod.POST})
    public void callback(HttpServletRequest req, HttpServletResponse resp, @RequestParam String state, @RequestParam(required=false) String code, @RequestParam(required=false) String error, @RequestParam(value="error_description", required=false) String errorDescription, @RequestParam(value="error_uri", required=false) String errorUri) throws Exception {
        String refreshToken;
        OAuth2Client oAuth2Client;
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
        }
        logger.info((Object)("Handling OAuth2 authorization code grant redirect response for user " + authCtx.getIdentifier()));
        ConnectionCredentialsCRUDService.OAuth2AuthorizationRequestInfo authorizationRequestInfo = this.connectionCredentialsService.confirmOAuth2State(state);
        if (authorizationRequestInfo == null) {
            UsersController.writeJSON((HttpServletResponse)resp, (Object)OAuth2CallbackResponse.error(null, OAuth2CallbackResponse.ErrorSource.DSS, "no_dss_state", "The state '" + state + "' doesn't match a valid state. Perhaps this state was already consumed and deleted from the in progress requests"));
            return;
        }
        logger.info((Object)("The original authorization request info behind the state '" + state + "' : " + String.valueOf(authorizationRequestInfo)));
        try {
            oAuth2Client = this.connectionCredentialsService.getOAuth2Client(authCtx, authorizationRequestInfo);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to obtain OAuth2 client", (Throwable)e);
            UsersController.writeJSON((HttpServletResponse)resp, (Object)OAuth2CallbackResponse.error(authorizationRequestInfo, OAuth2CallbackResponse.ErrorSource.DSS, "invalid_oauth2_client", e.getMessage()));
            return;
        }
        Optional<String> codeVerifier = this.authService.getCodeVerifierFromCookie(req);
        if (oAuth2Client.usePkce()) {
            if (codeVerifier.isEmpty()) {
                logger.error((Object)"Couldn't exchange the authorization code, the PKCE code verifier is missing.");
                UsersController.writeJSON((HttpServletResponse)resp, (Object)OAuth2CallbackResponse.error(authorizationRequestInfo, OAuth2CallbackResponse.ErrorSource.DSS, "no_pkce", "Couldn't exchange the authorization code, the PKCE code verifier is missing."));
                return;
            }
            this.authService.deletePKCECodeVerifierCookie(resp);
        }
        if (!authorizationRequestInfo.userIdentifier.equals(authCtx.getIdentifier())) {
            logger.error((Object)("The user '" + authCtx.getIdentifier() + "' has somehow ended up with the authorization code for user '" + authorizationRequestInfo.userIdentifier + "'.Double check how this situation happened as this could be an indicator of user '" + authCtx.getIdentifier() + "' trying to hack access of other users' data"));
            UsersController.writeJSON((HttpServletResponse)resp, (Object)OAuth2CallbackResponse.error(authorizationRequestInfo, OAuth2CallbackResponse.ErrorSource.DSS, "invalid_user", "The original authorization request was triggered from a different user"));
            return;
        }
        if (StringUtils.isNotBlank((String)error)) {
            logger.warn((Object)("OAuth2 server returned an error when trying to authorize request: " + error + " - " + errorDescription));
            if (StringUtils.isNotBlank((String)errorUri)) {
                logger.warn((Object)("OAuth2 response error_uri is: " + errorUri));
            }
            UsersController.writeJSON((HttpServletResponse)resp, (Object)OAuth2CallbackResponse.error(authorizationRequestInfo, OAuth2CallbackResponse.ErrorSource.AUTH_SERVER, error, errorDescription, errorUri));
            return;
        }
        if (StringUtils.isBlank((String)code)) {
            logger.error((Object)"OAuth2 server returned no error but also no authorization code");
            UsersController.writeJSON((HttpServletResponse)resp, (Object)OAuth2CallbackResponse.error(authorizationRequestInfo, OAuth2CallbackResponse.ErrorSource.AUTH_SERVER, "no_authorization_code", "The third party did not return an error but also no authorization code, required to complete the OAuth2 flow."));
            return;
        }
        logger.info((Object)"The authorization server successfully returned an authorization code");
        try {
            refreshToken = oAuth2Client.acquireRefreshTokenFromAuthorizationCode(code, this.connectionCredentialsService.buildCallbackEndpoint(authorizationRequestInfo.dssProtocolHost), codeVerifier.orElse(null));
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to obtain tokens from authorization code", (Throwable)e);
            UsersController.writeJSON((HttpServletResponse)resp, (Object)OAuth2CallbackResponse.error(authorizationRequestInfo, OAuth2CallbackResponse.ErrorSource.DSS, "exchange_code", e.getMessage()));
            return;
        }
        logger.info((Object)"Successfully exchanged the authorization code for a refresh token.");
        try {
            this.connectionCredentialsService.storeOAuth2RefreshToken_NT(authCtx, refreshToken, authorizationRequestInfo.getCredentialKey());
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to store refresh token", (Throwable)e);
            UsersController.writeJSON((HttpServletResponse)resp, (Object)OAuth2CallbackResponse.error(authorizationRequestInfo, OAuth2CallbackResponse.ErrorSource.DSS, "refresh_token_store", e.getMessage()));
            return;
        }
        logger.info((Object)("OAuth2 flow completed for user " + authCtx.getIdentifier()));
        UsersController.writeJSON((HttpServletResponse)resp, (Object)OAuth2CallbackResponse.success(authorizationRequestInfo));
    }

    @AuditedCall(value={"msgType", "user-profile-dismiss-whats-new-popover"})
    @RequestMapping(value={"/api/myprofile/dismiss-whats-new-popover"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void dismissWhatsNewPopover(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="popoverId") String popoverId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.userSettingsService.dismissWhatsNewPopover(authCtx, popoverId);
            Set<String> dismissedPopovers = this.userSettingsService.getForUser((String)authCtx.getIdentifier()).customDisplaySettings.dismissedPopovers;
            UsersController.writeJSON((HttpServletResponse)resp, dismissedPopovers);
            t.commit("Dismissed what's new popover");
        }
    }

    @AuditedCall(value={"msgType", "toggle-connection-type-pinned", "datasetType", "${datasetType}"})
    @RequestMapping(value={"/api/myprofile/toggle-pinned-connection-type"})
    @ResponseStatus(value=HttpStatus.OK)
    public void togglePinConnectionType(HttpServletRequest req, HttpServletResponse resp, @RequestParam String datasetType) throws Exception {
        List<String> pinnedItemsList;
        try (RWTransaction tr = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            pinnedItemsList = this.userSettingsService.toggleUserPinnedConnectionType(authCtx, datasetType);
        }
        UsersController.writeJSON((HttpServletResponse)resp, pinnedItemsList);
    }

    @AuditedCall(value={"msgType", "get-connection-types-pinned"})
    @RequestMapping(value={"/api/myprofile/get-pinned-connection-types"})
    @ResponseStatus(value=HttpStatus.OK)
    public void getPinnedConnectionTypes(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<String> pinnedItemsList;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            pinnedItemsList = this.userSettingsService.getUserPinnedConnectionTypes(authCtx);
        }
        UsersController.writeJSON((HttpServletResponse)resp, pinnedItemsList);
    }

    private RedirectView redirect(String relativePath) {
        RedirectView redirect = new RedirectView();
        redirect.setHttp10Compatible(false);
        redirect.setUrl(relativePath);
        return redirect;
    }

    public static enum ConvertFromTrialAction {
        SWITCH_TO_NONE,
        SWITCH_TO_REGULAR,
        SWITCH_TO_READER;

    }
}

