/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.p;

import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PubSubIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private SharedSecretAuthService authService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.intercom.pubsub");

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/pubsub/publish"})
    public void publish(HttpServletRequest req, HttpServletResponse resp, @RequestParam String message) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        WrappedMessage wm = (WrappedMessage)JSON.parse((String)message, WrappedMessage.class);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received a wrapped pubsub message: " + message));
        }
        DSSEvent event = (DSSEvent)JSON.parse((JsonElement)wm.payload, Class.forName(wm.clazz).asSubclass(DSSEvent.class));
        this.pubSubService.publish(event);
    }

    public static class WrappedMessage {
        public String clazz;
        public JsonObject payload;
    }
}

