/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.threads.BaseProgressingWorkThread;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class FutureIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private FutureService futureService;
    @Autowired
    private TicketAuthService authService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.futureController");

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/futures/get-update"})
    public void getUpdateIntercom(HttpServletRequest req, HttpServletResponse resp, String futureId) throws Exception {
        APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);
        if (tu != null) {
            tu.close();
        }
        FutureResponse update = this.futureService.getUpdate(futureId);
        FutureIntercomController.writeJSON((HttpServletResponse)resp, (Object)update);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/futures/set-percentage"})
    public void setPercentage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String futureId, @RequestParam double percentage) throws Exception {
        this.authService.getAndUseMandTicket(req).close();
        BaseProgressingWorkThread future = (BaseProgressingWorkThread)this.futureService.getThread(futureId);
        future.setPercentage(percentage);
        FutureResponse update = this.futureService.getUpdate(futureId);
        FutureIntercomController.writeJSON((HttpServletResponse)resp, (Object)update);
    }
}

