/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.requestcenter.Request;
import com.dataiku.dip.server.notifications.backend.AbstractRequestEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.timelines.EnrichmentService;
import java.util.Optional;

public abstract class AbstractAccessRequestEvent
extends AbstractRequestEvent
implements EnrichmentService.Enrichable {
    private final Request request;
    private final String projectKey;

    protected AbstractAccessRequestEvent(Request request) {
        super(request);
        this.request = request;
        this.projectKey = request.objectProjectKey;
    }

    public Request.RequestType getRequestType() {
        return this.request.requestType;
    }

    public Request getRequest() {
        return this.request;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    public String getRequestId() {
        return this.request.requestId;
    }

    public String getMessage() {
        return this.request.requestMessage;
    }

    @Override
    public String getUserLogin() {
        return this.request.requesterLogin;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return Optional.ofNullable(this.request.objectType).flatMap(Request.RequestObjectType::toTaggableType).orElse(null);
    }

    @Override
    public String getWorkspaceKey() {
        return this.request.objectWorkspaceKey;
    }

    public String getTargetProjectKey() {
        if (!this.request.requestType.isSharingRequest()) {
            return null;
        }
        return ((Request.ObjectSharingRequestDetails)this.request.requestDetails).sharingTargetProject;
    }
}

