/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.EventWithSeverity;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;

public class JobDoneEvent
extends BackendEvent
implements UserEvent,
ProjectEvent,
EventWithSeverity,
EventWithHumanReadableString {
    public static final String NAME = "job-done";
    public final AuthCtx authCtx;
    public final JobDef jobDef;
    public final SerializedJobStatus status;

    public JobDoneEvent(AuthCtx authCtx, JobDef jobDef, SerializedJobStatus status) {
        this.authCtx = authCtx;
        this.jobDef = jobDef;
        this.status = status;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getProjectKey() {
        return this.jobDef.projectKey;
    }

    @Override
    public String getUserLogin() {
        return this.jobDef.initiator;
    }

    @Override
    public EventWithSeverity.EventSeverity getSeverity() {
        switch (this.status.state) {
            case ABORTED: 
            case FAILED: {
                return EventWithSeverity.EventSeverity.ERROR;
            }
            case DONE: {
                return EventWithSeverity.EventSeverity.OK;
            }
        }
        return EventWithSeverity.EventSeverity.NEUTRAL;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        return String.format("Job done: %s. State: %s", markup.job(this.jobDef.projectKey, this.jobDef.id, this.jobDef.toHumanReadableString()), markup.text((Object)this.status.state));
    }
}

