/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.discussions.Discussion;
import com.dataiku.dip.discussions.DiscussionsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.WorkspacePermissionsService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.EmailNotificationsSender;
import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.MarkupFormattersService;
import com.dataiku.dip.server.notifications.NoLinkMarkupFormatter;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.backend.DiscussionReplyEvent;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.notifications.markups.Markup;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DiscussionsEmailService {
    @Autowired
    private MarkupFormattersService linksService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService permService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private DiscussionsService discussionsService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private WorkspacePermissionsService workspacePermissionsService;
    private static Logger logger = Logger.getLogger((String)"dku.notifications.discussions");

    @PostConstruct
    public void init() {
        this.pubSubService.subscribe("discussion-reply", (DSSEventListener)new DSSEventListener<DiscussionReplyEvent>(){

            public void on(DiscussionReplyEvent evt) throws IOException {
                Map<String, UserSettingsService.UserSettings> usersSettings;
                UserSettingsService.UserSettings defaultUserSettings = new UserSettingsService.UserSettings();
                HashSet<String> mentionedUsersWithEmailsEnabled = new HashSet<String>();
                try (Transaction t = DiscussionsEmailService.this.transactionService.beginRead();){
                    usersSettings = DiscussionsEmailService.this.userSettingsService.getForAllUsers();
                    for (String mentionedUser : DiscussionsEmailService.this.usersService.getMentions(evt.text)) {
                        if (mentionedUser.equals(evt.user) || !DiscussionsEmailService.this.isAuthorised(mentionedUser, evt.projectKey, evt.workspaceKey) || !usersSettings.getOrDefault((Object)mentionedUser, (UserSettingsService.UserSettings)defaultUserSettings).mentionEmails.enabled) continue;
                        mentionedUsersWithEmailsEnabled.add(mentionedUser);
                    }
                }
                Set<String> watchingUsers = DiscussionsEmailService.this.interestsService.getEffectiveWatchingUsers_NT(evt.objectType, evt.projectKey, evt.objectId, evt.user, evt.workspaceKey);
                Sets.SetView notMentionedUsers = Sets.difference(watchingUsers, mentionedUsersWithEmailsEnabled);
                HashSet<String> notMentionedUsersWithEmailsEnabled = new HashSet<String>(notMentionedUsers.size());
                for (String user : notMentionedUsers) {
                    if (!usersSettings.getOrDefault((Object)user, (UserSettingsService.UserSettings)defaultUserSettings).discussionEmails.enabled) continue;
                    notMentionedUsersWithEmailsEnabled.add(user);
                }
                for (String toUser : mentionedUsersWithEmailsEnabled) {
                    try {
                        DiscussionsEmailService.this.sendToUser(evt, toUser, true);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to send email to " + toUser + " for mention"), (Throwable)e);
                    }
                }
                for (String toUser : notMentionedUsersWithEmailsEnabled) {
                    try {
                        DiscussionsEmailService.this.sendToUser(evt, toUser, false);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to send email to " + toUser + " (watching discussion)"), (Throwable)e);
                    }
                }
            }
        });
    }

    private boolean isAuthorised(String user, @Nullable String projectKey, @Nullable String workspaceKey) {
        try {
            AuthCtx authCtx = this.authCtxCreationService.create(user);
            if (StringUtils.isNotBlank((String)projectKey)) {
                return this.permService.hasAnyProjectAccess(authCtx, projectKey);
            }
            if (StringUtils.isNotBlank((String)workspaceKey)) {
                return this.workspacePermissionsService.hasWorkspacePrivileges(authCtx, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.READ);
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get user permissions", (Throwable)e);
            return false;
        }
    }

    private void sendToUser(DiscussionReplyEvent evt, String user, boolean mentioned) throws Exception {
        PublicUser dstUser;
        PublicUser srcUser;
        Discussion discussion = this.discussionsService.getDiscussion(evt.projectKey, evt.workspaceKey, evt.discussionId);
        try (Transaction t = this.transactionService.beginRead();){
            srcUser = this.usersService.getPublicUser(evt.user);
            dstUser = this.usersService.getPublicUser(user);
            this.discussionsService.enrich(discussion);
        }
        UserSettingsService.EmailNotificationsSettings params = new UserSettingsService.EmailNotificationsSettings();
        params.enabled = true;
        if (dstUser.email == null) {
            return;
        }
        logger.info((Object)("Sending mention email to " + dstUser.login));
        params.subject = "Dataiku \u2022 " + this.getEmailTitle(evt, srcUser, dstUser, mentioned, discussion, new NoLinkMarkupFormatter(Markup.PLAIN_TEXT, new ArrayList<UsersDAO.User>()));
        String body = this.makeBody(evt, srcUser, dstUser, mentioned, discussion);
        EmailNotificationsSender sender = new EmailNotificationsSender();
        sender.sendToUser(dstUser.email, params, body);
    }

    private String getEmailTitle(DiscussionReplyEvent evt, PublicUser srcUser, PublicUser dstUser, boolean mentioned, Discussion discussion, MarkupFormatter links) {
        String action = mentioned ? " mentioned you in a discussion" : (discussion.hasRepliesFrom(dstUser.login) ? " replied to your comment" : " added a comment");
        String objectType = evt.objectType.toHumanReadableString();
        String objectLabel = discussion.objectDisplayName != null ? discussion.objectDisplayName : discussion.objectId;
        return String.format("%s%s on %s %s", links.user(srcUser.login, srcUser.displayName), action, objectType, links.dssOrWorkspaceObject(discussion.objectType, discussion.projectKey, evt.objectId, evt.workspaceKey, objectLabel, discussion.id));
    }

    private String makeBody(DiscussionReplyEvent evt, PublicUser srcUser, PublicUser dstUser, boolean mentioned, Discussion discussion) throws Exception {
        File templateFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"notifications", "discussion-mention.ftl"});
        TemplatedContent templatedContent = new TemplatedContent();
        MarkupFormatter links = this.linksService.getMarkupFormatter(Markup.HTML);
        VariableLookup lookup = new VariableLookup();
        Object intro = this.getEmailTitle(evt, srcUser, dstUser, mentioned, discussion, links);
        if (StringUtils.isBlank((String)evt.workspaceKey)) {
            String projectLabel = evt.details.has("projectDisplayName") ? evt.details.get("projectDisplayName").getAsString() : evt.projectKey;
            intro = (String)intro + " (Project " + links.project(evt.projectKey, projectLabel) + ")";
        } else if (!ITaggingService.TaggableType.WORKSPACE.equals((Object)evt.objectType)) {
            String workspaceLabel = evt.details.has("workspaceDisplayName") ? evt.details.get("workspaceDisplayName").getAsString() : evt.workspaceKey;
            intro = (String)intro + " (Workspace " + links.workspace(evt.workspaceKey, workspaceLabel) + ")";
        }
        lookup.addVariable("username", dstUser.displayName);
        lookup.addVariable("title", "");
        lookup.addVariable("intro", intro);
        lookup.addVariable("message", evt.getMessage());
        lookup.addVariable("discussion", discussion);
        try (Transaction t = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings settings = this.generalSettingsService.read();
            lookup.addVariable("studioExternalUrl", settings.studioExternalUrl);
            lookup.addVariable("dssInstanceName", settings.nodeName);
        }
        MessageContentBuilder.ExpandedTemplate expandedTemplate = new MessageContentBuilder(lookup).buildMessage(templatedContent, templateFile);
        return expandedTemplate.message;
    }
}

