/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.samples;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.samples.SnippetOrigin;
import com.dataiku.dip.server.samples.SnippetType;
import com.dataiku.dip.server.samples.SnippetsDAO;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedSnippetsDAO
implements SnippetsDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.snippets.dao");

    private String getVariationFileName(SnippetsDAO.SnippetVariation variation, SnippetType snippetType) {
        if (snippetType == SnippetType.WEBAPP_STANDARD || snippetType == SnippetType.WEBAPP_BOKEH || snippetType == SnippetType.WEBAPP_DASH || snippetType == SnippetType.WEBAPP_SHINY) {
            return variation.title + "." + variation.id;
        }
        return variation.id + "." + snippetType.getExtension();
    }

    private SnippetsDAO.Snippet readSnippet(RelFile folder, SnippetType snippetType, SnippetOrigin snippetOrigin) throws IOException {
        RelFile variationsFolder;
        RelFile documentationFile;
        TransactionRef tr = TransactionContext.retrieveRead();
        SnippetsDAO.Snippet snippet = (SnippetsDAO.Snippet)tr.readObjectUnsafe(folder.append(new String[]{"meta.json"}), SnippetsDAO.Snippet.class);
        snippet.id = folder.getLeafName();
        RelFile descriptionFile = folder.append(new String[]{"description.md"});
        if (tr.isFile(descriptionFile)) {
            snippet.description = tr.readStringUTF8(descriptionFile);
        }
        if (tr.isFile(documentationFile = folder.append(new String[]{"documentation.md"}))) {
            snippet.documentation = tr.readStringUTF8(documentationFile);
        }
        if (tr.isDirectory(variationsFolder = folder.append(new String[]{"variations"}))) {
            for (SnippetsDAO.SnippetVariation snippetVariation : snippet.variations) {
                String fileName = this.getVariationFileName(snippetVariation, snippetType);
                RelFile variationFile = variationsFolder.append(new String[]{fileName});
                if (!tr.isFile(variationFile)) continue;
                snippetVariation.code = tr.readStringUTF8(variationFile);
            }
        }
        snippet.origin = snippetOrigin;
        return snippet;
    }

    private SnippetsDAO.Snippet readSnippet(File folder, SnippetType snippetType, SnippetOrigin snippetOrigin) throws IOException {
        File variationsFolder;
        SnippetsDAO.Snippet snippet = (SnippetsDAO.Snippet)JSON.parseFile((File)new File(folder, "meta.json"), SnippetsDAO.Snippet.class);
        snippet.id = folder.getName();
        if (new File(folder, "description.md").isFile()) {
            snippet.description = DKUFileUtils.readFileToStringUTF8((File)new File(folder, "description.md"));
        }
        if (new File(folder, "documentation.md").isFile()) {
            snippet.documentation = DKUFileUtils.readFileToStringUTF8((File)new File(folder, "documentation.md"));
        }
        if ((variationsFolder = new File(folder, "variations")).isDirectory()) {
            for (SnippetsDAO.SnippetVariation snippetVariation : snippet.variations) {
                String fileName = this.getVariationFileName(snippetVariation, snippetType);
                File variationFile = new File(variationsFolder, fileName);
                if (!variationFile.isFile()) continue;
                snippetVariation.code = DKUFileUtils.readFileToStringUTF8((File)variationFile);
            }
        }
        snippet.origin = snippetOrigin;
        return snippet;
    }

    @Override
    public List<SnippetsDAO.Snippet> list(String snippetType, AuthCtx user) throws IOException {
        SnippetType type = SnippetType.getSnippetTypeByName(snippetType);
        logger.info((Object)("Looking for snippets of type " + snippetType));
        TransactionRef tr = TransactionContext.retrieveRead();
        ArrayList<SnippetsDAO.Snippet> list = new ArrayList<SnippetsDAO.Snippet>();
        RelFile customSnippetFolders = new RelFile(new String[]{"code-snippets", type.getName()});
        logger.trace((Object)("Checking folder " + String.valueOf(customSnippetFolders)));
        if (tr.isDirectory(customSnippetFolders)) {
            for (RelFile snippetFolder : tr.listFiles(customSnippetFolders)) {
                logger.trace((Object)("Reading snippet " + String.valueOf(snippetFolder)));
                try {
                    SnippetsDAO.Snippet snippet = this.readSnippet(snippetFolder, type, SnippetOrigin.CUSTOM);
                    if (!snippet.isShared && !snippet.userCreation.equals(user.getIdentifier())) continue;
                    list.add(snippet);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to read code snippet from " + String.valueOf(snippetFolder)), (Throwable)e);
                }
            }
        }
        for (String builtinFolderName : type.getAllReadFolders()) {
            File builtInSnippetFolder = ApplicationConfigurator.getResourceFile((String)("builtin-snippets/" + builtinFolderName));
            logger.trace((Object)("Checking folder " + String.valueOf(builtInSnippetFolder)));
            if (!builtInSnippetFolder.isDirectory()) continue;
            for (File snippetFolder : builtInSnippetFolder.listFiles()) {
                logger.trace((Object)("Reading snippet " + String.valueOf(snippetFolder)));
                if (!snippetFolder.isDirectory()) continue;
                try {
                    list.add(this.readSnippet(snippetFolder, type, SnippetOrigin.BUILTIN));
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to read code sample from " + String.valueOf(snippetFolder)), (Throwable)e);
                }
            }
        }
        return list;
    }

    @Override
    public void save(SnippetsDAO.Snippet snippet, String snippetType, AuthCtx user) throws IOException {
        RelFile descriptionFile;
        SnippetType type = SnippetType.getSnippetTypeByName(snippetType);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        RelFile snippetFolder = new RelFile(new String[]{"code-snippets", type.getName(), snippet.id});
        String userCreation = user.getIdentifier();
        String userEdition = user.getIdentifier();
        long creationDate = new Date().getTime();
        long editionDate = new Date().getTime();
        RelFile metaFile = snippetFolder.append(new String[]{"meta.json"});
        if (tr.isFile(metaFile)) {
            SnippetsDAO.Snippet oldLightSnippet = (SnippetsDAO.Snippet)tr.readObjectUnsafe(metaFile, SnippetsDAO.Snippet.class);
            userCreation = oldLightSnippet.userCreation;
            creationDate = oldLightSnippet.creationDate;
        }
        SnippetsDAO.Snippet lightSnippet = new SnippetsDAO.Snippet();
        lightSnippet.title = snippet.title;
        lightSnippet.category = snippet.category;
        lightSnippet.tags = snippet.tags;
        lightSnippet.userCreation = userCreation;
        lightSnippet.userEdition = userEdition;
        lightSnippet.creationDate = creationDate;
        lightSnippet.editionDate = editionDate;
        lightSnippet.isShared = snippet.isShared;
        lightSnippet.variations = new ArrayList<SnippetsDAO.SnippetVariation>();
        for (SnippetsDAO.SnippetVariation v : snippet.variations) {
            SnippetsDAO.SnippetVariation lightVariation = new SnippetsDAO.SnippetVariation();
            lightVariation.id = v.id;
            lightVariation.title = v.title;
            lightSnippet.variations.add(lightVariation);
        }
        lightSnippet.libraries = snippet.libraries;
        lightSnippet.description = null;
        lightSnippet.documentation = null;
        lightSnippet.id = null;
        tr.writeObject(metaFile, (Object)lightSnippet);
        if (snippet.description != null) {
            descriptionFile = snippetFolder.append(new String[]{"description.md"});
            tr.writeStringUTF8(descriptionFile, snippet.description);
        }
        if (snippet.documentation != null) {
            descriptionFile = snippetFolder.append(new String[]{"documentation.md"});
            tr.writeStringUTF8(descriptionFile, snippet.documentation);
        }
        RelFile variationsFolder = snippetFolder.append(new String[]{"variations"});
        for (SnippetsDAO.SnippetVariation v : snippet.variations) {
            if (v.code == null) continue;
            String fileName = this.getVariationFileName(v, type);
            RelFile variationFile = variationsFolder.append(new String[]{fileName});
            tr.writeStringUTF8(variationFile, v.code);
        }
    }

    @Override
    public void delete(String snippetId, String snippetType) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        SnippetType type = SnippetType.getSnippetTypeByName(snippetType);
        t.deleteDirectory(this.userSnippetFolder(type.getName(), snippetId));
    }

    private RelFile userSnippetFolder(String snippetTypeName, String snippetId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)snippetId), (Object)"Snippet id is not specified");
        return new RelFile(new String[]{"code-snippets", snippetTypeName, snippetId});
    }
}

