/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.datalineage.ColumnRelation;
import com.dataiku.dip.datalineage.ColumnRelationDiff;
import com.dataiku.dip.datalineage.LineageState;
import com.dataiku.dip.datalineage.ManualDataLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datalineage.RecipeManualLineageConfig;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.datasets.DataStewardService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.notifications.EmailNotificationsSender;
import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.MarkupFormattersService;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.notifications.markups.Markup;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.google.common.collect.Streams;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataLineageService {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private DataStewardService dataStewardService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private MarkupFormattersService linksService;
    private static final Logger logger = Logger.getLogger((String)"dku.dataLineage");

    public boolean updateManualColumnRelations(AuthCtx authCtx, String projectKey, Map<String, ManualDataLineage> manualDataLineages, boolean ignoreAutoComputedLineage, String recipeName) throws Exception {
        boolean updated = false;
        for (Map.Entry<String, ManualDataLineage> entry : manualDataLineages.entrySet()) {
            String outputDataset = entry.getKey();
            List<ColumnRelationDiff> relationsDiff = entry.getValue().columnRelationsPatch;
            SerializedDataset serializedOutputDataset = (SerializedDataset)this.datasetsDAO.getOrNull(projectKey, outputDataset);
            if (serializedOutputDataset == null) {
                logger.info((Object)("Dataset '" + projectKey + "." + outputDataset + "' does not exist"));
                continue;
            }
            ManualDataLineage currentManualLineage = serializedOutputDataset.getManualDataLineage();
            ManualDataLineage newManualLineage = new ManualDataLineage();
            newManualLineage.columnRelationsPatch.addAll(relationsDiff);
            if (Objects.equals(currentManualLineage, newManualLineage)) continue;
            serializedOutputDataset.setManualDataLineage(newManualLineage);
            this.datasetSaveService.saveWithCustomEvent(projectKey, outputDataset, serializedOutputDataset, authCtx, new TaggableObjectChangedEvent(ITaggingService.TaggableType.DATASET, projectKey, outputDataset, authCtx, TaggableObjectChangedEvent.ActionType.DATASET_MANUAL_DATA_LINEAGE_EDIT));
            updated = true;
        }
        SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getOrNullUnsafe(projectKey, recipeName);
        if (recipe == null) {
            logger.info((Object)("Recipe '" + projectKey + "." + recipeName + "' does not exist"));
        } else {
            RecipeManualLineageConfig currentManualLineageConfig = recipe.manualLineageConfig;
            RecipeManualLineageConfig newManualLineageConfig = new RecipeManualLineageConfig();
            newManualLineageConfig.dependenciesHash = this.computeManualLineageDependenciesHash(projectKey, recipeName);
            newManualLineageConfig.ignoreAutoComputedLineage = ignoreAutoComputedLineage;
            if (!Objects.equals(currentManualLineageConfig, newManualLineageConfig)) {
                recipe.manualLineageConfig = newManualLineageConfig;
                this.recipeSaveService.save(projectKey, recipe);
                updated = true;
            }
        }
        return updated;
    }

    public ManualDataLineage getManualColumnRelation_NT(String projectKey, String outputDataset) throws Exception {
        ManualDataLineage manualDataLineage;
        block9: {
            TransactionContext.assertNoAttachedTransaction();
            Transaction t = this.transactionService.beginRead();
            try {
                SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNull(projectKey, outputDataset);
                ManualDataLineage manualDataLineage2 = sd.getManualDataLineage();
                if (manualDataLineage2 == null) {
                    manualDataLineage2 = new ManualDataLineage();
                }
                manualDataLineage = manualDataLineage2;
                if (t == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to get manual data lineage on dataset " + projectKey + "." + outputDataset));
                    throw e;
                }
            }
            t.close();
        }
        return manualDataLineage;
    }

    public GraphNodes getGraphNodes_NT(AuthCtx authCtx, String contextProjectKey, String projectKey, String dataset, String column, Integer maxDatasetCount) throws Exception {
        ProjectFlowGraph projectFlowGraph;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoDatasetReadUseAccess(authCtx, AnyLoc.resolveSmart(projectKey, dataset), contextProjectKey);
            Schema schema = ((SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, dataset)).getSchema();
            if (!schema.hasColumn(column)) {
                throw new IllegalArgumentException("Dataset '" + dataset + "' does not contain column '" + column + "'.");
            }
            projectFlowGraph = this.flowGraphService.getProjectGraphUnsafe(contextProjectKey);
        }
        FlowDataset flowDataset = projectFlowGraph.getDataset(projectKey, dataset);
        if (flowDataset == null) {
            flowDataset = new FlowDataset(DatasetLocUtils.resolveSmart(projectKey, dataset).getFullName());
        }
        return this.getGraphNodes_NT(authCtx, flowDataset, Sets.newHashSet((Object[])new String[]{column}), contextProjectKey, maxDatasetCount);
    }

    public EmailStatus sendDataStewardColumnChangeNotification_NT(AuthCtx authCtx, SendDataStewardsNotificationEmailParams sendMailParams) throws Exception {
        String projectName;
        File templateFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"notifications", "data-steward-dataset-notification-email.ftl"});
        MarkupFormatter markupFormatter = this.linksService.getMarkupFormatter(Markup.HTML);
        DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart(sendMailParams.contextProjectKey, sendMailParams.datasetSmartName);
        Map<String, DataStewardLineageInfo> dataStewardsLineage = this.getDataStewardsInLineage_NT(authCtx, sendMailParams.contextProjectKey, datasetLoc.getProjectKey(), datasetLoc.getName(), sendMailParams.column);
        HashSet<String> finalRecipients = new HashSet<String>(sendMailParams.userRecipients);
        if (sendMailParams.includeHiddenDataStewards) {
            finalRecipients.addAll(dataStewardsLineage.values().stream().filter(ds -> !this.getDatastewardHiddenDatasetsOnLocation((DataStewardLineageInfo)ds, sendMailParams.direction).isEmpty() && !authCtx.getAssociatedDSSUser().equals(ds.login)).map(ds -> ds.login).collect(Collectors.toList()));
        }
        try (Transaction t = this.transactionService.beginRead();){
            projectName = this.projectsService.getMandatoryUnsafe((String)datasetLoc.getProjectKey()).name;
        }
        UserSettingsService.EmailNotificationsSettings params = new UserSettingsService.EmailNotificationsSettings();
        params.enabled = true;
        params.subject = this.getSubjectForLocation(sendMailParams.direction, authCtx.getAssociatedDSSUser());
        EmailStatus status = new EmailStatus();
        EmailNotificationsSender sender = new EmailNotificationsSender();
        Exception firstException = null;
        for (String userLogin : finalRecipients) {
            try {
                DSSAuthCtx dataStewardAuthCtx;
                DataStewardLineageInfo dataSteward = dataStewardsLineage.get(userLogin);
                if (dataSteward == null) {
                    logger.warn((Object)("user: " + userLogin + " is not in lineage of dataset + " + datasetLoc.getFullName()));
                    ++status.failCount;
                    continue;
                }
                if (dataSteward.isDeleted) {
                    logger.warn((Object)("Could not send mail to data steward: " + userLogin + " is deleted"));
                    ++status.failCount;
                    continue;
                }
                if (dataSteward.email == null) {
                    logger.warn((Object)("user: " + userLogin + " has no associated email"));
                    ++status.failCount;
                    continue;
                }
                try (Transaction t = this.transactionService.beginRead();){
                    UsersDAO.User recipientUser = this.usersDAO.getOrNullUnsafe(dataSteward.login);
                    dataStewardAuthCtx = DSSAuthCtx.forUserLogin(recipientUser);
                }
                Set<String> impactedDatasets = this.computeDataStewardImpactedDatasets(dataSteward, dataStewardAuthCtx, sendMailParams.direction, sendMailParams.includeHiddenDataStewards);
                String body = this.makeBody(templateFile, authCtx.getAssociatedDSSUser(), dataStewardAuthCtx, projectName, datasetLoc, sendMailParams.column, impactedDatasets, sendMailParams.message, markupFormatter);
                sender.sendToUser(dataSteward.email, params, body);
                ++status.successCount;
            }
            catch (Exception e) {
                ++status.failCount;
                if (firstException == null) {
                    firstException = e;
                }
                logger.warn((Object)("Could not send email to user: " + userLogin), (Throwable)e);
            }
        }
        if (status.successCount == 0 && firstException != null) {
            throw firstException;
        }
        return status;
    }

    private Set<String> computeDataStewardImpactedDatasets(DataStewardLineageInfo dataSteward, AuthCtx datastewardAuthCtx, DataStewardLocation location, boolean shouldIncludeHiddenDatastewards) throws IOException {
        HashSet<String> impactedDatasets = new HashSet<String>();
        if (location == DataStewardLocation.UPSTREAM || location == DataStewardLocation.BOTH) {
            impactedDatasets.addAll(dataSteward.ownedUpstreamDatasets);
            if (shouldIncludeHiddenDatastewards) {
                impactedDatasets.addAll(dataSteward.ownedHiddenUpstreamDatasets);
            }
        }
        if (location == DataStewardLocation.DOWNSTREAM || location == DataStewardLocation.BOTH) {
            impactedDatasets.addAll(dataSteward.ownedDownstreamDatasets);
            if (shouldIncludeHiddenDatastewards) {
                impactedDatasets.addAll(dataSteward.ownedHiddenDownstreamDatasets);
            }
        }
        try (Transaction t = this.transactionService.beginRead();){
            impactedDatasets = impactedDatasets.stream().filter(dataset -> {
                try {
                    AnyLoc loc = AnyLoc.resolveFull(dataset);
                    this.projectsService.checkPerm(datastewardAuthCtx, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }).collect(Collectors.toSet());
        }
        return impactedDatasets;
    }

    List<String> getDatastewardHiddenDatasetsOnLocation(DataStewardLineageInfo datastewardLineageInfo, DataStewardLocation location) {
        return switch (location) {
            case DataStewardLocation.UPSTREAM -> datastewardLineageInfo.ownedHiddenUpstreamDatasets;
            case DataStewardLocation.DOWNSTREAM -> datastewardLineageInfo.ownedHiddenDownstreamDatasets;
            default -> Stream.concat(datastewardLineageInfo.ownedHiddenDownstreamDatasets.stream(), datastewardLineageInfo.ownedHiddenUpstreamDatasets.stream()).collect(Collectors.toList());
        };
    }

    private String getSubjectForLocation(DataStewardLocation location, String sender) {
        switch (location) {
            case UPSTREAM: {
                return "Dataiku - Column Lineage Inquiry from " + sender;
            }
        }
        return "Dataiku - Information on Lineage from " + sender;
    }

    private String makeBody(File templateFile, String sender, AuthCtx recipientUserAuthCtx, String projectName, AnyLoc datasetLoc, String column, Collection<String> impactedDatasets, String message, MarkupFormatter markupFormatter) throws Exception {
        VariableLookup lookup = new VariableLookup();
        lookup.addVariable("sender", sender);
        lookup.addVariable("recipient", recipientUserAuthCtx.getAssociatedDSSUser());
        try (Transaction t2 = this.transactionService.beginRead();){
            this.projectsService.checkPerm(recipientUserAuthCtx, datasetLoc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            lookup.addVariable("originProject", projectName);
            lookup.addVariable("originDataset", markupFormatter.dataset(datasetLoc.getProjectKey(), datasetLoc.getId(), null));
            lookup.addVariable("originColumn", column);
        }
        catch (DKUSecurityException t2) {
            // empty catch block
        }
        if (!StringUtils.isBlank((String)message)) {
            lookup.addVariable("personalizedMessage", message);
        }
        lookup.addVariable("impactedDatasets", impactedDatasets.stream().map(impactedDataset -> {
            SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.DATASET, impactedDataset);
            return markupFormatter.dataset(smartObjectRef.projectKey, smartObjectRef.objectId, null);
        }).toList());
        MessageContentBuilder.ExpandedTemplate expandedTemplate = new MessageContentBuilder(lookup).buildMessage(new TemplatedContent(), templateFile);
        return expandedTemplate.message;
    }

    public Map<String, DataStewardLineageInfo> getDataStewardsInLineage_NT(AuthCtx authCtx, String contextProjectKey, String projectKey, String dataset, String column) throws Exception {
        ProjectFlowGraph projectFlowGraph;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoDatasetReadUseAccess(authCtx, AnyLoc.resolveSmart(projectKey, dataset), contextProjectKey);
            Schema schema = ((SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, dataset)).getSchema();
            if (!schema.hasColumn(column)) {
                throw new IllegalArgumentException("Dataset '" + dataset + "' does not contain column '" + column + "'.");
            }
            projectFlowGraph = this.flowGraphService.getProjectGraphUnsafe(contextProjectKey);
        }
        FlowDataset flowDataset = projectFlowGraph.getDataset(projectKey, dataset);
        if (flowDataset == null) {
            flowDataset = new FlowDataset(DatasetLocUtils.resolveSmart(projectKey, dataset).getFullName());
        }
        GraphNodes lineageNodes = this.getGraphNodes_NT(authCtx, flowDataset, Sets.newHashSet((Object[])new String[]{column}), contextProjectKey, null, TraversalMode.TRAVERSE_ALL);
        List<String> datasetsInLineage = Streams.concat((Stream[])new Stream[]{Stream.of(flowDataset.getFullId()), lineageNodes.columnRelations.stream().map(cr -> cr.inputDataset), lineageNodes.columnRelations.stream().map(cr -> cr.outputDataset)}).distinct().filter(fullId -> lineageNodes.flowDatasetsByFullId.containsKey(fullId) && lineageNodes.datasetLocInfoByFulllId.containsKey(fullId)).toList();
        HashMap<String, DataStewardLineageInfo> datastewardsInfoByLogin = new HashMap<String, DataStewardLineageInfo>();
        for (String fullId2 : datasetsInLineage) {
            boolean canRead;
            DataStewardLineageInfo datastewardLineageInfo;
            DatasetLocInfo locInfo;
            EnrichedGraphNode<FlowDataset> enrichedDataset;
            block29: {
                enrichedDataset = lineageNodes.flowDatasetsByFullId.get(fullId2);
                locInfo = lineageNodes.datasetLocInfoByFulllId.get(fullId2);
                try {
                    Transaction t = this.transactionService.beginRead();
                    try {
                        String datastewardLogin;
                        SerializedDataset sd = ((FlowDataset)enrichedDataset.node).getSerializedMandatoryUnsafe(this.datasetsDAO);
                        if (sd.dataSteward != null) {
                            datastewardLogin = sd.dataSteward;
                        } else if (sd.creationTag != null && sd.creationTag.getLastAuthor() != null) {
                            datastewardLogin = sd.creationTag.getLastAuthor();
                        } else {
                            logger.warn((Object)("No data steward associated to dataset " + ((FlowDataset)enrichedDataset.node).getFullId()));
                            continue;
                        }
                        datastewardLineageInfo = (DataStewardLineageInfo)datastewardsInfoByLogin.get(datastewardLogin);
                        if (datastewardLineageInfo == null) {
                            datastewardLineageInfo = new DataStewardLineageInfo();
                            UsersDAO.User dataSteward = this.usersDAO.getOrNullUnsafe(datastewardLogin);
                            if (dataSteward == null) {
                                datastewardLineageInfo.login = datastewardLogin;
                                datastewardLineageInfo.displayedName = datastewardLogin + " (deleted)";
                                datastewardLineageInfo.isDeleted = true;
                            } else {
                                datastewardLineageInfo.login = dataSteward.login;
                                datastewardLineageInfo.email = dataSteward.email;
                                datastewardLineageInfo.displayedName = dataSteward.displayName;
                                datastewardLineageInfo.isDeleted = false;
                            }
                            datastewardsInfoByLogin.put(datastewardLineageInfo.login, datastewardLineageInfo);
                        }
                        AnyLoc datasetOriginalLoc = AnyLoc.resolveFull(((FlowDataset)enrichedDataset.node).getFullName());
                        canRead = locInfo.contextProject.stream().anyMatch(datasetLocProjectKey -> this.canReadDataset((String)datasetLocProjectKey, datasetOriginalLoc.getProjectKey(), datasetOriginalLoc.getId(), authCtx));
                        break block29;
                    }
                    finally {
                        if (t == null) continue;
                        t.close();
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)("Failed to read data steward for dataset " + ((FlowDataset)enrichedDataset.node).getFullId()), (Throwable)e);
                }
                continue;
            }
            if (((FlowDataset)enrichedDataset.node).getFullName().equals(flowDataset.getFullName())) {
                datastewardLineageInfo.ownedUpstreamDatasets.add(((FlowDataset)enrichedDataset.node).getFullName());
                datastewardLineageInfo.ownedDownstreamDatasets.add(((FlowDataset)enrichedDataset.node).getFullName());
                continue;
            }
            if (Direction.UPSTREAM.equals((Object)locInfo.direction)) {
                if (canRead) {
                    datastewardLineageInfo.ownedUpstreamDatasets.add(((FlowDataset)enrichedDataset.node).getFullName());
                    continue;
                }
                datastewardLineageInfo.ownedHiddenUpstreamDatasets.add(((FlowDataset)enrichedDataset.node).getFullName());
                continue;
            }
            if (!Direction.DOWNSTREAM.equals((Object)locInfo.direction)) continue;
            if (canRead) {
                datastewardLineageInfo.ownedDownstreamDatasets.add(((FlowDataset)enrichedDataset.node).getFullName());
                continue;
            }
            datastewardLineageInfo.ownedHiddenDownstreamDatasets.add(((FlowDataset)enrichedDataset.node).getFullName());
        }
        return datastewardsInfoByLogin;
    }

    GraphNodes getGraphNodes_NT(AuthCtx authCtx, GraphNode startNode, Set<String> startWatchedColumns, String startProjectKey, Integer maxDatasetCount) throws Exception {
        return this.getGraphNodes_NT(authCtx, startNode, startWatchedColumns, startProjectKey, maxDatasetCount, TraversalMode.STOP_ON_NO_READ_PERMISSION);
    }

    GraphNodes getGraphNodes_NT(AuthCtx authCtx, GraphNode startNode, Set<String> startWatchedColumns, String startProjectKey, Integer maxDatasetCount, TraversalMode traversalMode) throws Exception {
        int maxNbDatasets;
        TransactionContext.assertNoAttachedTransaction();
        GraphNodes graphNodes = new GraphNodes();
        HashSet<GraphNodeWithContext> visitedGraphNodesWithContext = new HashSet<GraphNodeWithContext>();
        NodesByProjectQueue queue = new NodesByProjectQueue(startProjectKey);
        Arrays.stream(Direction.values()).map(direction -> new GraphNodeWithContext(startNode, null, startWatchedColumns, (Direction)((Object)direction), startProjectKey)).forEach(queue::add);
        int n = maxNbDatasets = maxDatasetCount == null ? DataLineageService.getNbDatasetsHardMax() : maxDatasetCount;
        while (!queue.isEmpty()) {
            Transaction t = this.transactionService.beginRead();
            try {
                while (queue.containsNodesForCurrentProject()) {
                    GraphNodeWithContext graphNodeWithContext = queue.pop();
                    int nbDatasets = graphNodes.flowDatasetsByFullId.size();
                    if (nbDatasets > maxNbDatasets) {
                        logger.warn((Object)("Number of datasets in lineage graph (" + nbDatasets + ") exceeds limit (" + maxNbDatasets + ")."));
                        queue.clear();
                        continue;
                    }
                    List<GraphNodeWithContext> nextNodesToVisit = this.processCurrentNodeAndGetNextNodesToVisit(graphNodeWithContext, visitedGraphNodesWithContext, graphNodes, authCtx, traversalMode);
                    nextNodesToVisit.forEach(queue::add);
                }
                queue.switchToNextAvailableProject();
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
        graphNodes.maxNbDatasets = maxNbDatasets;
        for (ColumnRelation relation : graphNodes.columnRelations) {
            relation.indirect = null;
        }
        return graphNodes;
    }

    private List<GraphNodeWithContext> processCurrentNodeAndGetNextNodesToVisit(GraphNodeWithContext currentNodeWithContext, Set<GraphNodeWithContext> visitedGraphNodesWithContext, GraphNodes graphNodes, AuthCtx authCtx, TraversalMode traversalMode) throws Exception {
        if (!visitedGraphNodesWithContext.add(currentNodeWithContext)) {
            return Collections.emptyList();
        }
        GraphNode currentNode = currentNodeWithContext.node;
        GraphNode previousNode = currentNodeWithContext.previousNode;
        Set<String> currentlyWatchedColumns = currentNodeWithContext.watchedColumns;
        Direction direction = currentNodeWithContext.direction;
        String currentProjectKey = currentNodeWithContext.currentProjectKey;
        if (currentNode instanceof FlowRecipe) {
            FlowRecipe flowRecipe = (FlowRecipe)currentNode;
            ProjectFlowGraph projectFlowGraph = this.flowGraphService.getProjectGraphUnsafe(flowRecipe.getProjectKey());
            if ((flowRecipe = projectFlowGraph.getRecipe(flowRecipe.getProjectKey(), flowRecipe.getName())) == null) {
                return Collections.emptyList();
            }
            graphNodes.flowRecipeByFullId.put(flowRecipe.getFullId(), new EnrichedGraphNode<FlowRecipe>(flowRecipe, null, false));
            List<FlowDataset> connectedFlowDatasets = Stream.concat(flowRecipe.getPredecessors().stream(), flowRecipe.getSuccessors().stream()).filter(FlowDataset.class::isInstance).map(FlowDataset.class::cast).toList();
            for (FlowDataset flowDataset : connectedFlowDatasets) {
                SerializedDataset serializedDataset = flowDataset.getSerializedMandatoryUnsafe(this.datasetsDAO);
                if (!TraversalMode.TRAVERSE_ALL.equals((Object)traversalMode) && !this.canReadDataset(currentProjectKey, serializedDataset.getProjectKey(), serializedDataset.name, authCtx)) continue;
                this.addGraphNodeIfAbsent(graphNodes, flowDataset, serializedDataset);
                DatasetLocInfo datasetLocInfo = graphNodes.datasetLocInfoByFulllId.computeIfAbsent(flowDataset.getFullId(), id -> new DatasetLocInfo(direction));
                datasetLocInfo.contextProject.add(currentProjectKey);
            }
            return this.getNextNodesToVisitForRecipe(graphNodes.columnRelations, graphNodes.lineageStateByRecipeFullId, flowRecipe, previousNode, currentlyWatchedColumns, direction, authCtx);
        }
        if (currentNode instanceof FlowDataset) {
            FlowDataset flowDataset = (FlowDataset)currentNode;
            DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveFull(flowDataset.getFullId());
            ProjectFlowGraph projectFlowGraph = this.flowGraphService.getProjectGraphUnsafe(datasetLoc.getProjectKey());
            if ((flowDataset = projectFlowGraph.getDataset(datasetLoc.getProjectKey(), datasetLoc.getName())) == null) {
                return Collections.emptyList();
            }
            SerializedDataset serializedDataset = flowDataset.getSerializedMandatoryUnsafe(this.datasetsDAO);
            if (TraversalMode.TRAVERSE_ALL.equals((Object)traversalMode) || this.canReadDataset(currentProjectKey, serializedDataset.getProjectKey(), serializedDataset.name, authCtx)) {
                this.addGraphNodeIfAbsent(graphNodes, flowDataset, serializedDataset);
                DatasetLocInfo datasetLocInfo = graphNodes.datasetLocInfoByFulllId.computeIfAbsent(flowDataset.getFullId(), id -> new DatasetLocInfo(direction));
                datasetLocInfo.contextProject.add(currentProjectKey);
                Schema schema = serializedDataset.getSchema();
                if (currentlyWatchedColumns.stream().noneMatch(arg_0 -> ((Schema)schema).hasColumn(arg_0))) {
                    return Collections.emptyList();
                }
                ArrayList<GraphNodeWithContext> nextNodesToVisit = new ArrayList<GraphNodeWithContext>();
                List<GraphNode> nextItems = this.getNextItemsForDataset(flowDataset, serializedDataset, direction, currentProjectKey, authCtx, traversalMode);
                for (GraphNode nextItem : nextItems) {
                    String nextCurrentProjectKey = Direction.DOWNSTREAM.equals((Object)direction) ? AnyLoc.resolveFull(nextItem.getFullId()).getProjectKey() : serializedDataset.getProjectKey();
                    nextNodesToVisit.add(new GraphNodeWithContext(nextItem, currentNode, currentlyWatchedColumns, direction, nextCurrentProjectKey));
                }
                return nextNodesToVisit;
            }
        }
        return Collections.emptyList();
    }

    private void addGraphNodeIfAbsent(GraphNodes graphNodes, FlowDataset flowDataset, SerializedDataset serializedDataset) throws IOException {
        String datasetFullId = flowDataset.getFullId();
        if (!graphNodes.flowDatasetsByFullId.containsKey(datasetFullId)) {
            Zone zone = this.getDatasetFlowZone(serializedDataset.getProjectKey(), serializedDataset.getId());
            boolean datasetIsExposed = !this.getExposedToProjectKeys(serializedDataset).isEmpty();
            graphNodes.flowDatasetsByFullId.put(datasetFullId, new EnrichedGraphNode<FlowDataset>(flowDataset, zone, datasetIsExposed));
        }
    }

    private List<GraphNodeWithContext> getNextNodesToVisitForRecipe(Set<ColumnRelation> columnRelations, Map<String, LineageState> lineageStateByRecipeFullId, FlowRecipe flowRecipe, GraphNode previousNode, Set<String> previouslyWatchedColumns, Direction direction, AuthCtx authCtx) throws Exception {
        if (!(previousNode instanceof FlowDataset)) {
            return Collections.emptyList();
        }
        FlowDataset previousDataset = (FlowDataset)previousNode;
        RecipeColumnRelations recipeColumnRelations = this.getRecipeColumnRelations(flowRecipe, authCtx);
        lineageStateByRecipeFullId.put(flowRecipe.getFullId(), recipeColumnRelations.lineageState);
        HashMap<String, Set> nextWatchedColumnsMap = new HashMap<String, Set>();
        for (ColumnRelation recipeColumnRelation : recipeColumnRelations.columnRelations) {
            if (Direction.UPSTREAM.equals((Object)direction) && previouslyWatchedColumns.contains(recipeColumnRelation.outputColumn) && previousDataset.getFullName().equals(recipeColumnRelation.outputDataset)) {
                columnRelations.add(recipeColumnRelation);
                nextWatchedColumnsMap.computeIfAbsent(recipeColumnRelation.inputDataset, x -> new HashSet()).add(recipeColumnRelation.inputColumn);
                continue;
            }
            if (!Direction.DOWNSTREAM.equals((Object)direction) || !previouslyWatchedColumns.contains(recipeColumnRelation.inputColumn) || !previousDataset.getFullName().equals(recipeColumnRelation.inputDataset)) continue;
            columnRelations.add(recipeColumnRelation);
            nextWatchedColumnsMap.computeIfAbsent(recipeColumnRelation.outputDataset, x -> new HashSet()).add(recipeColumnRelation.outputColumn);
        }
        List<? extends GraphNode> connectedNodes = direction == Direction.UPSTREAM ? flowRecipe.getPredecessors() : flowRecipe.getSuccessors();
        return connectedNodes.stream().map(node -> {
            Set<String> watchedColumns = (Set<String>)nextWatchedColumnsMap.get(node.getFullId());
            if (watchedColumns == null) {
                watchedColumns = Collections.emptySet();
            }
            return new GraphNodeWithContext((GraphNode)node, flowRecipe, watchedColumns, direction, flowRecipe.getProjectKey());
        }).toList();
    }

    private SerializedGraphNodes buildSerializedGraphNodes(List<? extends GraphNode> nodes) throws IOException {
        ArrayList<SerializedDataset> datasets = new ArrayList<SerializedDataset>();
        ArrayList<SavedModel> savedModels = new ArrayList<SavedModel>();
        for (GraphNode graphNode : nodes) {
            if (graphNode instanceof FlowDataset) {
                FlowDataset flowDataset = (FlowDataset)graphNode;
                SerializedDataset serializedPredDataset = flowDataset.getSerializedMandatoryUnsafe(this.datasetsDAO);
                datasets.add(serializedPredDataset);
                continue;
            }
            if (!(graphNode instanceof FlowSavedModel)) continue;
            FlowSavedModel flowSavedModel = (FlowSavedModel)graphNode;
            SavedModel savedModel = flowSavedModel.getSavedModel();
            savedModels.add(savedModel);
        }
        return new SerializedGraphNodes(datasets, savedModels);
    }

    public RecipeColumnRelations getRecipeColumnRelations(FlowRecipe flowRecipe, AuthCtx authCtx) throws Exception {
        RecipeColumnRelations recipeColumnRelations = this.getRecipeAutoComputedRelations(flowRecipe, authCtx, false);
        SerializedGraphNodes successors = this.buildSerializedGraphNodes(flowRecipe.getSuccessors());
        this.patchColumRelations(recipeColumnRelations, flowRecipe.getProjectKey(), successors.datasets);
        this.updateLineageState(recipeColumnRelations, flowRecipe);
        return recipeColumnRelations;
    }

    public RecipeColumnRelations getRecipeAutoComputedRelations(FlowRecipe flowRecipe, AuthCtx authCtx, boolean forceAuto) throws Exception {
        boolean ignoreAutoComputed;
        SerializedGraphNodes predecessors = this.buildSerializedGraphNodes(flowRecipe.getPredecessors());
        SerializedGraphNodes successors = this.buildSerializedGraphNodes(flowRecipe.getSuccessors());
        String payload = this.recipesDAO.getPayloadOrNull(flowRecipe.getProjectKey(), flowRecipe.getName());
        RecipeMeta recipeMeta = RecipeRegistry.getMeta(flowRecipe.getType());
        JobActivity activity = new JobActivity(new RecipeRunnableSubgraph(flowRecipe));
        SerializedRecipe serializedRecipe = flowRecipe.getModel();
        RecipeColumnRelations recipeColumnRelations = new RecipeColumnRelations();
        recipeColumnRelations.ignoreAutoComputed = false;
        if (serializedRecipe.manualLineageConfig != null) {
            recipeColumnRelations.ignoreAutoComputed = serializedRecipe.manualLineageConfig.ignoreAutoComputedLineage;
        }
        boolean bl = ignoreAutoComputed = !forceAuto && recipeColumnRelations.ignoreAutoComputed;
        if (ignoreAutoComputed) {
            recipeColumnRelations.columnRelations = Collections.emptySet();
            recipeColumnRelations.lineageState = LineageState.UNCERTAIN;
            return recipeColumnRelations;
        }
        try {
            RecipeLineage recipeLineage = recipeMeta.getRecipeLineage(predecessors, successors, payload, authCtx, activity, serializedRecipe);
            recipeColumnRelations.lineageState = recipeLineage.isUncertain() ? LineageState.UNCERTAIN : LineageState.CERTAIN;
            recipeLineage.keepValidRelations();
            recipeColumnRelations.columnRelations = recipeLineage.getAllColumnRelations();
        }
        catch (Exception e) {
            recipeColumnRelations.lineageState = LineageState.UNCERTAIN;
            try {
                logger.warn((Object)String.format("Failed to get column relations on recipe %s.%s: %s", flowRecipe.getProjectKey(), flowRecipe.getName(), e.getMessage()));
                RecipeLineage bestGuessRecipeLineage = recipeMeta.getBestGuessRecipeLineage(predecessors, successors);
                bestGuessRecipeLineage.keepValidRelations();
                recipeColumnRelations.columnRelations = bestGuessRecipeLineage.getAllColumnRelations();
            }
            catch (Exception e2) {
                logger.warn((Object)String.format("Failed to get best guess of column relations on recipe %s.%s: %s", flowRecipe.getProjectKey(), flowRecipe.getName(), e2.getMessage()));
                recipeColumnRelations.columnRelations = Collections.emptySet();
            }
        }
        recipeColumnRelations.columnRelations = recipeColumnRelations.columnRelations.stream().filter(relation -> Boolean.FALSE.equals(relation.indirect)).collect(Collectors.toSet());
        return recipeColumnRelations;
    }

    void patchColumRelations(RecipeColumnRelations recipeColumnRelations, String recipeProjectKey, List<SerializedDataset> successorDatasets) {
        HashSet<ColumnRelation> patchedColumnRelations = new HashSet<ColumnRelation>(recipeColumnRelations.columnRelations);
        Map<String, Optional> manualLineages = successorDatasets.stream().collect(Collectors.toMap(SerializedDataset::getFullName, dataset -> Optional.ofNullable(dataset.getManualDataLineage())));
        Map<String, List> columnRelationsPatch = manualLineages.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            String outputDatasetFullName = (String)e.getKey();
            Optional manualDataLineage = (Optional)e.getValue();
            if (manualDataLineage.isPresent()) {
                return this.getValidColumnRelationDiffs(recipeProjectKey, outputDatasetFullName, ((ManualDataLineage)manualDataLineage.get()).columnRelationsPatch);
            }
            return List.of();
        }));
        columnRelationsPatch.entrySet().stream().flatMap(e -> {
            String outputDataset = (String)e.getKey();
            List patch = (List)e.getValue();
            return patch.stream().map(diff -> diff.relation).flatMap(relation -> {
                String inputDatasetFullName = AnyLoc.resolveSmart(recipeProjectKey, relation.inputDataset).getFullName();
                ColumnRelation directRelation = new ColumnRelation(relation.inputColumn, inputDatasetFullName, relation.outputColumn, outputDataset);
                directRelation.indirect = false;
                ColumnRelation indirectRelation = new ColumnRelation(relation.inputColumn, inputDatasetFullName, relation.outputColumn, outputDataset);
                indirectRelation.indirect = true;
                return Stream.of(directRelation, indirectRelation);
            });
        }).forEach(patchedColumnRelations::remove);
        columnRelationsPatch.entrySet().stream().flatMap(e -> {
            String outputDataset = (String)e.getKey();
            List patch = (List)e.getValue();
            return patch.stream().filter(diff -> diff.action == ColumnRelationDiff.ACTION.ADD).map(diff -> diff.relation).map(relation -> {
                String inputDatasetFullName = AnyLoc.resolveSmart(recipeProjectKey, relation.inputDataset).getFullName();
                ColumnRelation directRelation = new ColumnRelation(relation.inputColumn, inputDatasetFullName, relation.outputColumn, outputDataset);
                directRelation.indirect = false;
                return directRelation;
            });
        }).forEach(patchedColumnRelations::add);
        recipeColumnRelations.columnRelations = patchedColumnRelations;
    }

    void updateLineageState(RecipeColumnRelations recipeColumnRelations, FlowRecipe flowRecipe) throws IOException {
        String currentDependenciesHash = this.computeManualLineageDependenciesHash(flowRecipe.getProjectKey(), flowRecipe.getName());
        RecipeManualLineageConfig manualLineageConfig = flowRecipe.getModel().manualLineageConfig;
        if (manualLineageConfig != null) {
            String savedDependenciesHash = manualLineageConfig.dependenciesHash;
            recipeColumnRelations.lineageState = !Objects.equals(currentDependenciesHash, savedDependenciesHash) ? LineageState.REVIEWED_WITH_OUTSIDE_MODIFICATIONS : LineageState.REVIEWED;
        }
    }

    public String computeManualLineageDependenciesHash(String projectKey, String recipeName) throws IOException {
        String recipePayload = this.recipesDAO.getPayloadOrNull(projectKey, recipeName);
        String recipePayloadHash = DKUtils.md5Base64((String)(recipePayload == null ? "" : recipePayload));
        ProjectFlowGraph projectFlowGraph = this.flowGraphService.getProjectGraphUnsafe(projectKey);
        FlowRecipe flowRecipe = projectFlowGraph.getRecipe(projectKey, recipeName);
        List<String> connectedDatasetFullIds = flowRecipe == null ? List.of() : Stream.concat(flowRecipe.getPredecessors().stream(), flowRecipe.getSuccessors().stream()).filter(FlowDataset.class::isInstance).map(GraphNode::getFullId).toList();
        ArrayList<SerializedDataset> serializedDatasets = new ArrayList<SerializedDataset>();
        for (String datasetFullId : connectedDatasetFullIds) {
            SerializedDataset sd2 = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(AnyLoc.resolveFull(datasetFullId));
            if (sd2 == null) continue;
            serializedDatasets.add(sd2);
        }
        String datasetsHash = DKUtils.md5Base64((String)serializedDatasets.stream().sorted(Comparator.comparing(SerializedDataset::getFullName)).map(sd -> {
            Schema schemaMetaDataAndColumns = new Schema(sd.getSchema());
            schemaMetaDataAndColumns.userModified = false;
            return JSON.json((Object)new Pair((Object)sd.getFullName(), (Object)schemaMetaDataAndColumns));
        }).collect(Collectors.joining()));
        return DKUtils.md5Base64((String)(recipePayloadHash + datasetsHash));
    }

    List<ColumnRelationDiff> getValidColumnRelationDiffs(String recipeProjectKey, String outputDatasetFullName, List<ColumnRelationDiff> relationDiffs) {
        HashMap schemaByDatasetFullname = new HashMap();
        List<ColumnRelationDiff> validRelationDiffs = relationDiffs.stream().filter(diff -> {
            Schema inputSchema = schemaByDatasetFullname.computeIfAbsent(AnyLoc.resolveSmart(recipeProjectKey, diff.relation.inputDataset).getFullName(), this.datasetFullNameToSchema());
            Schema outputSchema = schemaByDatasetFullname.computeIfAbsent(outputDatasetFullName, this.datasetFullNameToSchema());
            return inputSchema != null && inputSchema.hasColumn(diff.relation.inputColumn) && outputSchema != null && outputSchema.hasColumn(diff.relation.outputColumn);
        }).toList();
        if (validRelationDiffs.size() < relationDiffs.size()) {
            logger.debug((Object)("Filtered out " + (relationDiffs.size() - validRelationDiffs.size()) + " invalid relation diffs"));
        }
        return validRelationDiffs;
    }

    private Function<String, Schema> datasetFullNameToSchema() {
        return datasetFullName -> {
            DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveFull(datasetFullName);
            SerializedDataset sd = null;
            try {
                sd = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(datasetLoc);
            }
            catch (IOException e) {
                logger.debug((Object)("Dataset " + String.valueOf(datasetLoc) + " not found"));
            }
            return sd == null ? null : sd.getSchema();
        };
    }

    private List<GraphNode> getNextItemsForDataset(FlowDataset flowDataset, SerializedDataset serializedDataset, Direction direction, String currentProjectKey, AuthCtx authCtx, TraversalMode traversalMode) throws IOException {
        FlowDataset otherProjectFlowDataset;
        String datasetProjectKey = serializedDataset.getProjectKey();
        String datasetName = serializedDataset.name;
        ArrayList<GraphNode> nextItems = direction == Direction.DOWNSTREAM ? new ArrayList<GraphNode>(flowDataset.getSuccessors()) : new ArrayList<GraphNode>(flowDataset.getPredecessors());
        if (!currentProjectKey.equals(datasetProjectKey) && (TraversalMode.TRAVERSE_ALL.equals((Object)traversalMode) || this.canReadDataset(datasetProjectKey, datasetProjectKey, datasetName, authCtx)) && (otherProjectFlowDataset = this.getFlowDataset(datasetProjectKey, datasetProjectKey, datasetName)) != null) {
            if (direction == Direction.DOWNSTREAM) {
                nextItems.addAll(otherProjectFlowDataset.getSuccessors());
            } else {
                nextItems.addAll(otherProjectFlowDataset.getPredecessors());
            }
        }
        if (Direction.DOWNSTREAM.equals((Object)direction)) {
            Set<String> exposedToProjectKeys = this.getExposedToProjectKeys(serializedDataset);
            for (String exposedToProjectKey : exposedToProjectKeys) {
                FlowDataset exposedFlowDataset;
                if (!TraversalMode.TRAVERSE_ALL.equals((Object)traversalMode) && !this.canReadDataset(exposedToProjectKey, datasetProjectKey, datasetName, authCtx) || (exposedFlowDataset = this.getFlowDataset(exposedToProjectKey, datasetProjectKey, datasetName)) == null) continue;
                nextItems.addAll(exposedFlowDataset.getSuccessors());
            }
        }
        return nextItems;
    }

    @Nullable
    private FlowDataset getFlowDataset(String contextProjectKey, String datasetProjectKey, String datasetName) throws IOException {
        ProjectFlowGraph projectFlowGraph = this.flowGraphService.getProjectGraphUnsafe(contextProjectKey);
        return projectFlowGraph.getDataset(datasetProjectKey, datasetName);
    }

    @Nullable
    private Zone getDatasetFlowZone(String projectKey, String datasetName) throws IOException {
        SmartObjectRef smRef;
        ProjectFlowGraph projectFlowGraph = this.flowGraphService.getProjectGraphUnsafe(projectKey);
        Zone zone = projectFlowGraph.getZone(smRef = SmartObjectRef.localRef(ITaggingService.TaggableType.DATASET, datasetName));
        if (zone == null) {
            zone = projectFlowGraph.getZone(Zone.DEFAULT_ZONE.getId());
        }
        return zone;
    }

    private Set<String> getExposedToProjectKeys(SerializedDataset serializedDataset) throws IOException {
        return this.projectsService.getObjectExpositionTargetProjects(serializedDataset.getProjectKey(), serializedDataset.getId());
    }

    private boolean canReadDataset(String contextProjectKey, String datasetProjectKey, String datasetName, AuthCtx authCtx) {
        try {
            this.projectsService.failIfNoDatasetReadUseAccess(authCtx, new AnyLoc(datasetProjectKey, datasetName), contextProjectKey);
            return true;
        }
        catch (Exception e) {
            logger.warn((Object)("No read access for dataset '" + datasetProjectKey + "." + datasetName + " in project '" + contextProjectKey + "': " + String.valueOf(e)));
            return false;
        }
    }

    public static int getNbDatasetsSoftMax() {
        return DKUApp.getParams().getIntParam("dku.dataLineage.nbDatasetsSoftMax", Integer.valueOf(500));
    }

    public static int getNbDatasetsHardMax() {
        return DKUApp.getParams().getIntParam("dku.dataLineage.nbDatasetsHardMax", Integer.valueOf(2000));
    }

    public static class GraphNodes {
        public Map<String, EnrichedGraphNode<FlowDataset>> flowDatasetsByFullId = new HashMap<String, EnrichedGraphNode<FlowDataset>>();
        public Map<String, EnrichedGraphNode<FlowRecipe>> flowRecipeByFullId = new HashMap<String, EnrichedGraphNode<FlowRecipe>>();
        public Map<String, DatasetLocInfo> datasetLocInfoByFulllId = new HashMap<String, DatasetLocInfo>();
        public Set<ColumnRelation> columnRelations = new HashSet<ColumnRelation>();
        public Map<String, LineageState> lineageStateByRecipeFullId = new HashMap<String, LineageState>();
        public int maxNbDatasets;
    }

    public static class SendDataStewardsNotificationEmailParams {
        public String contextProjectKey;
        public String datasetSmartName;
        public String column;
        public List<String> userRecipients;
        public DataStewardLocation direction;
        public String message;
        public boolean includeHiddenDataStewards = false;
    }

    @UIModel
    public static enum DataStewardLocation {
        UPSTREAM,
        DOWNSTREAM,
        BOTH;

    }

    @UIModel
    public static class EmailStatus {
        int successCount;
        int failCount;
    }

    public static class DataStewardLineageInfo {
        public String login;
        public String email;
        public String displayedName;
        public boolean isDeleted;
        public List<String> ownedUpstreamDatasets = new ArrayList<String>();
        public List<String> ownedDownstreamDatasets = new ArrayList<String>();
        public List<String> ownedHiddenUpstreamDatasets = new ArrayList<String>();
        public List<String> ownedHiddenDownstreamDatasets = new ArrayList<String>();

        public boolean isHiddenUpstreamDataSteward() {
            return !this.ownedHiddenUpstreamDatasets.isEmpty() && this.ownedUpstreamDatasets.isEmpty();
        }

        public boolean isHiddenDownstreamDataSteward() {
            return !this.ownedHiddenDownstreamDatasets.isEmpty() && this.ownedDownstreamDatasets.isEmpty();
        }

        public boolean isHiddenDataSteward() {
            return this.ownedUpstreamDatasets.isEmpty() && this.ownedDownstreamDatasets.isEmpty() && (!this.ownedHiddenUpstreamDatasets.isEmpty() || !this.ownedHiddenDownstreamDatasets.isEmpty());
        }
    }

    public static enum TraversalMode {
        TRAVERSE_ALL,
        STOP_ON_NO_READ_PERMISSION;

    }

    public static class EnrichedGraphNode<T extends GraphNode> {
        public T node;
        @Nullable
        public Zone zone;
        public boolean isExposed;

        public EnrichedGraphNode(T node, @Nullable Zone zone, boolean isExposed) {
            this.node = node;
            this.zone = zone;
            this.isExposed = isExposed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnrichedGraphNode that = (EnrichedGraphNode)o;
            return this.isExposed == that.isExposed && Objects.equals(this.node, that.node) && Objects.equals(this.zone, that.zone);
        }

        public int hashCode() {
            return Objects.hash(this.node, this.zone, this.isExposed);
        }

        public String toString() {
            return "EnrichedGraphNode{node=" + String.valueOf(this.node) + ", zone=" + String.valueOf(this.zone) + ", isExposed=" + this.isExposed + "}";
        }
    }

    public static class DatasetLocInfo {
        public Direction direction;
        public Set<String> contextProject;

        public DatasetLocInfo(Direction direction) {
            this.direction = direction;
            this.contextProject = new HashSet<String>();
        }
    }

    public static enum Direction {
        UPSTREAM,
        DOWNSTREAM;

    }

    private static class NodesByProjectQueue {
        final Map<String, Deque<GraphNodeWithContext>> nodesByProjectKey = new HashMap<String, Deque<GraphNodeWithContext>>();
        @Nullable
        String currentProjectKey;

        NodesByProjectQueue(@Nonnull String initialProjectKey) {
            this.currentProjectKey = initialProjectKey;
        }

        boolean isEmpty() {
            return this.nodesByProjectKey.isEmpty();
        }

        void clear() {
            this.nodesByProjectKey.clear();
        }

        boolean containsNodesForCurrentProject() {
            Deque<GraphNodeWithContext> queue = this.nodesByProjectKey.get(this.currentProjectKey);
            return queue != null && !queue.isEmpty();
        }

        void switchToNextAvailableProject() {
            this.currentProjectKey = this.nodesByProjectKey.keySet().stream().filter(projectKey -> !Objects.equals(projectKey, this.currentProjectKey)).findFirst().orElse(null);
        }

        void add(@Nonnull GraphNodeWithContext node) {
            this.nodesByProjectKey.computeIfAbsent(node.currentProjectKey, key -> new ArrayDeque()).add(node);
        }

        @Nonnull
        GraphNodeWithContext pop() {
            String projectKey = this.currentProjectKey;
            Deque<GraphNodeWithContext> queue = this.nodesByProjectKey.get(projectKey);
            if (queue == null) {
                projectKey = (String)this.nodesByProjectKey.keySet().stream().findFirst().orElseThrow();
                queue = this.nodesByProjectKey.get(projectKey);
            }
            GraphNodeWithContext node = queue.pop();
            if (queue.isEmpty()) {
                this.nodesByProjectKey.remove(projectKey);
            }
            return node;
        }
    }

    private static class GraphNodeWithContext {
        @Nonnull
        final GraphNode node;
        @Nonnull
        final String nodeFullId;
        @Nullable
        final GraphNode previousNode;
        @Nullable
        final String previousNodeFullId;
        @Nonnull
        final Set<String> watchedColumns;
        @Nonnull
        final Direction direction;
        @Nonnull
        final String currentProjectKey;

        public GraphNodeWithContext(@Nonnull GraphNode node, @Nullable GraphNode previousNode, @Nonnull Set<String> watchedColumns, @Nonnull Direction direction, @Nonnull String currentProjectKey) {
            this.node = node;
            this.nodeFullId = node.getFullId();
            this.previousNode = previousNode;
            this.previousNodeFullId = previousNode != null ? previousNode.getFullId() : null;
            this.watchedColumns = watchedColumns;
            this.direction = direction;
            this.currentProjectKey = currentProjectKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GraphNodeWithContext that = (GraphNodeWithContext)o;
            return Objects.equals(this.nodeFullId, that.nodeFullId) && Objects.equals(this.previousNodeFullId, that.previousNodeFullId) && Objects.equals(this.watchedColumns, that.watchedColumns) && this.direction == that.direction;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.nodeFullId, this.previousNodeFullId, this.watchedColumns, this.direction});
        }
    }

    public static class RecipeColumnRelations {
        public Set<ColumnRelation> columnRelations;
        public LineageState lineageState;
        public boolean ignoreAutoComputed = false;
    }

    public static class SerializedGraphNodes {
        public List<SerializedDataset> datasets;
        public List<SavedModel> savedModels;

        public SerializedGraphNodes(List<SerializedDataset> datasets, List<SavedModel> savedModels) {
            this.datasets = datasets;
            this.savedModels = savedModels;
        }
    }

    @UIModel
    public static class DataStewardLineageDTO {
        public String login;
        public String email;
        public String displayedName;
        public boolean isDeleted;
        public List<String> ownedUpstreamDatasets = new ArrayList<String>();
        public List<String> ownedDownstreamDatasets = new ArrayList<String>();
    }

    @UIModel
    public static class DataStewardsLineageDTO {
        public List<DataStewardLineageDTO> visibleDatastewards = new ArrayList<DataStewardLineageDTO>();
        public int hiddenDatastewardsBothCount;
        public int hiddenDatastewardsUpstreamCount;
        public int hiddenDatastewardsDownstreamCount;
    }
}

