/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.frontend.LogEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.util.DKUNumberUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FrontendLoggingService {
    private static final DKULogger logger = DKULogger.getLogger(FrontendLoggingService.class);
    private static final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyy/MM/dd-HH:mm:ss");
    @Autowired
    PubSubService pubSub;

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init frontend logging service");
        try {
            String runDir = System.getenv("DKURUNDIR");
            if (StringUtils.isBlank((String)runDir)) {
                logger.error((Object)"Unable to configure frontend logging because DKURUNDIR is not defined");
                return;
            }
            File runDirFile = new File(runDir);
            if (!runDirFile.isDirectory()) {
                runDirFile.mkdirs();
            }
            int size = DKUApp.getParams().getIntParam("dip.frontend.log.max-size.bytes", Integer.valueOf(0x3200000));
            int nbFiles = DKUApp.getParams().getIntParam("dip.frontend.log.nb-files", Integer.valueOf(5));
            logger.info((Object)String.format("Setting front end log size to %s with a maximum of %d files", DKUNumberUtils.printSmartBytesSize(size), nbFiles));
            final FileHandler fileHandler = new FileHandler(runDir + "/frontend.log", size, nbFiles, true);
            fileHandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord logRecord) {
                    return logRecord.getMessage() + "\n";
                }
            });
            this.pubSub.subscribe("log-event", (DSSEventListener)new DSSEventListener<LogEvent>(){

                public void on(LogEvent evt) {
                    StringBuilder sb = new StringBuilder();
                    String formattedDate = dateFormatter.print(evt.timestamp);
                    sb.append("[").append(formattedDate).append("] ").append("[").append(evt.getWebSocketSessionId()).append("-").append(evt.getUserLogin()).append("] [").append((Object)evt.type).append("] ");
                    if (!StringUtils.isBlank((String)evt.namespace)) {
                        sb.append("[").append(evt.namespace).append("] ");
                    }
                    sb.append(" -");
                    for (String msg : evt.messages) {
                        sb.append(" ").append(msg);
                    }
                    LogRecord record = new LogRecord(Level.INFO, sb.toString());
                    fileHandler.publish(record);
                }
            });
        }
        catch (IOException e) {
            logger.error((Object)"Unable to init frontend logging", (Throwable)e);
        }
        logger.debug((Object)"Done init frontend logging service");
    }
}

